/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.datarule.config;

import com.ruoyi.datarule.handler.DataRuleHandler;
import com.ruoyi.datarule.handler.DataRuleSqlHandler;
import com.ruoyi.datarule.interceptor.DataRuleInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class DataScopeConfiguration {
    private JdbcTemplate jdbcTemplate;

    @Bean
    @ConditionalOnMissingBean(value={DataRuleHandler.class})
    public DataRuleHandler dataRuleHandler() {
        DataRuleHandler dataRuleHandler = new DataRuleHandler(this.jdbcTemplate);
        dataRuleHandler.init();
        return dataRuleHandler;
    }

    @Bean
    @ConditionalOnBean(value={DataRuleHandler.class})
    @ConditionalOnMissingBean(value={DataRuleSqlHandler.class})
    public DataRuleSqlHandler dataScopeHandler(DataRuleHandler dataRuleHandler) {
        return new DataRuleSqlHandler(dataRuleHandler);
    }

    @Bean
    @ConditionalOnBean(value={DataRuleSqlHandler.class, DataRuleHandler.class})
    @ConditionalOnMissingBean(value={DataRuleInterceptor.class})
    public DataRuleInterceptor interceptor(DataRuleSqlHandler dataRuleSqlHandler, DataRuleHandler dataRuleHandler) {
        return new DataRuleInterceptor(dataRuleSqlHandler, dataRuleHandler);
    }

    public DataScopeConfiguration(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

