/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.datarule.handler;

import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.bean.BeanUtils;
import com.ruoyi.datarule.model.DataRuleModel;
import com.ruoyi.datarule.model.RoleDataRuleModel;
import com.ruoyi.datarule.model.TreeEntityModel;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class DataRuleHandler {
    HashMap<String, List<String>> roleDataRuleModelHashMap = new HashMap();
    HashMap<String, DataRuleModel> dataRuleModelHashMap = new HashMap();
    HashMap<String, Map<String, Object>> userModelHashMap = new HashMap();
    HashMap<String, List<TreeEntityModel>> treeEntityModelMap = new HashMap();
    private final JdbcTemplate jdbcTemplate;

    public void init() {
        List list = this.jdbcTemplate.query("select * from sys_data_rule where del_flag = ?", new Object[]{0}, (RowMapper)new BeanPropertyRowMapper(DataRuleModel.class));
        list.forEach(item -> {
            this.dataRuleModelHashMap.put(item.getScopeClass(), (DataRuleModel)item);
            if (StringUtils.isEmpty((String)item.getTableName())) {
                return;
            }
            List treeEntityModelList = this.jdbcTemplate.query(String.format("select * from %s where del_flag = ?", item.getTableName()), new Object[]{0}, (RowMapper)new BeanPropertyRowMapper(TreeEntityModel.class));
            this.treeEntityModelMap.put(item.getTableName(), treeEntityModelList);
        });
        this.refreshRole();
    }

    public DataRuleModel getDataRuleModel(String mapperId) {
        if (this.dataRuleModelHashMap.containsKey(mapperId)) {
            return this.dataRuleModelHashMap.get(mapperId);
        }
        return null;
    }

    public List<Long> getChildren(String tableName, String id) {
        if (!this.treeEntityModelMap.containsKey(tableName)) {
            List treeEntityModelList = this.jdbcTemplate.query(String.format("select * from %s where del_flag = ?", tableName), new Object[]{0}, (RowMapper)new BeanPropertyRowMapper(TreeEntityModel.class));
            this.treeEntityModelMap.put(tableName, treeEntityModelList);
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        List<TreeEntityModel> treeEntityModelList = this.treeEntityModelMap.get(tableName);
        treeEntityModelList.forEach(item -> {
            if (item.getId().equals(id) || !StringUtils.isEmpty((String)item.getAncestors()) && item.getAncestors().contains(id + ",")) {
                idList.add(item.getId());
            }
        });
        return idList;
    }

    public void refreshTreeEntity(String tableName) {
        List treeEntityModelList = this.jdbcTemplate.query(String.format("select * from %s where del_flag = ?", tableName), new Object[]{0}, (RowMapper)new BeanPropertyRowMapper(TreeEntityModel.class));
        this.treeEntityModelMap.put(tableName, treeEntityModelList);
    }

    public void refreshRole() {
        List roleDataRuleModelList = this.jdbcTemplate.query("select * from sys_role_data_rule", new Object[0], (RowMapper)new BeanPropertyRowMapper(RoleDataRuleModel.class));
        this.roleDataRuleModelHashMap.clear();
        roleDataRuleModelList.forEach(item -> {
            if (!this.roleDataRuleModelHashMap.containsKey(item.getRoleId())) {
                this.roleDataRuleModelHashMap.put(item.getRoleId(), new ArrayList());
            }
            this.roleDataRuleModelHashMap.get(item.getRoleId()).add(item.getDataRuleId());
        });
    }

    public void refreshDataRule(String id) {
        DataRuleModel dataRuleModel = (DataRuleModel)this.jdbcTemplate.queryForObject("select * from sys_data_rule where id = ?", new Object[]{id}, (RowMapper)new BeanPropertyRowMapper(DataRuleModel.class));
        for (Map.Entry<String, DataRuleModel> entry : this.dataRuleModelHashMap.entrySet()) {
            if (!entry.getValue().getId().equals(id)) continue;
            this.dataRuleModelHashMap.remove(entry.getKey());
            break;
        }
        this.dataRuleModelHashMap.put(dataRuleModel.getScopeClass(), dataRuleModel);
        if (StringUtils.isEmpty((String)dataRuleModel.getTableName())) {
            return;
        }
        List treeEntityModelList = this.jdbcTemplate.query(String.format("select * from %s where del_flag = ?", dataRuleModel.getTableName()), new Object[]{0}, (RowMapper)new BeanPropertyRowMapper(TreeEntityModel.class));
        this.treeEntityModelMap.put(dataRuleModel.getTableName(), treeEntityModelList);
    }

    public void deleteDataRule(String id) {
        for (Map.Entry<String, DataRuleModel> entry : this.dataRuleModelHashMap.entrySet()) {
            if (!entry.getValue().getId().equals(id)) continue;
            this.dataRuleModelHashMap.remove(entry.getKey());
            break;
        }
    }

    public DataRuleModel getDataRule(String mapperId, List<SysRole> roleList) {
        for (SysRole sysRole : roleList) {
            boolean isMatch;
            String roleId = sysRole.getRoleId().toString();
            DataRuleModel dataRuleModel = this.getDataRuleModel(mapperId);
            if (dataRuleModel == null) {
                return null;
            }
            if (!this.roleDataRuleModelHashMap.containsKey(roleId)) {
                this.refreshRole();
                if (!this.roleDataRuleModelHashMap.containsKey(roleId)) continue;
            }
            if (!(isMatch = this.roleDataRuleModelHashMap.get(roleId).stream().anyMatch(dataRuleModel.getId()::contains))) continue;
            return dataRuleModel;
        }
        return null;
    }

    public void refreshUser(String id) {
        SysUser userModel = (SysUser)this.jdbcTemplate.queryForObject("select * from sys_user where user_id = ?", new Object[]{id}, (RowMapper)new BeanPropertyRowMapper(SysUser.class));
        try {
            Map map = BeanUtils.convertBean((Object)userModel);
            this.userModelHashMap.put(id, map);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public Map<String, Object> getUser(Long id) {
        if (!this.userModelHashMap.containsKey(id)) {
            this.refreshUser("" + id);
        }
        if (this.userModelHashMap.containsKey(id)) {
            return this.userModelHashMap.get(id);
        }
        return null;
    }

    public DataRuleHandler(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

