/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.datarule.handler;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.util.JdbcConstants;
import com.ruoyi.common.core.domain.model.LoginUser;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.datarule.handler.DataRuleHandler;
import com.ruoyi.datarule.model.DataRuleModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.beetl.core.statement.ErrorGrammarProgram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class DataRuleSqlHandler {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static GroupTemplate groupTemplate;
    @Value(value="${spring.datasource.driverClassName}")
    String driverClassName;
    private final DataRuleHandler dataRuleHandler;

    private DbType getDataSourceType() {
        if (this.driverClassName.contains("mysql")) {
            return JdbcConstants.MYSQL;
        }
        if (this.driverClassName.contains("sqlserver")) {
            return JdbcConstants.SQL_SERVER;
        }
        if (this.driverClassName.contains("oracle")) {
            return JdbcConstants.ORACLE;
        }
        return JdbcConstants.MYSQL;
    }

    public String sqlCondition(DataRuleModel dataScope, LoginUser principal, String originalSql) {
        Integer scopeRule = Objects.requireNonNull(dataScope).getScopeType();
        if (1 == scopeRule) {
            return null;
        }
        Map<String, Object> userMap = this.dataRuleHandler.getUser(principal.getUserId());
        SQLSelectStatement selectStmt = (SQLSelectStatement)SQLUtils.parseSingleStatement((String)originalSql, (DbType)this.getDataSourceType(), (SQLParserFeature[])new SQLParserFeature[0]);
        SQLSelectQueryBlock mySqlSelectQueryBlock = (SQLSelectQueryBlock)selectStmt.getSelect().getQuery();
        SQLLimit limit = mySqlSelectQueryBlock.getLimit();
        mySqlSelectQueryBlock.setLimit(null);
        String tempSql = selectStmt.toString();
        String result = "";
        if (5 == scopeRule) {
            Template template = groupTemplate.getTemplate(StringEscapeUtils.unescapeHtml4((String)dataScope.getScopeValue()));
            if (template.program instanceof ErrorGrammarProgram) {
                this.logger.info(((ErrorGrammarProgram)template.program).getException().detailCode);
            }
            userMap.forEach((arg_0, arg_1) -> ((Template)template).binding(arg_0, arg_1));
            String whereSql = template.render();
            result = String.format(" select %s from (%s) scope " + whereSql, dataScope.getScopeField(), tempSql);
        } else if (2 == scopeRule) {
            String whereSql = "where scope.%s = '%s'";
            String id = principal.getUserId().toString();
            result = String.format(" select %s from (%s) scope " + whereSql, dataScope.getScopeField(), tempSql, dataScope.getScopeColumn(), id);
        } else if (3 == scopeRule) {
            String id = userMap.get(dataScope.getUserEntityField()).toString();
            if (StringUtils.isEmpty((String)id)) {
                this.logger.error(String.format("DataRuleSqlHandler OWN_ORG error id is not exist userId:%s,UserColumn\uff1a%s", principal.getUserId(), dataScope.getUserEntityField()));
                return null;
            }
            result = String.format("select %s from (%s) scope, %s a, sys_user sysu where a.id = sysu.%s and sysu.id = scope.%s and a.id = '%s'", dataScope.getScopeField(), tempSql, dataScope.getTableName(), dataScope.getUserColumn(), dataScope.getScopeColumn(), id);
        } else if (4 == scopeRule) {
            String id = userMap.get(dataScope.getUserEntityField()).toString();
            if (StringUtils.isEmpty((String)id)) {
                this.logger.error(String.format("DataRuleSqlHandler OWN_ORG_CHILDREN error id is not exist userId:%s,UserColumn\uff1a%s", principal.getUserId(), dataScope.getUserEntityField()));
                return null;
            }
            ArrayList<Object> ids = new ArrayList<Object>();
            ids.add(id);
            List<Long> deptIdList = this.dataRuleHandler.getChildren(dataScope.getTableName(), id);
            ids.addAll(deptIdList);
            id = StringUtils.join(ids, (String)"','");
            result = String.format("select %s from (%s) scope, %s a, sys_user sysu where a.id = sysu.%s and sysu.id = scope.%s and a.id in ('%s')", dataScope.getScopeField(), tempSql, dataScope.getTableName(), dataScope.getUserColumn(), dataScope.getScopeColumn(), id);
        }
        SQLSelectStatement selectStmtResult = (SQLSelectStatement)SQLUtils.parseSingleStatement((String)result, (DbType)this.getDataSourceType(), (SQLParserFeature[])new SQLParserFeature[0]);
        SQLSelectQueryBlock mySqlSelectQueryBlockResult = (SQLSelectQueryBlock)selectStmtResult.getSelect().getQuery();
        mySqlSelectQueryBlockResult.setLimit(limit);
        this.logger.info(String.format("result sql: %s", selectStmtResult));
        return selectStmtResult.toString();
    }

    public DataRuleSqlHandler(DataRuleHandler dataRuleHandler) {
        this.dataRuleHandler = dataRuleHandler;
    }

    static {
        StringTemplateResourceLoader resourceLoader = new StringTemplateResourceLoader();
        Configuration configuration = null;
        try {
            configuration = Configuration.defaultConfiguration();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        groupTemplate = new GroupTemplate((ResourceLoader)resourceLoader, configuration);
    }
}

