/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.datarule.interceptor;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.handlers.AbstractSqlParserHandler;
import com.ruoyi.common.core.domain.model.LoginUser;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.bean.BeanUtils;
import com.ruoyi.datarule.handler.DataRuleHandler;
import com.ruoyi.datarule.handler.DataRuleSqlHandler;
import com.ruoyi.datarule.model.DataRuleModel;
import java.sql.Connection;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DataRuleInterceptor
extends AbstractSqlParserHandler
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DataRuleInterceptor.class);
    private final DataRuleSqlHandler dataRuleSqlHandler;
    private final DataRuleHandler dataRuleHandler;

    public Object intercept(Invocation invocation) throws Throwable {
        String sqlCondition;
        LoginUser principal = SecurityUtils.getLoginUser();
        if (principal == null) {
            return invocation.proceed();
        }
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        this.sqlParser(metaObject);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        if (SqlCommandType.SELECT != mappedStatement.getSqlCommandType() || StatementType.CALLABLE == mappedStatement.getStatementType()) {
            return invocation.proceed();
        }
        BoundSql boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
        String originalSql = boundSql.getSql();
        String mapperId = mappedStatement.getId();
        DataRuleModel dataScope = this.dataRuleHandler.getDataRule(mapperId = mapperId.replace("_mpCount", ""), principal.getUser().getRoles());
        if (dataScope == null) {
            return invocation.proceed();
        }
        if (mappedStatement.getId().contains("_mpCount")) {
            dataScope = (DataRuleModel)BeanUtils.clone((Object)dataScope);
            dataScope.setScopeField("COUNT(*)");
            originalSql = originalSql.replace("COUNT(*)", "*");
        }
        if (StringUtils.isBlank((CharSequence)(sqlCondition = this.dataRuleSqlHandler.sqlCondition(dataScope, principal, originalSql)))) {
            return invocation.proceed();
        }
        metaObject.setValue("delegate.boundSql.sql", (Object)sqlCondition);
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    public DataRuleInterceptor(DataRuleSqlHandler dataRuleSqlHandler, DataRuleHandler dataRuleHandler) {
        this.dataRuleSqlHandler = dataRuleSqlHandler;
        this.dataRuleHandler = dataRuleHandler;
    }
}

