/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.common.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.TreeEntity;
import com.ruoyi.common.core.mapper.BaseTreeMapper;
import com.ruoyi.common.core.service.ITreeCommonService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class TreeCommonServiceImpl<M extends BaseTreeMapper<T>, T extends TreeEntity>
extends ServiceImpl<M, T>
implements ITreeCommonService<T> {
    public T getById(Serializable id) {
        return (T)((TreeEntity)((BaseTreeMapper)this.baseMapper).selectByTreeId(id));
    }

    @Override
    public List<T> selectTreeList(Wrapper<T> wrapper) {
        List<T> content = ((BaseTreeMapper)this.baseMapper).selectTreeList(wrapper);
        return content;
    }

    public boolean save(T entity) {
        if (((TreeEntity)entity).getParentId() != null && ((TreeEntity)entity).getParentId() != 0L) {
            Object parent = this.getById(((TreeEntity)entity).getParentId());
            ((TreeEntity)entity).setParentId(((TreeEntity)parent).getId());
            ((TreeEntity)entity).setAncestors(((TreeEntity)parent).makeSelfAsNewParentIds());
        } else {
            ((TreeEntity)entity).setParentId(null);
        }
        return super.save(entity);
    }

    public boolean updateById(T entity) {
        if (((TreeEntity)entity).getParentId() != null && ((TreeEntity)entity).getParentId() != 0L) {
            Object parent = this.getById(((TreeEntity)entity).getParentId());
            this.updateSelftAndChild(entity, ((TreeEntity)parent).getId(), ((TreeEntity)parent).makeSelfAsNewParentIds());
        } else {
            ((TreeEntity)entity).setParentId(null);
            this.updateSelftAndChild(entity, 0L, "0,");
        }
        return true;
    }

    private void updateSelftAndChild(T entity, Long newParentId, String newParentIds) {
        Object oldEntity = this.getById(((TreeEntity)entity).getId());
        String oldChildrenParentIds = ((TreeEntity)oldEntity).makeSelfAsNewParentIds();
        ((TreeEntity)entity).setParentId(newParentId);
        ((TreeEntity)entity).setAncestors(newParentIds);
        super.updateById(entity);
        String newChildrenParentIds = ((TreeEntity)entity).makeSelfAsNewParentIds();
        ((BaseTreeMapper)this.baseMapper).updateSunTreeParentIds(newChildrenParentIds, oldChildrenParentIds);
    }

    public boolean removeById(Serializable id) {
        Object entity = this.getById(id);
        ((BaseTreeMapper)this.baseMapper).deleteSunTree(((TreeEntity)entity).makeSelfAsNewParentIds());
        return super.removeById(id);
    }

    public boolean removeByIds(Collection<? extends Serializable> idList) {
        for (Serializable serializable : idList) {
            this.removeById(serializable);
        }
        return true;
    }
}

