/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.common.utils;

import com.ruoyi.common.utils.StringUtils;

public abstract class ObjectSwitchHelper {
    public void setString(String key, String value) {
        this.set(key, value);
    }

    public void setInt(String key, int value) {
        this.setString(key, String.valueOf(value));
    }

    public void setBoolean(String key, Boolean value) {
        this.setString(key, String.valueOf(value));
    }

    public void setByte(String key, byte[] value) {
        this.setString(key, String.valueOf(value));
    }

    public void setShort(String key, short value) {
        this.setString(key, String.valueOf(value));
    }

    public void setLong(String key, long value) {
        this.setString(key, String.valueOf(value));
    }

    public void setFloat(String key, float value) {
        this.setString(key, String.valueOf(value));
    }

    public void setDouble(String key, double value) {
        this.setString(key, String.valueOf(value));
    }

    public String getString(String key) {
        if (this.get(key) == null) {
            return "";
        }
        return String.valueOf(this.get(key));
    }

    public int getInt(String key) {
        return Integer.valueOf(this.getString(key));
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.getString(key));
    }

    public byte[] getByte(String key) {
        return this.getString(key).getBytes();
    }

    public short getShort(String key) {
        return Short.valueOf(this.getString(key, ""));
    }

    public long getLong(String key) {
        return Long.valueOf(this.getString(key));
    }

    public float getFloat(String key) {
        return Float.valueOf(this.getString(key)).floatValue();
    }

    public double getDouble(String key) {
        return Double.valueOf(this.getString(key));
    }

    public String getString(String key, String defaultValue) {
        return this.get(key) != null && !StringUtils.isEmpty((String)this.get(key)) ? String.valueOf(this.get(key)) : defaultValue;
    }

    public int getInt(String key, int defaultValue) {
        try {
            return Integer.valueOf(this.getString(key, ""));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key, Boolean defaultValue) {
        try {
            return Boolean.valueOf(this.getString(key, ""));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public byte[] getByte(String key, byte[] defaultValue) {
        try {
            return this.getString(key, "").getBytes();
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public short getShort(String key, Short defaultValue) {
        try {
            return Short.valueOf(this.getString(key, ""));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public long getLong(String key, Long defaultValue) {
        try {
            return Long.valueOf(this.getString(key, ""));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public float getFloat(String key, Float defaultValue) {
        try {
            return Float.valueOf(this.getString(key, "")).floatValue();
        }
        catch (Exception exception) {
            return defaultValue.floatValue();
        }
    }

    public double getDouble(String key, Double defaultValue) {
        try {
            return Double.valueOf(this.getString(key, ""));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public void remove(String ... keys) {
        for (String key : keys) {
            this.remove(key);
        }
    }

    public abstract Object get(String var1);

    public abstract void set(String var1, Object var2);

    public abstract boolean remove(String var1);
}

