/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.common.utils;

import com.ruoyi.common.utils.ObjectSwitchHelper;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.file.FileUtils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtil
extends ObjectSwitchHelper {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Properties properties;
    private String[] resourcesPaths;
    private String properiesName = "";

    public PropertiesUtil() {
    }

    public static PropertiesUtil create(String ... resourcesPaths) {
        PropertiesUtil propertiesUtil = new PropertiesUtil(resourcesPaths);
        return propertiesUtil;
    }

    public PropertiesUtil(String ... resourcesPaths) {
        this.load(resourcesPaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void load(String ... resourcesPaths) {
        this.resourcesPaths = resourcesPaths;
        this.properties = new Properties();
        for (String location : resourcesPaths) {
            this.logger.debug("Loading properties file from:" + location);
            InputStream is = null;
            try {
                is = PropertiesUtil.class.getClassLoader().getResourceAsStream(location);
                this.properties.load(is);
            }
            catch (IOException ex) {
                this.logger.info("Could not load properties from path:" + location + ", " + ex.getMessage());
                IOUtils.closeQuietly((InputStream)is);
                continue;
            }
            catch (Exception ex2) {
                this.logger.info("Could not load properties from path:" + location + ", " + ex2.getMessage());
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)is);
                continue;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public void setOptProperiesName(String properiesName) {
        this.properiesName = properiesName;
    }

    @Override
    public Object get(String key) {
        if (this.properties.containsKey(key)) {
            return this.properties.getProperty(key);
        }
        return "";
    }

    public String getAbsolutePath(String filename) {
        if (!FileUtils.isAbsolutePath(filename)) {
            filename = PropertiesUtil.class.getClassLoader().getResource(filename).getPath();
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, Object value) {
        block6: {
            if (StringUtils.isEmpty(this.properiesName)) {
                this.properiesName = this.resourcesPaths[0];
            }
            FileInputStream is = null;
            FileOutputStream os = null;
            Properties p = new Properties();
            try {
                FileUtils.createFile(this.getAbsolutePath(this.properiesName));
                is = new FileInputStream(this.getAbsolutePath(this.properiesName));
                p.load(is);
                os = new FileOutputStream(this.getAbsolutePath(this.properiesName));
                p.setProperty(key, value + "");
                p.store(os, "====\u914d\u7f6e\u66f4\u65b0====");
                os.flush();
                ((OutputStream)os).close();
                IOUtils.closeQuietly((InputStream)is);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(os);
            }
            IOUtils.closeQuietly((OutputStream)os);
        }
        this.properiesName = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Map<String, Object> dataMap) {
        block7: {
            if (StringUtils.isEmpty(this.properiesName)) {
                this.properiesName = this.resourcesPaths[0];
            }
            FileInputStream is = null;
            FileOutputStream os = null;
            Properties p = new Properties();
            try {
                FileUtils.createFile(this.getAbsolutePath(this.properiesName));
                is = new FileInputStream(this.getAbsolutePath(this.properiesName));
                p.load(is);
                os = new FileOutputStream(this.getAbsolutePath(this.properiesName));
                for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                    p.setProperty(entry.getKey(), entry.getValue() + "");
                }
                p.store(os, "====\u914d\u7f6e\u66f4\u65b0====");
                os.flush();
                ((OutputStream)os).close();
                IOUtils.closeQuietly((InputStream)is);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(os);
            }
            IOUtils.closeQuietly((OutputStream)os);
        }
        this.properiesName = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String key) {
        block6: {
            if (StringUtils.isEmpty(this.properiesName)) {
                this.properiesName = this.resourcesPaths[0];
            }
            FileInputStream is = null;
            FileOutputStream os = null;
            Properties p = new Properties();
            try {
                is = new FileInputStream(this.getAbsolutePath(this.properiesName));
                p.load(is);
                os = new FileOutputStream(this.getAbsolutePath(this.properiesName));
                p.remove(key);
                p.store(os, "");
                os.flush();
                ((OutputStream)os).close();
                IOUtils.closeQuietly((InputStream)is);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(os);
            }
            IOUtils.closeQuietly((OutputStream)os);
        }
        this.properiesName = "";
        return false;
    }

    public static void main(String[] args) {
        String properiesName = "generation/generation_config.properties";
        PropertiesUtil propertiesUtil = new PropertiesUtil(properiesName);
        String sdfsdf = propertiesUtil.getString("project_path");
        System.out.println(sdfsdf);
    }
}

