/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.common.utils.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.lang.Nullable;

public class BeanUtils
extends org.springframework.beans.BeanUtils {
    private static final int BEAN_METHOD_PROP_INDEX = 3;
    private static final Pattern GET_PATTERN = Pattern.compile("get(\\p{javaUpperCase}\\w*)");
    private static final Pattern SET_PATTERN = Pattern.compile("set(\\p{javaUpperCase}\\w*)");

    public static void copyBeanProp(Object dest, Object src) {
        try {
            BeanUtils.copyProperties((Object)src, (Object)dest);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<Method> getSetterMethods(Object obj) {
        Method[] methods;
        ArrayList<Method> setterMethods = new ArrayList<Method>();
        for (Method method : methods = obj.getClass().getMethods()) {
            Matcher m = SET_PATTERN.matcher(method.getName());
            if (!m.matches() || method.getParameterTypes().length != 1) continue;
            setterMethods.add(method);
        }
        return setterMethods;
    }

    public static List<Method> getGetterMethods(Object obj) {
        Method[] methods;
        ArrayList<Method> getterMethods = new ArrayList<Method>();
        for (Method method : methods = obj.getClass().getMethods()) {
            Matcher m = GET_PATTERN.matcher(method.getName());
            if (!m.matches() || method.getParameterTypes().length != 0) continue;
            getterMethods.add(method);
        }
        return getterMethods;
    }

    public static boolean isMethodPropEquals(String m1, String m2) {
        return m1.substring(3).equals(m2.substring(3));
    }

    public static Map<String, Object> convertBean(Object bean) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Class<?> type = bean.getClass();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        BeanInfo beanInfo = Introspector.getBeanInfo(type);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName();
            if (propertyName.equals("class")) continue;
            Method readMethod = descriptor.getReadMethod();
            Object result = readMethod.invoke(bean, new Object[0]);
            if (result != null) {
                returnMap.put(propertyName, result);
                continue;
            }
            returnMap.put(propertyName, "");
        }
        return returnMap;
    }

    @Nullable
    public static <T> T clone(@Nullable T source) {
        if (source == null) {
            return null;
        }
        return (T)BeanUtils.copy(source, source.getClass());
    }

    @Nullable
    public static <T> T copy(@Nullable Object source, Class<T> clazz) {
        if (source == null) {
            return null;
        }
        return BeanUtils.copy(source, source.getClass(), clazz);
    }

    @Nullable
    public static <T> T copy(@Nullable Object source, Class sourceClazz, Class<T> targetClazz) {
        if (source == null) {
            return null;
        }
        BeanCopier copier = BeanCopier.create((Class)sourceClazz, targetClazz, (boolean)false);
        T to = BeanUtils.newInstance(targetClazz);
        copier.copy(source, to, null);
        return to;
    }

    public static <T> T newInstance(Class<?> clazz) {
        return (T)BeanUtils.instantiateClass(clazz);
    }
}

