/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.oss.client;

import com.aliyun.oss.OSSClient;
import com.ruoyi.common.utils.PropertiesUtil;
import com.ruoyi.oss.client.AbstractOSSClient;
import com.ruoyi.oss.config.AliyunConfig;
import com.ruoyi.oss.config.OssConfig;
import com.ruoyi.oss.exception.OSSException;
import java.io.InputStream;

public class AliyunOSSClient
extends AbstractOSSClient {
    public static final String DEFAULT_CONFIG_FILE = "aliyun.oss.properties";
    private OSSClient client;
    private String endpoint;
    private String accessKeyId;
    private String accessKeySecret;
    private String domain;
    private String bucketName;

    @Override
    public void init() {
        this.init(DEFAULT_CONFIG_FILE);
    }

    @Override
    public void init(String propertiesName) {
        PropertiesUtil p = new PropertiesUtil(new String[]{propertiesName});
        this.endpoint = p.getString("aliyun.oss.endpoint");
        this.accessKeyId = p.getString("aliyun.oss.access-key-id");
        this.accessKeySecret = p.getString("aliyun.oss.access-key-secret");
        this.bucketName = p.getString("aliyun.oss.bucket-name");
        this.domain = p.getString("aliyun.oss.domain");
        this.client = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
    }

    @Override
    public void init(OssConfig config) {
        AliyunConfig aliyunConfig = config.getAliyun();
        this.endpoint = aliyunConfig.getEndpoint();
        this.accessKeyId = aliyunConfig.getAccessKeyId();
        this.accessKeySecret = aliyunConfig.getAccessKeySecret();
        this.bucketName = aliyunConfig.getBucketName();
        this.domain = aliyunConfig.getDomain();
        this.client = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
    }

    public OSSClient getClient() {
        return this.client;
    }

    @Override
    public String upload(InputStream inputStream, String path) {
        try {
            this.client.putObject(this.bucketName, path, inputStream);
        }
        catch (Exception e) {
            throw new OSSException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", e);
        }
        return this.domain + "/" + path;
    }

    @Override
    public void delete(String filename) {
        try {
            filename = filename.replace(this.domain + "/", "");
            this.client.deleteObject(this.bucketName, filename);
        }
        catch (Exception e) {
            throw new OSSException("\u5220\u9664\u6587\u4ef6\u5931\u8d25", e);
        }
    }
}

