/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.oss.utils;

import com.ruoyi.oss.OSSUploadHelper;
import com.ruoyi.oss.config.OssConfig;
import com.ruoyi.oss.exception.FileNameLengthLimitExceededException;
import com.ruoyi.oss.exception.InvalidExtensionException;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileUploadBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component(value="attachmentHelper")
@EnableConfigurationProperties(value={OssConfig.class})
public class AttachmentHelper {
    @Autowired
    private OssConfig ossConfig;
    private OSSUploadHelper uploadHelper;

    @PostConstruct
    public void initHelper() {
        this.uploadHelper = new OSSUploadHelper();
        this.uploadHelper.init(this.ossConfig);
    }

    public String upload(HttpServletRequest request, MultipartFile file) throws FileUploadBase.FileSizeLimitExceededException, IOException, FileNameLengthLimitExceededException, InvalidExtensionException {
        String basePath = request.getParameter("directory");
        return this.upload(request, file, basePath);
    }

    public String upload(HttpServletRequest request, MultipartFile file, String directory) throws FileUploadBase.FileSizeLimitExceededException, IOException, FileNameLengthLimitExceededException, InvalidExtensionException {
        String url = this.uploadHelper.upload(request, file, directory);
        return url;
    }

    public String remote(HttpServletRequest request, String remoteUrl) throws FileUploadBase.FileSizeLimitExceededException, IOException, FileNameLengthLimitExceededException, InvalidExtensionException {
        String basePath = request.getParameter("base_path");
        String url = this.uploadHelper.remote(request, remoteUrl, basePath);
        return url;
    }
}

