/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysDataRule;
import com.ruoyi.datarule.handler.DataRuleHandler;
import com.ruoyi.system.domain.SysRoleDataRule;
import com.ruoyi.system.mapper.SysDataRuleMapper;
import com.ruoyi.system.mapper.SysRoleDataRuleMapper;
import com.ruoyi.system.service.ISysDataRuleService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class SysDataRuleServiceImpl
extends ServiceImpl<SysDataRuleMapper, SysDataRule>
implements ISysDataRuleService {
    @Autowired
    private DataRuleHandler dataRuleHandler;
    @Autowired
    private SysRoleDataRuleMapper roleDataRuleMapper;

    public boolean updateById(SysDataRule entity) {
        boolean result = super.updateById((Object)entity);
        this.dataRuleHandler.refreshDataRule(entity.getId());
        return result;
    }

    public boolean save(SysDataRule entity) {
        boolean save = super.save((Object)entity);
        this.dataRuleHandler.refreshDataRule(entity.getId());
        return save;
    }

    public boolean saveOrUpdate(SysDataRule entity) {
        boolean result = super.saveOrUpdate((Object)entity);
        this.dataRuleHandler.refreshDataRule(entity.getId());
        return result;
    }

    public boolean removeById(Serializable id) {
        boolean result = super.removeById(id);
        this.roleDataRuleMapper.delete((Wrapper)new QueryWrapper().eq((Object)"role_id", (Object)id));
        this.dataRuleHandler.deleteDataRule(String.valueOf(id));
        return result;
    }

    public boolean removeByIds(Collection<? extends Serializable> idList) {
        boolean result = super.removeByIds(idList);
        idList.forEach(id -> {
            this.roleDataRuleMapper.delete((Wrapper)new QueryWrapper().eq((Object)"role_id", id));
            this.dataRuleHandler.deleteDataRule(String.valueOf(id));
        });
        return result;
    }

    @Override
    public List<SysRoleDataRule> roleDataList(QueryWrapper<SysRoleDataRule> roleDataRuleEntityWrapper) {
        return this.roleDataRuleMapper.selectList((Wrapper)roleDataRuleEntityWrapper);
    }

    @Override
    public void removeRoleDataRule(QueryWrapper<SysRoleDataRule> roleDataRuleEntityWrapper) {
        this.roleDataRuleMapper.delete((Wrapper)roleDataRuleEntityWrapper);
    }

    @Override
    public void insertBatchRoleDataRule(List<SysRoleDataRule> roleDataRuleList) {
        roleDataRuleList.forEach(item -> this.roleDataRuleMapper.insert(item));
    }
}

