/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.framework.web.service;

import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.domain.model.LoginUser;
import com.ruoyi.common.enums.UserStatus;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.framework.web.service.SysPermissionService;
import com.ruoyi.framework.web.service.SysUserUPAuth;
import com.ruoyi.system.service.ISysUserService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class SysUserUPAuthProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(SysUserUPAuthProvider.class);
    @Resource
    private ISysUserService sysUserService;
    @Resource
    private SysPermissionService permissionService;
    @Resource
    private BCryptPasswordEncoder bCryptPasswordEncoder;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        SysUser sysUser;
        SysUserUPAuth authToken = (SysUserUPAuth)authentication;
        String username = ((SysUserUPAuth)authentication).getUsername();
        String tenantId = ((SysUserUPAuth)authentication).getTenantId();
        if (StringUtils.isEmpty((String)tenantId)) {
            tenantId = "00000000";
        }
        if (StringUtils.isNull((Object)(sysUser = this.sysUserService.selectUserByUserNameAndTenantId(username, tenantId)))) {
            log.info("\u767b\u5f55\u7528\u6237\uff1a{} \u4e0d\u5b58\u5728.", (Object)username);
            throw new UsernameNotFoundException("\u767b\u5f55\u7528\u6237\uff1a" + username + " \u4e0d\u5b58\u5728");
        }
        if (UserStatus.DELETED.getCode().equals(sysUser.getDelFlag())) {
            log.info("\u767b\u5f55\u7528\u6237\uff1a{} \u5df2\u88ab\u5220\u9664.", (Object)username);
            throw new BaseException("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8d26\u53f7\uff1a" + username + " \u5df2\u88ab\u5220\u9664");
        }
        if (UserStatus.DISABLE.getCode().equals(sysUser.getStatus())) {
            log.info("\u767b\u5f55\u7528\u6237\uff1a{} \u5df2\u88ab\u505c\u7528.", (Object)username);
            throw new BaseException("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8d26\u53f7\uff1a" + username + " \u5df2\u505c\u7528");
        }
        boolean matches = this.bCryptPasswordEncoder.matches((CharSequence)authToken.getPassword(), sysUser.getPassword());
        if (!matches) {
            log.info("\u767b\u9646\u5931\u8d25\uff1a\u7528\u6237" + ((SysUserUPAuth)authentication).getUsername() + "\u5bc6\u7801\u9519\u8bef!");
            throw new BadCredentialsException("\u767b\u5f55\u5931\u8d25: \u7528\u6237\u5bc6\u7801\u9519\u8bef");
        }
        authToken.setDetails(this.createLoginUser(sysUser));
        authToken.setAuthenticated(true);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authToken);
        return authToken;
    }

    public boolean supports(Class<?> authentication) {
        return SysUserUPAuth.class.isAssignableFrom(authentication);
    }

    public LoginUser createLoginUser(SysUser user) {
        return new LoginUser(user, this.permissionService.getMenuPermission(user));
    }
}

