import request from '@/utils/request'

// 查询【请填写功能名称】列表
export function listMark(query) {
  return request({
    url: '/system/mark/list',
    method: 'get',
    params: query
  })
}

// 查询【请填写功能名称】详细
export function getMark(id) {
  return request({
    url: '/system/mark/' + id,
    method: 'get'
  })
}

// 新增【请填写功能名称】
export function addMark(data) {
  return request({
    url: '/system/mark',
    method: 'post',
    data: data
  })
}

// 修改【请填写功能名称】
export function updateMark(data) {
  return request({
    url: '/system/mark',
    method: 'put',
    data: data
  })
}

// 删除【请填写功能名称】
export function delMark(id) {
  return request({
    url: '/system/mark/' + id,
    method: 'delete'
  })
}

// 导出【请填写功能名称】
export function exportMark(query) {
  return request({
    url: '/system/mark/export',
    method: 'get',
    params: query
  })
}
//点位图片比较
export function compared(data) {
  return request({
    url: '/system/info/compared',
    method: 'post',
    data: data
  })
}