import request from '@/utils/request'

// 查询电厂管理列表
export function listTenant(query) {
  return request({
    url: '/system/tenant/list',
    method: 'get',
    params: query
  })
}

// 查询电厂管理详细
export function getTenant(infoId) {
  return request({
    url: '/system/tenant/' + infoId,
    method: 'get'
  })
}

// 新增电厂管理
export function addTenant(data) {
  return request({
    url: '/system/tenant',
    method: 'post',
    data: data
  })
}

// 修改电厂管理
export function updateTenant(data) {
  return request({
    url: '/system/tenant',
    method: 'put',
    data: data
  })
}

// 删除电厂管理
export function delTenant(infoId) {
  return request({
    url: '/system/tenant/' + infoId,
    method: 'delete'
  })
}

// 导出电厂管理
export function exportTenant(query) {
  return request({
    url: '/system/tenant/export',
    method: 'get',
    params: query
  })
}


//获取电厂列表
export function Tenantlist(query) {
  return request({
    url: '/system/tenant/tenantList',
    method: 'get',
    params: query
  })
}

