package com.ruoyi.web.controller.system;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.Mark;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.service.IMarkService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 *  标注管理 Controller
 *
 * @author ruoyi
 * @date 2021-11-19
 */
@RestController
@RequestMapping("/system/mark")
public class MarkController extends BaseController
{
    @Autowired
    private IMarkService markService;

    /**
     * 查询标注列表
     */
    @PreAuthorize("@ss.hasPermi('system:overhaul:list')")
    @GetMapping("/list")
    public TableDataInfo list(Mark mark)
    {
        startPage();
        List<Mark> list = markService.selectMarkList(mark);
        return getDataTable(list);
    }

    /**
     * 导出标注列表
     */
    @PreAuthorize("@ss.hasPermi('system:overhaul:export')")
    @Log(title = "标注导出", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(Mark mark)
    {
        List<Mark> list = markService.selectMarkList(mark);
        ExcelUtil<Mark> util = new ExcelUtil<Mark>(Mark.class);
        return util.exportExcel(list, "【请填写功能名称】数据");
    }

    /**
     * 获取标注详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:overhaul:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(markService.selectMarkById(id));
    }

    /**
     * 新增标注
     */
    @PreAuthorize("@ss.hasPermi('system:overhaul:add')")
    @Log(title = "标注新增", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Mark mark)
    {
        return toAjax(markService.insertMark(mark));
    }

    /**
     * 修改标注
     */
    @PreAuthorize("@ss.hasPermi('system:overhaul:edit')")
    @Log(title = "标注修改", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Mark mark)
    {
        return toAjax(markService.updateMark(mark));
    }

    /**
     * 删除标注
     */
    @PreAuthorize("@ss.hasPermi('system:overhaul:remove')")
    @Log(title = "标注删除", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(markService.deleteMarkByIds(ids));
    }
}
