package com.ruoyi.web.controller.system;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.domain.entity.Overhaul;
import com.ruoyi.system.service.IOverhaulService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 检修Controller
 *
 * @author ruoyi
 * @date 2021-11-17
 */
@RestController
@RequestMapping("/system/overhaul")
public class OverhaulController extends BaseController
{
    @Autowired
    private IOverhaulService overhaulService;

    /**
     * 查询检修列表
     */
    @PreAuthorize("@ss.hasPermi('system:overhaul:list')")
    @GetMapping("/list")
    public TableDataInfo list(Overhaul overhaul)
    {
        startPage();
        overhaul.setTenantId(SecurityUtils.getLoginUser().getTenantId());
        List<Overhaul> list = overhaulService.selectOverhaulList(overhaul);
        return getDataTable(list);
    }

    /**
     * 导出检修列表
     */
    @PreAuthorize("@ss.hasPermi('system:overhaul:export')")
    @Log(title = "检修", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(Overhaul overhaul)
    {
        overhaul.setTenantId(SecurityUtils.getLoginUser().getTenantId());
        List<Overhaul> list = overhaulService.selectOverhaulList(overhaul);
        ExcelUtil<Overhaul> util = new ExcelUtil<Overhaul>(Overhaul.class);
        return util.exportExcel(list, "检修数据");
    }

    /**
     * 获取检修详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:overhaul:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(overhaulService.selectOverhaulById(id));
    }

    /**
     * 新增检修
     */
    @PreAuthorize("@ss.hasPermi('system:overhaul:add')")
    @Log(title = "检修", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Overhaul overhaul)
    {
        overhaul.setTenantId(SecurityUtils.getLoginUser().getTenantId());
        return toAjax(overhaulService.insertOverhaul(overhaul));
    }

    /**
     * 修改检修
     */
    @PreAuthorize("@ss.hasPermi('system:overhaul:edit')")
    @Log(title = "检修", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Overhaul overhaul)
    {
        return toAjax(overhaulService.updateOverhaul(overhaul));
    }

    /**
     * 删除检修
     */
    @PreAuthorize("@ss.hasPermi('system:overhaul:remove')")
    @Log(title = "检修", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(overhaulService.deleteOverhaulByIds(ids));
    }
}
