package com.ruoyi.common.core.domain;

import com.ruoyi.common.utils.StringUtils;
import lombok.Data;

/**
 * Tree基类
 *
 * @author ruoyi
 */
@Data
public abstract class TreeEntity extends BaseEntity
{
    private static final long serialVersionUID = 1L;


    /** 父锅炉ID */
    protected Long parentId = 0L;

    /** 祖级列表 */
    protected String ancestors = "0";

    public abstract Long getId();

    public String makeSelfAsNewParentIds() {
        if (StringUtils.isEmpty(getAncestors())) {
            return getId() + ",";
        }
        return getAncestors() + getId() + ",";
    }
}
