package com.ruoyi.common.core.domain.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 检修对象 overhaul
 *
 * @author ruoyi
 * @date 2021-11-17
 */
public class Overhaul extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 检修日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "检修日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date overhaulTime;

    /** 租户id */
    @Excel(name = "租户id")
    private String tenantId;

    /** 点位 */
    @Excel(name = "点位")
    private Long deptId;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setOverhaulTime(Date overhaulTime)
    {
        this.overhaulTime = overhaulTime;
    }

    public Date getOverhaulTime()
    {
        return overhaulTime;
    }
    public void setTenantId(String tenantId)
    {
        this.tenantId = tenantId;
    }

    public String getTenantId()
    {
        return tenantId;
    }
    public void setDeptId(Long deptId)
    {
        this.deptId = deptId;
    }

    public Long getDeptId()
    {
        return deptId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("overhaulTime", getOverhaulTime())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .append("tenantId", getTenantId())
            .append("deptId", getDeptId())
            .toString();
    }
}
