package com.ruoyi.common.core.domain.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ruoyi.common.core.domain.TreeEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;

/**
 * 锅炉表 sys_dept
 *
 * @author ruoyi
 */
@Data
public class SysDept extends TreeEntity
{
    private static final long serialVersionUID = 1L;

    /** 锅炉ID */
    private Long deptId;

    /** 锅炉名称 */
    private String deptName;

    /** 显示顺序 */
    private String orderNum;

    /** 负责人 */
    private String leader;

    /** 联系电话 */
    private String phone;

    /** 邮箱 */
    private String email;

    /** 锅炉状态:0正常,1停用 */
    private String status;

    /** 删除标志（0代表存在 2代表删除） */
    private String delFlag;

    /** 父锅炉名称 */
    @TableField(exist = false)
    private String parentName;

    /** 租户ID */
    private String tenantId;

    /** 子锅炉 */
    @TableField(exist = false)
    private List<SysDept> children = new ArrayList<SysDept>();

    /** 子锅炉 */
    @TableField(exist = false)
    private List<SysFileInfo> fileInfos;

    @NotBlank(message = "锅炉名称不能为空")
    @Size(min = 0, max = 30, message = "锅炉名称长度不能超过30个字符")
    public String getDeptName()
    {
        return deptName;
    }


    @NotBlank(message = "显示顺序不能为空")
    public String getOrderNum()
    {
        return orderNum;
    }


    @Size(min = 0, max = 11, message = "联系电话长度不能超过11个字符")
    public String getPhone()
    {
        return phone;
    }


    @Email(message = "邮箱格式不正确")
    @Size(min = 0, max = 50, message = "邮箱长度不能超过50个字符")
    public String getEmail()
    {
        return email;
    }


    @TableField(exist = false)
    private List<Overhaul>  overhauls;

    @TableField(exist = false)
    private List<Mark>  marks;


    @TableField(exist = false)
    private Integer sequeue;

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("deptId", getDeptId())
            .append("parentId", getParentId())
            .append("ancestors", getAncestors())
            .append("deptName", getDeptName())
            .append("orderNum", getOrderNum())
            .append("leader", getLeader())
            .append("phone", getPhone())
            .append("email", getEmail())
            .append("status", getStatus())
            .append("delFlag", getDelFlag())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
                .append("overhauls",getOverhauls())
                .append("marks",getMarks())
                .append("sequeue",getSequeue())
                .append("fileInfos",getFileInfos())
            .toString();
    }

    @Override
    public Long getId() {
        return getDeptId();
    }
}
