package com.ruoyi.system.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ruoyi.common.core.domain.entity.SysDept;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 锅炉管理 数据层
 *
 * @author ruoyi
 */
public interface SysDeptMapper extends BaseMapper<SysDept>
{
    /**
     * 查询锅炉管理数据
     *
     * @param dept 锅炉信息
     * @return 锅炉信息集合
     */
    public List<SysDept> selectDeptList(SysDept dept);

    /**
     * 根据角色ID查询锅炉树信息
     *
     * @param roleId 角色ID
     * @param deptCheckStrictly 锅炉树选择项是否关联显示
     * @return 选中锅炉列表
     */
    public List<Integer> selectDeptListByRoleId(@Param("roleId") Long roleId, @Param("deptCheckStrictly") boolean deptCheckStrictly);

    /**
     * 根据锅炉ID查询信息
     *
     * @param deptId 锅炉ID
     * @return 锅炉信息
     */
    public SysDept selectDeptById(Long deptId);

    /**
     * 根据ID查询所有子锅炉
     *
     * @param deptId 锅炉ID
     * @return 锅炉列表
     */
    public List<SysDept> selectChildrenDeptById(Long deptId);

    /**
     * 根据ID查询所有子锅炉（正常状态）
     *
     * @param deptId 锅炉ID
     * @return 子锅炉数
     */
    public int selectNormalChildrenDeptById(Long deptId);

    /**
     * 是否存在子节点
     *
     * @param deptId 锅炉ID
     * @return 结果
     */
    public int hasChildByDeptId(Long deptId);

    /**
     * 查询锅炉是否存在用户
     *
     * @param deptId 锅炉ID
     * @return 结果
     */
    public int checkDeptExistUser(Long deptId);

    /**
     * 校验锅炉名称是否唯一
     *
     * @param deptName 锅炉名称
     * @param parentId 父锅炉ID
     * @return 结果
     */
    public SysDept checkDeptNameUnique(@Param("deptName") String deptName, @Param("parentId") Long parentId, @Param("tenantId") String tenantId);

    /**
     * 新增锅炉信息
     *
     * @param dept 锅炉信息
     * @return 结果
     */
    public int insertDept(SysDept dept);

    /**
     * 修改锅炉信息
     *
     * @param dept 锅炉信息
     * @return 结果
     */
    public int updateDept(SysDept dept);

    /**
     * 修改所在锅炉正常状态
     *
     * @param deptIds 锅炉ID组
     */
    public void updateDeptStatusNormal(Long[] deptIds);

    /**
     * 修改子元素关系
     *
     * @param depts 子元素
     * @return 结果
     */
    public int updateDeptChildren(@Param("depts") List<SysDept> depts);

    /**
     * 删除锅炉管理信息
     *
     * @param deptId 锅炉ID
     * @return 结果
     */
    public int deleteDeptById(Long deptId);
}
