package com.ruoyi.system.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ruoyi.common.core.domain.entity.Overhaul;

import java.util.List;

/**
 * 检修Service接口
 *
 * @author ruoyi
 * @date 2021-11-17
 */
public interface IOverhaulService extends IService<Overhaul>
{
    /**
     * 查询检修
     *
     * @param id 检修主键
     * @return 检修
     */
    public Overhaul selectOverhaulById(Long id);

    /**
     * 查询检修列表
     *
     * @param overhaul 检修
     * @return 检修集合
     */
    public List<Overhaul> selectOverhaulList(Overhaul overhaul);

    /**
     * 新增检修
     *
     * @param overhaul 检修
     * @return 结果
     */
    public int insertOverhaul(Overhaul overhaul);

    /**
     * 修改检修
     *
     * @param overhaul 检修
     * @return 结果
     */
    public int updateOverhaul(Overhaul overhaul);

    /**
     * 批量删除检修
     *
     * @param ids 需要删除的检修主键集合
     * @return 结果
     */
    public int deleteOverhaulByIds(Long[] ids);

    /**
     * 删除检修信息
     *
     * @param id 检修主键
     * @return 结果
     */
    public int deleteOverhaulById(Long id);
}
