package com.ruoyi.system.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.core.domain.entity.Overhaul;
import com.ruoyi.system.mapper.OverhaulMapper;
import com.ruoyi.system.service.IOverhaulService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 检修Service业务层处理
 *
 * @author ruoyi
 * @date 2021-11-17
 */
@Service
public class OverhaulServiceImpl extends ServiceImpl<OverhaulMapper,Overhaul> implements IOverhaulService
{
    @Autowired
    private OverhaulMapper overhaulMapper;

    /**
     * 查询检修
     *
     * @param id 检修主键
     * @return 检修
     */
    @Override
    public Overhaul selectOverhaulById(Long id)
    {
        return overhaulMapper.selectOverhaulById(id);
    }

    /**
     * 查询检修列表
     *
     * @param overhaul 检修
     * @return 检修
     */
    @Override
    public List<Overhaul> selectOverhaulList(Overhaul overhaul)
    {
        return overhaulMapper.selectOverhaulList(overhaul);
    }

    /**
     * 新增检修
     *
     * @param overhaul 检修
     * @return 结果
     */
    @Override
    public int insertOverhaul(Overhaul overhaul)
    {
        overhaul.setCreateTime(DateUtils.getNowDate());
        return overhaulMapper.insertOverhaul(overhaul);
    }

    /**
     * 修改检修
     *
     * @param overhaul 检修
     * @return 结果
     */
    @Override
    public int updateOverhaul(Overhaul overhaul)
    {
        overhaul.setUpdateTime(DateUtils.getNowDate());
        return overhaulMapper.updateOverhaul(overhaul);
    }

    /**
     * 批量删除检修
     *
     * @param ids 需要删除的检修主键
     * @return 结果
     */
    @Override
    public int deleteOverhaulByIds(Long[] ids)
    {
        return overhaulMapper.deleteOverhaulByIds(ids);
    }

    /**
     * 删除检修信息
     *
     * @param id 检修主键
     * @return 结果
     */
    @Override
    public int deleteOverhaulById(Long id)
    {
        return overhaulMapper.deleteOverhaulById(id);
    }
}
