/*
 Navicat Premium Data Transfer

 Source Server         : boiler
 Source Server Type    : MySQL
 Source Server Version : 50733
 Source Host           : 139.9.165.125:33060
 Source Schema         : boiler

 Target Server Type    : MySQL
 Target Server Version : 50733
 File Encoding         : 65001

 Date: 21/03/2022 09:35:33
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for gen_table
-- ----------------------------
DROP TABLE IF EXISTS `gen_table`;
CREATE TABLE `gen_table` (
  `table_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_name` varchar(200) DEFAULT '' COMMENT '表名称',
  `table_comment` varchar(500) DEFAULT '' COMMENT '表描述',
  `sub_table_name` varchar(64) DEFAULT NULL COMMENT '关联子表的表名',
  `sub_table_fk_name` varchar(64) DEFAULT NULL COMMENT '子表关联的外键名',
  `class_name` varchar(100) DEFAULT '' COMMENT '实体类名称',
  `tpl_category` varchar(200) DEFAULT 'crud' COMMENT '使用的模板（crud单表操作 tree树表操作）',
  `package_name` varchar(100) DEFAULT NULL COMMENT '生成包路径',
  `module_name` varchar(30) DEFAULT NULL COMMENT '生成模块名',
  `business_name` varchar(30) DEFAULT NULL COMMENT '生成业务名',
  `function_name` varchar(50) DEFAULT NULL COMMENT '生成功能名',
  `function_author` varchar(50) DEFAULT NULL COMMENT '生成功能作者',
  `gen_type` char(1) DEFAULT '0' COMMENT '生成代码方式（0zip压缩包 1自定义路径）',
  `gen_path` varchar(200) DEFAULT '/' COMMENT '生成路径（不填默认项目路径）',
  `options` varchar(1000) DEFAULT NULL COMMENT '其它生成选项',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `tenant_id` varchar(8) NOT NULL DEFAULT '00000000',
  PRIMARY KEY (`table_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COMMENT='代码生成业务表';

-- ----------------------------
-- Records of gen_table
-- ----------------------------
BEGIN;
INSERT INTO `gen_table` VALUES (1, 'sys_config', '参数配置表', NULL, NULL, 'SysConfig', 'crud', 'com.ruoyi.system', 'system', 'config', '参数配置', 'ruoyi', '0', '/', NULL, 'admin', '2021-09-21 18:07:52', '', NULL, NULL, '00000000');
INSERT INTO `gen_table` VALUES (2, 'sys_tenant', '租户管理', NULL, NULL, 'SysTenant', 'crud', 'com.ruoyi.system', 'system', 'tenant', '租户管理', 'ruoyi', '0', '/', NULL, 'admin', '2021-10-10 16:10:50', '', NULL, NULL, '00000000');
INSERT INTO `gen_table` VALUES (4, 'sys_data_rule', '数据权限表', NULL, NULL, 'SysDataRule', 'crud', 'com.ruoyi.system', 'system', 'rule', '数据权限', 'ruoyi', '0', '/', '{}', 'admin', '2021-10-19 17:14:27', '', '2021-10-19 17:14:50', NULL, '00000000');
INSERT INTO `gen_table` VALUES (5, 'demo_table', '综合表格', NULL, NULL, 'Table', 'crud', 'com.ruoyi.demo', 'demo', 'table', '综合表格', 'ruoyi', '0', '/', '{}', 'admin', '2021-10-21 20:43:12', '', '2021-10-22 13:27:41', NULL, '00000000');
INSERT INTO `gen_table` VALUES (6, 'demo_tree_table', '树形表格', '', '', 'TreeTable', 'tree', 'com.ruoyi.demo', 'demo', 'treeTable', '树形表格', 'ruoyi', '0', '/', '{\"treeCode\":\"id\",\"treeName\":\"name\",\"treeParentCode\":\"parent_id\"}', 'admin', '2021-10-22 14:12:07', '', '2021-10-22 14:17:03', NULL, '00000000');
INSERT INTO `gen_table` VALUES (7, 'demo_expand_table', '展开表格', NULL, NULL, 'ExpandTable', 'crud', 'com.ruoyi.system', 'demo', 'expandTable', '展开表格', 'ruoyi', '0', '/', '{}', 'admin', '2021-10-22 22:58:00', '', '2021-10-22 22:59:56', NULL, '00000000');
INSERT INTO `gen_table` VALUES (8, 'demo_car', '车辆品牌', NULL, NULL, 'Car', 'crud', 'com.ruoyi.system', 'demo', 'car', '车辆品牌', 'ruoyi', '0', '/', '{}', 'admin', '2021-10-22 23:33:37', '', '2021-10-22 23:34:25', NULL, '00000000');
INSERT INTO `gen_table` VALUES (9, 'demo_car_model', '车辆型号', NULL, NULL, 'CarModel', 'crud', 'com.ruoyi.system', 'demo', 'car', '车辆型号', 'ruoyi', '0', '/', '{}', 'admin', '2021-10-22 23:33:38', '', '2021-10-22 23:36:05', NULL, '00000000');
INSERT INTO `gen_table` VALUES (10, 'demo_tree_and_table', '左树右表', NULL, NULL, 'TreeAndTable', 'crud', 'com.ruoyi.system', 'system', 'treeandtable', '左树右表', 'ruoyi', '0', '/', '{}', 'admin', '2021-10-23 11:58:21', '', '2021-10-23 12:01:14', NULL, '00000000');
INSERT INTO `gen_table` VALUES (11, 'overhaul', '检修表', NULL, NULL, 'Overhaul', 'crud', 'com.ruoyi.system', 'system', 'overhaul', '检修', 'ruoyi', '0', '/', NULL, 'admin', '2021-11-17 16:12:06', '', NULL, NULL, '00000000');
INSERT INTO `gen_table` VALUES (12, 'sys_file_info', '文件信息表', NULL, NULL, 'SysFileInfo', 'crud', 'com.ruoyi.system', 'system', 'info', '文件信息', 'ruoyi', '0', '/', NULL, 'admin', '2021-11-17 16:12:07', '', NULL, NULL, '00000000');
INSERT INTO `gen_table` VALUES (13, 'mark', '', NULL, NULL, 'Mark', 'crud', 'com.ruoyi.system', 'system', 'mark', NULL, 'ruoyi', '0', '/', NULL, 'admin', '2021-11-19 14:47:23', '', NULL, NULL, '00000000');
COMMIT;

-- ----------------------------
-- Table structure for gen_table_column
-- ----------------------------
DROP TABLE IF EXISTS `gen_table_column`;
CREATE TABLE `gen_table_column` (
  `column_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_id` varchar(64) DEFAULT NULL COMMENT '归属表编号',
  `column_name` varchar(200) DEFAULT NULL COMMENT '列名称',
  `column_comment` varchar(500) DEFAULT NULL COMMENT '列描述',
  `column_type` varchar(100) DEFAULT NULL COMMENT '列类型',
  `java_type` varchar(500) DEFAULT NULL COMMENT 'JAVA类型',
  `java_field` varchar(200) DEFAULT NULL COMMENT 'JAVA字段名',
  `is_pk` char(1) DEFAULT NULL COMMENT '是否主键（1是）',
  `is_increment` char(1) DEFAULT NULL COMMENT '是否自增（1是）',
  `is_required` char(1) DEFAULT NULL COMMENT '是否必填（1是）',
  `is_insert` char(1) DEFAULT NULL COMMENT '是否为插入字段（1是）',
  `is_edit` char(1) DEFAULT NULL COMMENT '是否编辑字段（1是）',
  `is_list` char(1) DEFAULT NULL COMMENT '是否列表字段（1是）',
  `is_query` char(1) DEFAULT NULL COMMENT '是否查询字段（1是）',
  `query_type` varchar(200) DEFAULT 'EQ' COMMENT '查询方式（等于、不等于、大于、小于、范围）',
  `html_type` varchar(200) DEFAULT NULL COMMENT '显示类型（文本框、文本域、下拉框、复选框、单选框、日期控件）',
  `dict_type` varchar(200) DEFAULT '' COMMENT '字典类型',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `tenant_id` varchar(8) NOT NULL DEFAULT '00000000',
  PRIMARY KEY (`column_id`)
) ENGINE=InnoDB AUTO_INCREMENT=164 DEFAULT CHARSET=utf8mb4 COMMENT='代码生成业务表字段';

-- ----------------------------
-- Records of gen_table_column
-- ----------------------------
BEGIN;
INSERT INTO `gen_table_column` VALUES (1, '1', 'config_id', '参数主键', 'int(5)', 'Integer', 'configId', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2021-09-21 18:07:52', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (2, '1', 'config_name', '参数名称', 'varchar(100)', 'String', 'configName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2021-09-21 18:07:52', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (3, '1', 'config_key', '参数键名', 'varchar(100)', 'String', 'configKey', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2021-09-21 18:07:52', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (4, '1', 'config_value', '参数键值', 'varchar(500)', 'String', 'configValue', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 4, 'admin', '2021-09-21 18:07:52', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (5, '1', 'config_type', '系统内置（Y是 N否）', 'char(1)', 'String', 'configType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 5, 'admin', '2021-09-21 18:07:52', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (6, '1', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2021-09-21 18:07:52', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (7, '1', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2021-09-21 18:07:52', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (8, '1', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 8, 'admin', '2021-09-21 18:07:52', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (9, '1', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 9, 'admin', '2021-09-21 18:07:52', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (10, '1', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 10, 'admin', '2021-09-21 18:07:52', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (11, '2', 'info_id', '访问ID', 'bigint(20)', 'Long', 'infoId', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2021-10-10 16:10:50', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (12, '2', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 2, 'admin', '2021-10-10 16:10:50', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (13, '2', 'create_time', '创建日期', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 3, 'admin', '2021-10-10 16:10:50', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (14, '2', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2021-10-10 16:10:50', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (15, '2', 'update_time', '更新日期', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2021-10-10 16:10:50', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (16, '2', 'del_flag', '删除标识', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2021-10-10 16:10:50', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (17, '2', 'remarks', '备注', 'text', 'String', 'remarks', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 7, 'admin', '2021-10-10 16:10:50', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (18, '2', 'tenant_id', '租户标识', 'varchar(64)', 'String', 'tenantId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2021-10-10 16:10:51', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (19, '2', 'contact', '联系人', 'varchar(64)', 'String', 'contact', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2021-10-10 16:10:51', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (20, '2', 'phone', '电话', 'varchar(64)', 'String', 'phone', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2021-10-10 16:10:51', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (21, '2', 'name', '租户名称', 'varchar(64)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 11, 'admin', '2021-10-10 16:10:51', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (22, '2', 'user_id', NULL, 'varchar(64)', 'String', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2021-10-10 16:10:51', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (44, '4', 'id', '主键', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2021-10-19 17:14:27', '', '2021-10-19 17:14:50', '00000000');
INSERT INTO `gen_table_column` VALUES (45, '4', 'resource_code', '资源编号', 'varchar(255)', 'String', 'resourceCode', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2021-10-19 17:14:29', '', '2021-10-19 17:14:50', '00000000');
INSERT INTO `gen_table_column` VALUES (46, '4', 'scope_name', '数据权限名称', 'varchar(255)', 'String', 'scopeName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2021-10-19 17:14:29', '', '2021-10-19 17:14:50', '00000000');
INSERT INTO `gen_table_column` VALUES (47, '4', 'scope_field', '数据权限字段', 'varchar(255)', 'String', 'scopeField', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2021-10-19 17:14:29', '', '2021-10-19 17:14:50', '00000000');
INSERT INTO `gen_table_column` VALUES (48, '4', 'scope_class', '数据权限类名', 'varchar(500)', 'String', 'scopeClass', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'textarea', '', 5, 'admin', '2021-10-19 17:14:29', '', '2021-10-19 17:14:50', '00000000');
INSERT INTO `gen_table_column` VALUES (49, '4', 'scope_column', '数据权限字段', 'varchar(255)', 'String', 'scopeColumn', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2021-10-19 17:14:29', '', '2021-10-19 17:14:50', '00000000');
INSERT INTO `gen_table_column` VALUES (50, '4', 'scope_type', '数据权限类型', 'int(2)', 'Integer', 'scopeType', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'select', '', 7, 'admin', '2021-10-19 17:14:29', '', '2021-10-19 17:14:50', '00000000');
INSERT INTO `gen_table_column` VALUES (51, '4', 'scope_value', '数据权限值域', 'varchar(2000)', 'String', 'scopeValue', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 8, 'admin', '2021-10-19 17:14:29', '', '2021-10-19 17:14:51', '00000000');
INSERT INTO `gen_table_column` VALUES (52, '4', 'remarks', '数据权限备注', 'varchar(255)', 'String', 'remarks', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2021-10-19 17:14:29', '', '2021-10-19 17:14:51', '00000000');
INSERT INTO `gen_table_column` VALUES (53, '4', 'create_by', '创建人', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 10, 'admin', '2021-10-19 17:14:29', '', '2021-10-19 17:14:51', '00000000');
INSERT INTO `gen_table_column` VALUES (54, '4', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 11, 'admin', '2021-10-19 17:14:30', '', '2021-10-19 17:14:51', '00000000');
INSERT INTO `gen_table_column` VALUES (55, '4', 'update_by', '修改人', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 12, 'admin', '2021-10-19 17:14:30', '', '2021-10-19 17:14:51', '00000000');
INSERT INTO `gen_table_column` VALUES (56, '4', 'update_time', '修改时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 13, 'admin', '2021-10-19 17:14:30', '', '2021-10-19 17:14:51', '00000000');
INSERT INTO `gen_table_column` VALUES (57, '4', 'del_flag', '是否已删除', 'int(2)', 'Integer', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 14, 'admin', '2021-10-19 17:14:30', '', '2021-10-19 17:14:51', '00000000');
INSERT INTO `gen_table_column` VALUES (58, '4', 'table_name', '数据库表', 'varchar(64)', 'String', 'tableName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 15, 'admin', '2021-10-19 17:14:30', '', '2021-10-19 17:14:51', '00000000');
INSERT INTO `gen_table_column` VALUES (59, '4', 'user_column', '用户表对应字段', 'varchar(64)', 'String', 'userColumn', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 16, 'admin', '2021-10-19 17:14:30', '', '2021-10-19 17:14:51', '00000000');
INSERT INTO `gen_table_column` VALUES (60, '4', 'tenant_id', '租户ID', 'varchar(64)', 'String', 'tenantId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 17, 'admin', '2021-10-19 17:14:30', '', '2021-10-19 17:14:51', '00000000');
INSERT INTO `gen_table_column` VALUES (61, '4', 'user_entity_field', 'user实体类对应字段', 'varchar(64)', 'String', 'userEntityField', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 18, 'admin', '2021-10-19 17:14:31', '', '2021-10-19 17:14:51', '00000000');
INSERT INTO `gen_table_column` VALUES (62, '5', 'id', '主键', 'varchar(64)', 'String', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2021-10-21 20:43:12', '', '2021-10-22 13:27:41', '00000000');
INSERT INTO `gen_table_column` VALUES (63, '5', 'title', '标题', 'varchar(255)', 'String', 'title', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2021-10-21 20:43:12', '', '2021-10-22 13:27:41', '00000000');
INSERT INTO `gen_table_column` VALUES (64, '5', 'author', '作者', 'varchar(100)', 'String', 'author', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2021-10-21 20:43:12', '', '2021-10-22 13:27:41', '00000000');
INSERT INTO `gen_table_column` VALUES (65, '5', 'type', '类型', 'varchar(250)', 'String', 'type', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'select', 'sys_notice_type', 4, 'admin', '2021-10-21 20:43:12', '', '2021-10-22 13:27:41', '00000000');
INSERT INTO `gen_table_column` VALUES (66, '5', 'level', '密码', 'varchar(100)', 'String', 'level', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2021-10-21 20:43:13', '', '2021-10-22 13:27:42', '00000000');
INSERT INTO `gen_table_column` VALUES (67, '5', 'content', '内容', 'longtext', 'String', 'content', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'editor', '', 6, 'admin', '2021-10-21 20:43:13', '', '2021-10-22 13:27:42', '00000000');
INSERT INTO `gen_table_column` VALUES (68, '5', 'status', '状态', 'varchar(32)', 'String', 'status', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'radio', 'sys_common_status', 7, 'admin', '2021-10-21 20:43:13', '', '2021-10-22 13:27:42', '00000000');
INSERT INTO `gen_table_column` VALUES (69, '5', 'tag', '标签', 'varchar(200)', 'String', 'tag', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2021-10-21 20:43:13', '', '2021-10-22 13:27:42', '00000000');
INSERT INTO `gen_table_column` VALUES (70, '5', 'readings', '阅读数', 'int(11)', 'Long', 'readings', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2021-10-21 20:43:13', '', '2021-10-22 13:27:42', '00000000');
INSERT INTO `gen_table_column` VALUES (71, '5', 'publish_date', '发布时间', 'datetime', 'Date', 'publishDate', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 10, 'admin', '2021-10-21 20:43:13', '', '2021-10-22 13:27:42', '00000000');
INSERT INTO `gen_table_column` VALUES (72, '5', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 11, 'admin', '2021-10-21 20:43:13', '', '2021-10-22 13:27:42', '00000000');
INSERT INTO `gen_table_column` VALUES (73, '5', 'update_by', NULL, 'varchar(32)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 12, 'admin', '2021-10-21 20:43:13', '', '2021-10-22 13:27:42', '00000000');
INSERT INTO `gen_table_column` VALUES (74, '5', 'update_time', NULL, 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 13, 'admin', '2021-10-21 20:43:13', '', '2021-10-22 13:27:42', '00000000');
INSERT INTO `gen_table_column` VALUES (75, '5', 'remarks', NULL, 'varchar(255)', 'String', 'remarks', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 14, 'admin', '2021-10-21 20:43:13', '', '2021-10-22 13:27:42', '00000000');
INSERT INTO `gen_table_column` VALUES (76, '5', 'del_flag', NULL, 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 15, 'admin', '2021-10-21 20:43:13', '', '2021-10-22 13:27:42', '00000000');
INSERT INTO `gen_table_column` VALUES (77, '5', 'create_by', NULL, 'varchar(32)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 16, 'admin', '2021-10-21 20:43:13', '', '2021-10-22 13:27:42', '00000000');
INSERT INTO `gen_table_column` VALUES (78, '5', 'tenant_id', '租户ID', 'varchar(64)', 'String', 'tenantId', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 17, 'admin', '2021-10-21 20:43:13', '', '2021-10-22 13:27:42', '00000000');
INSERT INTO `gen_table_column` VALUES (79, '6', 'id', NULL, 'varchar(64)', 'String', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2021-10-22 14:12:07', '', '2021-10-22 14:17:03', '00000000');
INSERT INTO `gen_table_column` VALUES (80, '6', 'name', '机构名称', 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2021-10-22 14:12:08', '', '2021-10-22 14:17:03', '00000000');
INSERT INTO `gen_table_column` VALUES (81, '6', 'geocoding', '是否叶子节点', 'varchar(32)', 'String', 'geocoding', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2021-10-22 14:12:09', '', '2021-10-22 14:17:03', '00000000');
INSERT INTO `gen_table_column` VALUES (82, '6', 'postal_code', NULL, 'varchar(32)', 'String', 'postalCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2021-10-22 14:12:09', '', '2021-10-22 14:17:03', '00000000');
INSERT INTO `gen_table_column` VALUES (83, '6', 'parent_id', '父节点', 'varchar(32)', 'String', 'parentId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2021-10-22 14:12:09', '', '2021-10-22 14:17:03', '00000000');
INSERT INTO `gen_table_column` VALUES (84, '6', 'parent_ids', '父节点路径', 'varchar(1000)', 'String', 'parentIds', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 6, 'admin', '2021-10-22 14:12:09', '', '2021-10-22 14:17:03', '00000000');
INSERT INTO `gen_table_column` VALUES (85, '6', 'create_by', NULL, 'varchar(32)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2021-10-22 14:12:09', '', '2021-10-22 14:17:04', '00000000');
INSERT INTO `gen_table_column` VALUES (86, '6', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2021-10-22 14:12:09', '', '2021-10-22 14:17:04', '00000000');
INSERT INTO `gen_table_column` VALUES (87, '6', 'update_by', NULL, 'varchar(32)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 9, 'admin', '2021-10-22 14:12:09', '', '2021-10-22 14:17:04', '00000000');
INSERT INTO `gen_table_column` VALUES (88, '6', 'update_time', NULL, 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 10, 'admin', '2021-10-22 14:12:09', '', '2021-10-22 14:17:04', '00000000');
INSERT INTO `gen_table_column` VALUES (89, '6', 'del_flag', '删除标记', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 11, 'admin', '2021-10-22 14:12:09', '', '2021-10-22 14:17:04', '00000000');
INSERT INTO `gen_table_column` VALUES (90, '6', 'remark', NULL, 'varchar(255)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 12, 'admin', '2021-10-22 14:12:09', '', '2021-10-22 14:17:04', '00000000');
INSERT INTO `gen_table_column` VALUES (91, '6', 'tenant_id', '租户ID', 'varchar(64)', 'String', 'tenantId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 13, 'admin', '2021-10-22 14:12:09', '', '2021-10-22 14:17:04', '00000000');
INSERT INTO `gen_table_column` VALUES (92, '7', 'id', '主键', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2021-10-22 22:58:00', '', '2021-10-22 22:59:56', '00000000');
INSERT INTO `gen_table_column` VALUES (93, '7', 'name', '商品名称', 'varchar(255)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2021-10-22 22:58:00', '', '2021-10-22 22:59:57', '00000000');
INSERT INTO `gen_table_column` VALUES (94, '7', 'shop', '所属店铺', 'varchar(100)', 'String', 'shop', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2021-10-22 22:58:00', '', '2021-10-22 22:59:57', '00000000');
INSERT INTO `gen_table_column` VALUES (95, '7', 'category', '商品分类', 'varchar(100)', 'String', 'category', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2021-10-22 22:58:00', '', '2021-10-22 22:59:57', '00000000');
INSERT INTO `gen_table_column` VALUES (96, '7', 'address', '店铺地址', 'text', 'String', 'address', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 5, 'admin', '2021-10-22 22:58:00', '', '2021-10-22 22:59:57', '00000000');
INSERT INTO `gen_table_column` VALUES (97, '7', 'description', '商品描述', 'longtext', 'String', 'description', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 6, 'admin', '2021-10-22 22:58:01', '', '2021-10-22 22:59:57', '00000000');
INSERT INTO `gen_table_column` VALUES (98, '7', 'tag', '标签', 'varchar(200)', 'String', 'tag', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2021-10-22 22:58:01', '', '2021-10-22 22:59:57', '00000000');
INSERT INTO `gen_table_column` VALUES (99, '7', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2021-10-22 22:58:01', '', '2021-10-22 22:59:57', '00000000');
INSERT INTO `gen_table_column` VALUES (100, '7', 'update_by', NULL, 'varchar(32)', 'String', 'updateBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 9, 'admin', '2021-10-22 22:58:01', '', '2021-10-22 22:59:57', '00000000');
INSERT INTO `gen_table_column` VALUES (101, '7', 'update_time', NULL, 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 10, 'admin', '2021-10-22 22:58:01', '', '2021-10-22 22:59:57', '00000000');
INSERT INTO `gen_table_column` VALUES (102, '7', 'remark', NULL, 'varchar(255)', 'String', 'remark', '0', '0', NULL, '1', NULL, '1', NULL, 'EQ', 'input', '', 11, 'admin', '2021-10-22 22:58:01', '', '2021-10-22 22:59:57', '00000000');
INSERT INTO `gen_table_column` VALUES (103, '7', 'del_flag', NULL, 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 12, 'admin', '2021-10-22 22:58:01', '', '2021-10-22 22:59:57', '00000000');
INSERT INTO `gen_table_column` VALUES (104, '7', 'create_by', NULL, 'varchar(32)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 13, 'admin', '2021-10-22 22:58:01', '', '2021-10-22 22:59:57', '00000000');
INSERT INTO `gen_table_column` VALUES (105, '7', 'organization_id', '组织ID', 'varchar(64)', 'String', 'organizationId', '0', '0', NULL, '1', NULL, '1', NULL, 'EQ', 'input', '', 14, 'admin', '2021-10-22 22:58:01', '', '2021-10-22 22:59:57', '00000000');
INSERT INTO `gen_table_column` VALUES (106, '7', 'tenant_id', '租户ID', 'varchar(64)', 'String', 'tenantId', '0', '0', NULL, '1', NULL, '1', NULL, 'EQ', 'input', '', 15, 'admin', '2021-10-22 22:58:01', '', '2021-10-22 22:59:57', '00000000');
INSERT INTO `gen_table_column` VALUES (107, '7', 'image', '图片', 'text', 'String', 'image', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'imageUpload', '', 16, 'admin', '2021-10-22 22:58:01', '', '2021-10-22 22:59:57', '00000000');
INSERT INTO `gen_table_column` VALUES (108, '8', 'id', '主键', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2021-10-22 23:33:37', '', '2021-10-22 23:34:25', '00000000');
INSERT INTO `gen_table_column` VALUES (109, '8', 'name', '名称', 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2021-10-22 23:33:37', '', '2021-10-22 23:34:25', '00000000');
INSERT INTO `gen_table_column` VALUES (110, '8', 'code', '品牌代码', 'varchar(100)', 'String', 'code', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2021-10-22 23:33:37', '', '2021-10-22 23:34:25', '00000000');
INSERT INTO `gen_table_column` VALUES (111, '8', 'remark', '备注', 'varchar(100)', 'String', 'remark', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2021-10-22 23:33:37', '', '2021-10-22 23:34:25', '00000000');
INSERT INTO `gen_table_column` VALUES (112, '8', 'create_by', NULL, 'varchar(32)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 5, 'admin', '2021-10-22 23:33:37', '', '2021-10-22 23:34:25', '00000000');
INSERT INTO `gen_table_column` VALUES (113, '8', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2021-10-22 23:33:38', '', '2021-10-22 23:34:25', '00000000');
INSERT INTO `gen_table_column` VALUES (114, '8', 'update_by', NULL, 'varchar(32)', 'String', 'updateBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2021-10-22 23:33:38', '', '2021-10-22 23:34:25', '00000000');
INSERT INTO `gen_table_column` VALUES (115, '8', 'update_time', NULL, 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2021-10-22 23:33:38', '', '2021-10-22 23:34:26', '00000000');
INSERT INTO `gen_table_column` VALUES (116, '8', 'del_flag', NULL, 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 9, 'admin', '2021-10-22 23:33:38', '', '2021-10-22 23:34:26', '00000000');
INSERT INTO `gen_table_column` VALUES (117, '8', 'tenant_id', '租户ID', 'varchar(64)', 'String', 'tenantId', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 10, 'admin', '2021-10-22 23:33:38', '', '2021-10-22 23:34:26', '00000000');
INSERT INTO `gen_table_column` VALUES (118, '9', 'id', '主键', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2021-10-22 23:33:38', '', '2021-10-22 23:36:05', '00000000');
INSERT INTO `gen_table_column` VALUES (119, '9', 'car_id', '汽车', 'varchar(32)', 'String', 'carId', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 2, 'admin', '2021-10-22 23:33:38', '', '2021-10-22 23:36:05', '00000000');
INSERT INTO `gen_table_column` VALUES (120, '9', 'name', '型号名', 'varchar(100)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2021-10-22 23:33:38', '', '2021-10-22 23:36:05', '00000000');
INSERT INTO `gen_table_column` VALUES (121, '9', 'value', '型号代码', 'varchar(100)', 'String', 'value', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2021-10-22 23:33:38', '', '2021-10-22 23:36:05', '00000000');
INSERT INTO `gen_table_column` VALUES (122, '9', 'sort', '排序', 'int(5)', 'Integer', 'sort', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2021-10-22 23:33:38', '', '2021-10-22 23:36:05', '00000000');
INSERT INTO `gen_table_column` VALUES (123, '9', 'remark', '描述', 'varchar(100)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2021-10-22 23:33:38', '', '2021-10-22 23:36:05', '00000000');
INSERT INTO `gen_table_column` VALUES (124, '9', 'create_by', NULL, 'varchar(32)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2021-10-22 23:33:38', '', '2021-10-22 23:36:05', '00000000');
INSERT INTO `gen_table_column` VALUES (125, '9', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2021-10-22 23:33:38', '', '2021-10-22 23:36:05', '00000000');
INSERT INTO `gen_table_column` VALUES (126, '9', 'update_by', NULL, 'varchar(32)', 'String', 'updateBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 9, 'admin', '2021-10-22 23:33:38', '', '2021-10-22 23:36:06', '00000000');
INSERT INTO `gen_table_column` VALUES (127, '9', 'update_time', NULL, 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 10, 'admin', '2021-10-22 23:33:38', '', '2021-10-22 23:36:06', '00000000');
INSERT INTO `gen_table_column` VALUES (128, '9', 'del_flag', NULL, 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 11, 'admin', '2021-10-22 23:33:38', '', '2021-10-22 23:36:06', '00000000');
INSERT INTO `gen_table_column` VALUES (129, '9', 'tenant_id', NULL, 'varchar(64)', 'String', 'tenantId', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 12, 'admin', '2021-10-22 23:33:39', '', '2021-10-22 23:36:06', '00000000');
INSERT INTO `gen_table_column` VALUES (130, '10', 'id', '主键', 'varchar(64)', 'String', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2021-10-23 11:58:21', '', '2021-10-23 12:01:14', '00000000');
INSERT INTO `gen_table_column` VALUES (131, '10', 'name', '部门名称', 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2021-10-23 11:58:21', '', '2021-10-23 12:01:14', '00000000');
INSERT INTO `gen_table_column` VALUES (132, '10', 'type', '类型', 'varchar(250)', 'String', 'type', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'select', '', 3, 'admin', '2021-10-23 11:58:21', '', '2021-10-23 12:01:14', '00000000');
INSERT INTO `gen_table_column` VALUES (133, '10', 'tag', '标签', 'varchar(200)', 'String', 'tag', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2021-10-23 11:58:21', '', '2021-10-23 12:01:14', '00000000');
INSERT INTO `gen_table_column` VALUES (134, '10', 'area_id', '区域', 'varchar(64)', 'String', 'areaId', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'select', '', 5, 'admin', '2021-10-23 11:58:21', '', '2021-10-23 12:01:14', '00000000');
INSERT INTO `gen_table_column` VALUES (135, '10', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2021-10-23 11:58:22', '', '2021-10-23 12:01:14', '00000000');
INSERT INTO `gen_table_column` VALUES (136, '10', 'update_by', NULL, 'varchar(32)', 'String', 'updateBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2021-10-23 11:58:22', '', '2021-10-23 12:01:14', '00000000');
INSERT INTO `gen_table_column` VALUES (137, '10', 'update_time', NULL, 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2021-10-23 11:58:22', '', '2021-10-23 12:01:14', '00000000');
INSERT INTO `gen_table_column` VALUES (138, '10', 'remark', NULL, 'varchar(255)', 'String', 'remark', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 9, 'admin', '2021-10-23 11:58:22', '', '2021-10-23 12:01:14', '00000000');
INSERT INTO `gen_table_column` VALUES (139, '10', 'del_flag', NULL, 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 10, 'admin', '2021-10-23 11:58:22', '', '2021-10-23 12:01:14', '00000000');
INSERT INTO `gen_table_column` VALUES (140, '10', 'create_by', NULL, 'varchar(32)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 11, 'admin', '2021-10-23 11:58:22', '', '2021-10-23 12:01:14', '00000000');
INSERT INTO `gen_table_column` VALUES (141, '10', 'tenant_id', NULL, 'varchar(64)', 'String', 'tenantId', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 12, 'admin', '2021-10-23 11:58:22', '', '2021-10-23 12:01:14', '00000000');
INSERT INTO `gen_table_column` VALUES (142, '11', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2021-11-17 16:12:07', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (143, '11', 'overhaul_time', '检修日期', 'datetime', 'Date', 'overhaulTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 2, 'admin', '2021-11-17 16:12:07', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (144, '11', 'create_by', '操作人', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 3, 'admin', '2021-11-17 16:12:07', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (145, '11', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 4, 'admin', '2021-11-17 16:12:07', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (146, '11', 'update_by', '更新人', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 5, 'admin', '2021-11-17 16:12:07', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (147, '11', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2021-11-17 16:12:07', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (148, '11', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 7, 'admin', '2021-11-17 16:12:07', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (149, '11', 'tenant_id', '租户id', 'varchar(8)', 'String', 'tenantId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2021-11-17 16:12:07', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (150, '11', 'dept_id', '点位', 'bigint(20)', 'Long', 'deptId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2021-11-17 16:12:07', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (151, '12', 'file_id', '文件id', 'int(11)', 'Long', 'fileId', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2021-11-17 16:12:07', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (152, '12', 'file_name', '文件名称', 'varchar(50)', 'String', 'fileName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2021-11-17 16:12:07', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (153, '12', 'file_path', '文件路径', 'varchar(255)', 'String', 'filePath', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2021-11-17 16:12:07', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (154, '12', 'overhaul_id', '维修id', 'bigint(20)', 'Long', 'overhaulId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2021-11-17 16:12:07', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (155, '12', 'remark', '记录', 'longblob', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', NULL, '', 5, 'admin', '2021-11-17 16:12:08', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (156, '13', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2021-11-19 14:47:24', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (157, '13', 'create_by', '操作人', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 2, 'admin', '2021-11-19 14:47:24', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (158, '13', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 3, 'admin', '2021-11-19 14:47:24', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (159, '13', 'update_by', '更新人', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2021-11-19 14:47:24', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (160, '13', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2021-11-19 14:47:24', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (161, '13', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 6, 'admin', '2021-11-19 14:47:24', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (162, '13', 'tenant_id', '租户id', 'varchar(8)', 'String', 'tenantId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2021-11-19 14:47:24', '', NULL, '00000000');
INSERT INTO `gen_table_column` VALUES (163, '13', 'dept_id', '点位', 'bigint(20)', 'Long', 'deptId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2021-11-19 14:47:24', '', NULL, '00000000');
COMMIT;

-- ----------------------------
-- Table structure for mark
-- ----------------------------
DROP TABLE IF EXISTS `mark`;
CREATE TABLE `mark` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_by` varchar(64) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '操作人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '备注',
  `tenant_id` varchar(8) CHARACTER SET utf8mb4 NOT NULL DEFAULT '00000000' COMMENT '租户id',
  `dept_id` bigint(20) DEFAULT NULL COMMENT '点位',
  `overhaul_id` bigint(20) DEFAULT NULL COMMENT '维修id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of mark
-- ----------------------------
BEGIN;
INSERT INTO `mark` VALUES (1, '', '2021-11-20 16:56:00', '', '2021-12-12 19:28:38', '', '77864606', 263, 2);
INSERT INTO `mark` VALUES (2, '', '2021-11-20 17:32:59', '', '2021-12-12 19:35:34', '', '77864606', 264, 2);
INSERT INTO `mark` VALUES (3, '', '2021-12-12 19:08:57', '', NULL, '11', '77864606', 263, 3);
INSERT INTO `mark` VALUES (4, '', '2021-12-12 19:28:50', '', '2021-12-12 19:28:55', '', '77864606', 269, 2);
COMMIT;

-- ----------------------------
-- Table structure for overhaul
-- ----------------------------
DROP TABLE IF EXISTS `overhaul`;
CREATE TABLE `overhaul` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `overhaul_time` datetime DEFAULT NULL COMMENT '检修日期',
  `create_by` varchar(64) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '操作人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '备注',
  `tenant_id` varchar(8) CHARACTER SET utf8mb4 NOT NULL DEFAULT '00000000' COMMENT '租户id',
  `dept_id` bigint(20) DEFAULT NULL COMMENT '点位',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='检修表';

-- ----------------------------
-- Records of overhaul
-- ----------------------------
BEGIN;
INSERT INTO `overhaul` VALUES (1, '2021-11-19 00:00:00', '赵佳鹏', '2021-11-20 16:47:48', '', NULL, NULL, '77864606', 257);
INSERT INTO `overhaul` VALUES (2, '2021-11-20 00:00:00', '赵佳鹏', '2021-11-20 16:47:54', '', NULL, NULL, '77864606', 257);
INSERT INTO `overhaul` VALUES (3, '2021-11-21 00:00:00', '测试', '2021-11-22 09:07:12', '', NULL, NULL, '77864606', 257);
INSERT INTO `overhaul` VALUES (4, '2021-11-02 00:00:00', '张三', '2021-11-22 10:00:27', '', NULL, '', '77864606', 257);
INSERT INTO `overhaul` VALUES (5, '2021-11-03 00:00:00', '李丹丹', '2021-11-22 10:03:15', '', NULL, '', '77864606', 257);
INSERT INTO `overhaul` VALUES (6, '2021-11-29 00:00:00', '田宇', '2021-11-29 10:29:54', '', NULL, '', '00000000', 266);
COMMIT;

-- ----------------------------
-- Table structure for qrtz_blob_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_blob_triggers`;
CREATE TABLE `qrtz_blob_triggers` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '调度名称',
  `trigger_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'qrtz_triggers表trigger_name的外键',
  `trigger_group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'qrtz_triggers表trigger_group的外键',
  `blob_data` blob COMMENT '存放持久化Trigger对象',
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`),
  CONSTRAINT `qrtz_blob_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Blob类型的触发器表';

-- ----------------------------
-- Table structure for qrtz_calendars
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_calendars`;
CREATE TABLE `qrtz_calendars` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '调度名称',
  `calendar_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '日历名称',
  `calendar` blob NOT NULL COMMENT '存放持久化calendar对象',
  PRIMARY KEY (`sched_name`,`calendar_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='日历信息表';

-- ----------------------------
-- Table structure for qrtz_cron_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_cron_triggers`;
CREATE TABLE `qrtz_cron_triggers` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '调度名称',
  `trigger_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'qrtz_triggers表trigger_name的外键',
  `trigger_group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'qrtz_triggers表trigger_group的外键',
  `cron_expression` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'cron表达式',
  `time_zone_id` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '时区',
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`),
  CONSTRAINT `qrtz_cron_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Cron类型的触发器表';

-- ----------------------------
-- Records of qrtz_cron_triggers
-- ----------------------------
BEGIN;
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME1', 'DEFAULT', '0/10 * * * * ?', 'PRC');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME2', 'DEFAULT', '0/15 * * * * ?', 'PRC');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', '0/20 * * * * ?', 'PRC');
COMMIT;

-- ----------------------------
-- Table structure for qrtz_fired_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_fired_triggers`;
CREATE TABLE `qrtz_fired_triggers` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '调度名称',
  `entry_id` varchar(95) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '调度器实例id',
  `trigger_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'qrtz_triggers表trigger_name的外键',
  `trigger_group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'qrtz_triggers表trigger_group的外键',
  `instance_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '调度器实例名',
  `fired_time` bigint(13) NOT NULL COMMENT '触发的时间',
  `sched_time` bigint(13) NOT NULL COMMENT '定时器制定的时间',
  `priority` int(11) NOT NULL COMMENT '优先级',
  `state` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '状态',
  `job_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '任务名称',
  `job_group` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '任务组名',
  `is_nonconcurrent` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '是否并发',
  `requests_recovery` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '是否接受恢复执行',
  PRIMARY KEY (`sched_name`,`entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='已触发的触发器表';

-- ----------------------------
-- Table structure for qrtz_job_details
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_job_details`;
CREATE TABLE `qrtz_job_details` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '调度名称',
  `job_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '任务名称',
  `job_group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '任务组名',
  `description` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '相关介绍',
  `job_class_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '执行任务类名称',
  `is_durable` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '是否持久化',
  `is_nonconcurrent` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '是否并发',
  `is_update_data` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '是否更新数据',
  `requests_recovery` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '是否接受恢复执行',
  `job_data` blob COMMENT '存放持久化job对象',
  PRIMARY KEY (`sched_name`,`job_name`,`job_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='任务详细信息表';

-- ----------------------------
-- Records of qrtz_job_details
-- ----------------------------
BEGIN;
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME1', 'DEFAULT', NULL, 'com.ruoyi.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E72756F79692E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E72756F79692E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017C0797469878707400007070707400013174000E302F3130202A202A202A202A203F74001172795461736B2E72794E6F506172616D7374000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000001740018E7B3BBE7BB9FE9BB98E8AEA4EFBC88E697A0E58F82EFBC8974000133740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME2', 'DEFAULT', NULL, 'com.ruoyi.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E72756F79692E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E72756F79692E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017C07974A8078707400007070707400013174000E302F3135202A202A202A202A203F74001572795461736B2E7279506172616D7328277279272974000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000002740018E7B3BBE7BB9FE9BB98E8AEA4EFBC88E69C89E58F82EFBC8974000133740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', NULL, 'com.ruoyi.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E72756F79692E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E72756F79692E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017C07974A8078707400007070707400013174000E302F3230202A202A202A202A203F74003872795461736B2E72794D756C7469706C65506172616D7328277279272C20747275652C20323030304C2C203331362E3530442C203130302974000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000003740018E7B3BBE7BB9FE9BB98E8AEA4EFBC88E5A49AE58F82EFBC8974000133740001317800);
COMMIT;

-- ----------------------------
-- Table structure for qrtz_locks
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_locks`;
CREATE TABLE `qrtz_locks` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '调度名称',
  `lock_name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '悲观锁名称',
  PRIMARY KEY (`sched_name`,`lock_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='存储的悲观锁信息表';

-- ----------------------------
-- Records of qrtz_locks
-- ----------------------------
BEGIN;
INSERT INTO `qrtz_locks` VALUES ('RuoyiScheduler', 'STATE_ACCESS');
INSERT INTO `qrtz_locks` VALUES ('RuoyiScheduler', 'TRIGGER_ACCESS');
COMMIT;

-- ----------------------------
-- Table structure for qrtz_paused_trigger_grps
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_paused_trigger_grps`;
CREATE TABLE `qrtz_paused_trigger_grps` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '调度名称',
  `trigger_group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'qrtz_triggers表trigger_group的外键',
  PRIMARY KEY (`sched_name`,`trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='暂停的触发器表';

-- ----------------------------
-- Table structure for qrtz_scheduler_state
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_scheduler_state`;
CREATE TABLE `qrtz_scheduler_state` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '调度名称',
  `instance_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '实例名称',
  `last_checkin_time` bigint(13) NOT NULL COMMENT '上次检查时间',
  `checkin_interval` bigint(13) NOT NULL COMMENT '检查间隔时间',
  PRIMARY KEY (`sched_name`,`instance_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='调度器状态表';

-- ----------------------------
-- Records of qrtz_scheduler_state
-- ----------------------------
BEGIN;
INSERT INTO `qrtz_scheduler_state` VALUES ('RuoyiScheduler', 'ecs-bf2b-00021639191159433', 1639618656118, 15000);
COMMIT;

-- ----------------------------
-- Table structure for qrtz_simple_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_simple_triggers`;
CREATE TABLE `qrtz_simple_triggers` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '调度名称',
  `trigger_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'qrtz_triggers表trigger_name的外键',
  `trigger_group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'qrtz_triggers表trigger_group的外键',
  `repeat_count` bigint(7) NOT NULL COMMENT '重复的次数统计',
  `repeat_interval` bigint(12) NOT NULL COMMENT '重复的间隔时间',
  `times_triggered` bigint(10) NOT NULL COMMENT '已经触发的次数',
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`),
  CONSTRAINT `qrtz_simple_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='简单触发器的信息表';

-- ----------------------------
-- Table structure for qrtz_simprop_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_simprop_triggers`;
CREATE TABLE `qrtz_simprop_triggers` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '调度名称',
  `trigger_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'qrtz_triggers表trigger_name的外键',
  `trigger_group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'qrtz_triggers表trigger_group的外键',
  `str_prop_1` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'String类型的trigger的第一个参数',
  `str_prop_2` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'String类型的trigger的第二个参数',
  `str_prop_3` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'String类型的trigger的第三个参数',
  `int_prop_1` int(11) DEFAULT NULL COMMENT 'int类型的trigger的第一个参数',
  `int_prop_2` int(11) DEFAULT NULL COMMENT 'int类型的trigger的第二个参数',
  `long_prop_1` bigint(20) DEFAULT NULL COMMENT 'long类型的trigger的第一个参数',
  `long_prop_2` bigint(20) DEFAULT NULL COMMENT 'long类型的trigger的第二个参数',
  `dec_prop_1` decimal(13,4) DEFAULT NULL COMMENT 'decimal类型的trigger的第一个参数',
  `dec_prop_2` decimal(13,4) DEFAULT NULL COMMENT 'decimal类型的trigger的第二个参数',
  `bool_prop_1` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Boolean类型的trigger的第一个参数',
  `bool_prop_2` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Boolean类型的trigger的第二个参数',
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`),
  CONSTRAINT `qrtz_simprop_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='同步机制的行锁表';

-- ----------------------------
-- Table structure for qrtz_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_triggers`;
CREATE TABLE `qrtz_triggers` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '调度名称',
  `trigger_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '触发器的名字',
  `trigger_group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '触发器所属组的名字',
  `job_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'qrtz_job_details表job_name的外键',
  `job_group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'qrtz_job_details表job_group的外键',
  `description` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '相关介绍',
  `next_fire_time` bigint(13) DEFAULT NULL COMMENT '上一次触发时间（毫秒）',
  `prev_fire_time` bigint(13) DEFAULT NULL COMMENT '下一次触发时间（默认为-1表示不触发）',
  `priority` int(11) DEFAULT NULL COMMENT '优先级',
  `trigger_state` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '触发器状态',
  `trigger_type` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '触发器的类型',
  `start_time` bigint(13) NOT NULL COMMENT '开始时间',
  `end_time` bigint(13) DEFAULT NULL COMMENT '结束时间',
  `calendar_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '日程表名称',
  `misfire_instr` smallint(2) DEFAULT NULL COMMENT '补偿执行的策略',
  `job_data` blob COMMENT '存放持久化job对象',
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`),
  KEY `sched_name` (`sched_name`,`job_name`,`job_group`),
  CONSTRAINT `qrtz_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `job_name`, `job_group`) REFERENCES `qrtz_job_details` (`sched_name`, `job_name`, `job_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='触发器详细信息表';

-- ----------------------------
-- Records of qrtz_triggers
-- ----------------------------
BEGIN;
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME1', 'DEFAULT', 'TASK_CLASS_NAME1', 'DEFAULT', NULL, 1639191160000, -1, 5, 'PAUSED', 'CRON', 1639191159000, 0, NULL, 2, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME2', 'DEFAULT', 'TASK_CLASS_NAME2', 'DEFAULT', NULL, 1639191165000, -1, 5, 'PAUSED', 'CRON', 1639191159000, 0, NULL, 2, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', 'TASK_CLASS_NAME3', 'DEFAULT', NULL, 1639191160000, -1, 5, 'PAUSED', 'CRON', 1639191159000, 0, NULL, 2, '');
COMMIT;

-- ----------------------------
-- Table structure for sys_config
-- ----------------------------
DROP TABLE IF EXISTS `sys_config`;
CREATE TABLE `sys_config` (
  `config_id` int(5) NOT NULL AUTO_INCREMENT COMMENT '参数主键',
  `config_name` varchar(100) DEFAULT '' COMMENT '参数名称',
  `config_key` varchar(100) DEFAULT '' COMMENT '参数键名',
  `config_value` varchar(500) DEFAULT '' COMMENT '参数键值',
  `config_type` char(1) DEFAULT 'N' COMMENT '系统内置（Y是 N否）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `tenant_id` varchar(8) NOT NULL DEFAULT '00000000',
  PRIMARY KEY (`config_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COMMENT='参数配置表';

-- ----------------------------
-- Records of sys_config
-- ----------------------------
BEGIN;
INSERT INTO `sys_config` VALUES (1, '主框架页-默认皮肤样式名称', 'sys.index.skinName', 'skin-blue', 'Y', 'admin', '2021-09-21 17:02:04', '', NULL, '蓝色 skin-blue、绿色 skin-green、紫色 skin-purple、红色 skin-red、黄色 skin-yellow', '00000000');
INSERT INTO `sys_config` VALUES (2, '用户管理-账号初始密码', 'sys.user.initPassword', '123456', 'Y', 'admin', '2021-09-21 17:02:04', '', NULL, '初始化密码 123456', '00000000');
INSERT INTO `sys_config` VALUES (3, '主框架页-侧边栏主题', 'sys.index.sideTheme', 'theme-dark', 'Y', 'admin', '2021-09-21 17:02:05', '', NULL, '深色主题theme-dark，浅色主题theme-light', '00000000');
INSERT INTO `sys_config` VALUES (4, '账号自助-验证码开关', 'sys.account.captchaOnOff', 'true', 'Y', 'admin', '2021-09-21 17:02:05', '', NULL, '是否开启验证码功能（true开启，false关闭）', '00000000');
INSERT INTO `sys_config` VALUES (5, '账号自助-是否开启用户注册功能', 'sys.account.registerUser', 'false', 'Y', 'admin', '2021-09-21 17:02:05', '', NULL, '是否开启注册用户功能（true开启，false关闭）', '00000000');
COMMIT;

-- ----------------------------
-- Table structure for sys_data_rule
-- ----------------------------
DROP TABLE IF EXISTS `sys_data_rule`;
CREATE TABLE `sys_data_rule` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `resource_code` varchar(255) NOT NULL COMMENT '资源编号',
  `scope_name` varchar(255) NOT NULL COMMENT '数据权限名称',
  `scope_field` varchar(255) NOT NULL COMMENT '数据权限字段',
  `scope_class` varchar(500) NOT NULL COMMENT '数据权限类名',
  `scope_column` varchar(255) NOT NULL COMMENT '数据权限字段',
  `scope_type` int(2) NOT NULL COMMENT '数据权限类型',
  `scope_value` varchar(2000) DEFAULT NULL COMMENT '数据权限值域',
  `remark` varchar(255) DEFAULT NULL COMMENT '数据权限备注',
  `create_by` varchar(64) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `del_flag` int(2) DEFAULT NULL COMMENT '是否已删除',
  `table_name` varchar(64) DEFAULT NULL COMMENT '数据库表',
  `user_column` varchar(64) DEFAULT NULL COMMENT '用户表对应字段',
  `tenant_id` varchar(64) NOT NULL DEFAULT '00000000' COMMENT '租户ID',
  `user_entity_field` varchar(64) DEFAULT NULL COMMENT 'user实体类对应字段',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COMMENT='数据权限表';

-- ----------------------------
-- Records of sys_data_rule
-- ----------------------------
BEGIN;
INSERT INTO `sys_data_rule` VALUES (1, 'expandTable', 'test1', '*', 'com.ruoyi.web.demo.expandtable.mapper.ExpandTableMapper.selectPage', 'dept_id', 4, NULL, NULL, '4028ea815a3d2a8c015a3d2f8d2a0002', '2019-12-03 07:30:19', '4028ea815a3d2a8c015a3d2f8d2a0002', '2020-05-29 22:54:32', 0, 'sys_dept', 'organizationId', '00000000', NULL);
INSERT INTO `sys_data_rule` VALUES (2, 'table', 'test', 'id,title,author,type,level,content,`user.realname`,`user.username`,status', 'com.ruoyi.web.demo.table.mapper.TableMapper.selectPage', 'author', 2, NULL, NULL, '4028ea815a3d2a8c015a3d2f8d2a0002', '2019-11-29 15:18:25', '4028ea815a3d2a8c015a3d2f8d2a0002', '2020-10-31 12:01:59', 0, 'sys_dept', 'organization_id', '00000000', 'dept_id');
COMMIT;

-- ----------------------------
-- Table structure for sys_dept
-- ----------------------------
DROP TABLE IF EXISTS `sys_dept`;
CREATE TABLE `sys_dept` (
  `dept_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '部门id',
  `parent_id` bigint(20) DEFAULT '0' COMMENT '父部门id',
  `ancestors` varchar(50) DEFAULT '' COMMENT '祖级列表',
  `dept_name` varchar(30) DEFAULT '' COMMENT '部门名称',
  `order_num` int(4) DEFAULT '0' COMMENT '显示顺序',
  `leader` varchar(20) DEFAULT NULL COMMENT '负责人',
  `phone` varchar(11) DEFAULT NULL COMMENT '联系电话',
  `email` varchar(50) DEFAULT NULL COMMENT '邮箱',
  `status` char(1) DEFAULT '0' COMMENT '部门状态（0正常 1停用）',
  `del_flag` char(1) DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `tenant_id` varchar(8) NOT NULL DEFAULT '00000000',
  `remark` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`dept_id`)
) ENGINE=InnoDB AUTO_INCREMENT=274 DEFAULT CHARSET=utf8mb4 COMMENT='部门表';

-- ----------------------------
-- Records of sys_dept
-- ----------------------------
BEGIN;
INSERT INTO `sys_dept` VALUES (100, 0, '0', '壹号锅炉', 0, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2021-09-21 17:00:30', 'admin', '2021-11-20 17:21:52', '00000000', NULL);
INSERT INTO `sys_dept` VALUES (257, 0, '0', '壹号锅炉', 0, NULL, NULL, NULL, '0', '0', 'lizong', '2021-11-20 16:44:53', '', NULL, '77864606', NULL);
INSERT INTO `sys_dept` VALUES (258, 257, '0,257', '1层', 0, NULL, NULL, NULL, '0', '0', 'lizong', '2021-11-20 16:46:39', 'lizong', '2021-11-20 17:35:58', '77864606', NULL);
INSERT INTO `sys_dept` VALUES (259, 258, '0,257,258', '东', 0, NULL, NULL, NULL, '0', '0', 'lizong', '2021-11-20 16:46:55', '', NULL, '77864606', NULL);
INSERT INTO `sys_dept` VALUES (260, 258, '0,257,258', '南', 0, NULL, NULL, NULL, '0', '0', 'lizong', '2021-11-20 16:47:02', '', NULL, '77864606', NULL);
INSERT INTO `sys_dept` VALUES (261, 258, '0,257,258', '西', 0, NULL, NULL, NULL, '0', '0', 'lizong', '2021-11-20 16:47:06', '', NULL, '77864606', NULL);
INSERT INTO `sys_dept` VALUES (262, 258, '0,257,258', '北', 0, NULL, NULL, NULL, '0', '0', 'lizong', '2021-11-20 16:47:14', '', NULL, '77864606', NULL);
INSERT INTO `sys_dept` VALUES (263, 259, '0,257,258,259', '1号', 0, NULL, NULL, NULL, '0', '0', 'lizong', '2021-11-20 16:47:20', 'lizong', '2021-11-20 17:33:52', '77864606', NULL);
INSERT INTO `sys_dept` VALUES (264, 259, '0,257,258,259', '2号', 0, NULL, NULL, NULL, '0', '0', 'lizong', '2021-11-20 16:47:35', 'lizong', '2021-11-20 17:34:17', '77864606', NULL);
INSERT INTO `sys_dept` VALUES (265, 257, '0,257', '2层', 0, NULL, NULL, NULL, '0', '0', 'lizong', '2021-11-20 17:35:47', '', NULL, '77864606', NULL);
INSERT INTO `sys_dept` VALUES (266, 0, '0', '2号锅炉', 0, NULL, NULL, NULL, '0', '0', 'admin', '2021-11-29 10:24:34', '', NULL, '00000000', NULL);
INSERT INTO `sys_dept` VALUES (267, 266, '0,266', '1层', 0, NULL, NULL, NULL, '0', '2', 'admin', '2021-11-29 10:31:27', '', NULL, '00000000', NULL);
INSERT INTO `sys_dept` VALUES (268, 0, '0', '3号锅炉', 0, NULL, NULL, NULL, '0', '0', 'lizong', '2021-11-29 11:07:11', '', NULL, '77864606', NULL);
INSERT INTO `sys_dept` VALUES (269, 259, '0,257,258,259', '3号', 0, NULL, NULL, NULL, '0', '0', 'lizong', '2021-11-29 11:08:16', '', NULL, '77864606', NULL);
INSERT INTO `sys_dept` VALUES (270, 260, '0,257,258,260', '1', 0, NULL, NULL, NULL, '0', '0', 'lizong', '2021-12-12 19:25:30', '', NULL, '77864606', NULL);
INSERT INTO `sys_dept` VALUES (271, 269, '0,257,258,259,269', '4号', 0, NULL, NULL, NULL, '0', '2', 'lizong', '2021-12-13 16:29:21', '', NULL, '77864606', NULL);
INSERT INTO `sys_dept` VALUES (272, 259, '0,257,258,259', '4号', 0, NULL, NULL, NULL, '0', '0', 'lizong', '2021-12-13 16:29:39', '', NULL, '77864606', NULL);
INSERT INTO `sys_dept` VALUES (273, 259, '0,257,258,259', '5号', 0, NULL, NULL, NULL, '0', '0', 'lizong', '2021-12-13 16:29:48', '', NULL, '77864606', NULL);
COMMIT;

-- ----------------------------
-- Table structure for sys_dict_data
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict_data`;
CREATE TABLE `sys_dict_data` (
  `dict_code` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '字典编码',
  `dict_sort` int(4) DEFAULT '0' COMMENT '字典排序',
  `dict_label` varchar(100) DEFAULT '' COMMENT '字典标签',
  `dict_value` varchar(100) DEFAULT '' COMMENT '字典键值',
  `dict_type` varchar(100) DEFAULT '' COMMENT '字典类型',
  `css_class` varchar(100) DEFAULT NULL COMMENT '样式属性（其他样式扩展）',
  `list_class` varchar(100) DEFAULT NULL COMMENT '表格回显样式',
  `is_default` char(1) DEFAULT 'N' COMMENT '是否默认（Y是 N否）',
  `status` char(1) DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `tenant_id` varchar(8) NOT NULL DEFAULT '00000000',
  PRIMARY KEY (`dict_code`)
) ENGINE=InnoDB AUTO_INCREMENT=105 DEFAULT CHARSET=utf8mb4 COMMENT='字典数据表';

-- ----------------------------
-- Records of sys_dict_data
-- ----------------------------
BEGIN;
INSERT INTO `sys_dict_data` VALUES (1, 1, '男', '0', 'sys_user_sex', '', '', 'Y', '0', 'admin', '2021-09-21 17:01:53', '', NULL, '性别男', '00000000');
INSERT INTO `sys_dict_data` VALUES (2, 2, '女', '1', 'sys_user_sex', '', '', 'N', '0', 'admin', '2021-09-21 17:01:53', '', NULL, '性别女', '00000000');
INSERT INTO `sys_dict_data` VALUES (3, 3, '未知', '2', 'sys_user_sex', '', '', 'N', '0', 'admin', '2021-09-21 17:01:54', '', NULL, '性别未知', '00000000');
INSERT INTO `sys_dict_data` VALUES (4, 1, '显示', '0', 'sys_show_hide', '', 'primary', 'Y', '0', 'admin', '2021-09-21 17:01:54', '', NULL, '显示菜单', '00000000');
INSERT INTO `sys_dict_data` VALUES (5, 2, '隐藏', '1', 'sys_show_hide', '', 'danger', 'N', '0', 'admin', '2021-09-21 17:01:54', '', NULL, '隐藏菜单', '00000000');
INSERT INTO `sys_dict_data` VALUES (6, 1, '正常', '0', 'sys_normal_disable', '', 'primary', 'Y', '0', 'admin', '2021-09-21 17:01:55', '', NULL, '正常状态', '00000000');
INSERT INTO `sys_dict_data` VALUES (7, 2, '停用', '1', 'sys_normal_disable', '', 'danger', 'N', '0', 'admin', '2021-09-21 17:01:55', '', NULL, '停用状态', '00000000');
INSERT INTO `sys_dict_data` VALUES (8, 1, '正常', '0', 'sys_job_status', '', 'primary', 'Y', '0', 'admin', '2021-09-21 17:01:55', '', NULL, '正常状态', '00000000');
INSERT INTO `sys_dict_data` VALUES (9, 2, '暂停', '1', 'sys_job_status', '', 'danger', 'N', '0', 'admin', '2021-09-21 17:01:56', '', NULL, '停用状态', '00000000');
INSERT INTO `sys_dict_data` VALUES (10, 1, '默认', 'DEFAULT', 'sys_job_group', '', '', 'Y', '0', 'admin', '2021-09-21 17:01:56', '', NULL, '默认分组', '00000000');
INSERT INTO `sys_dict_data` VALUES (11, 2, '系统', 'SYSTEM', 'sys_job_group', '', '', 'N', '0', 'admin', '2021-09-21 17:01:56', '', NULL, '系统分组', '00000000');
INSERT INTO `sys_dict_data` VALUES (12, 1, '是', 'Y', 'sys_yes_no', '', 'primary', 'Y', '0', 'admin', '2021-09-21 17:01:57', '', NULL, '系统默认是', '00000000');
INSERT INTO `sys_dict_data` VALUES (13, 2, '否', 'N', 'sys_yes_no', '', 'danger', 'N', '0', 'admin', '2021-09-21 17:01:57', '', NULL, '系统默认否', '00000000');
INSERT INTO `sys_dict_data` VALUES (14, 1, '通知', '1', 'sys_notice_type', '', 'warning', 'Y', '0', 'admin', '2021-09-21 17:01:58', '', NULL, '通知', '00000000');
INSERT INTO `sys_dict_data` VALUES (15, 2, '公告', '2', 'sys_notice_type', '', 'success', 'N', '0', 'admin', '2021-09-21 17:01:58', '', NULL, '公告', '00000000');
INSERT INTO `sys_dict_data` VALUES (16, 1, '正常', '0', 'sys_notice_status', '', 'primary', 'Y', '0', 'admin', '2021-09-21 17:01:58', '', NULL, '正常状态', '00000000');
INSERT INTO `sys_dict_data` VALUES (17, 2, '关闭', '1', 'sys_notice_status', '', 'danger', 'N', '0', 'admin', '2021-09-21 17:01:59', '', NULL, '关闭状态', '00000000');
INSERT INTO `sys_dict_data` VALUES (18, 1, '新增', '1', 'sys_oper_type', '', 'info', 'N', '0', 'admin', '2021-09-21 17:01:59', '', NULL, '新增操作', '00000000');
INSERT INTO `sys_dict_data` VALUES (19, 2, '修改', '2', 'sys_oper_type', '', 'info', 'N', '0', 'admin', '2021-09-21 17:01:59', '', NULL, '修改操作', '00000000');
INSERT INTO `sys_dict_data` VALUES (20, 3, '删除', '3', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2021-09-21 17:02:00', '', NULL, '删除操作', '00000000');
INSERT INTO `sys_dict_data` VALUES (21, 4, '授权', '4', 'sys_oper_type', '', 'primary', 'N', '0', 'admin', '2021-09-21 17:02:00', '', NULL, '授权操作', '00000000');
INSERT INTO `sys_dict_data` VALUES (22, 5, '导出', '5', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2021-09-21 17:02:01', '', NULL, '导出操作', '00000000');
INSERT INTO `sys_dict_data` VALUES (23, 6, '导入', '6', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2021-09-21 17:02:01', '', NULL, '导入操作', '00000000');
INSERT INTO `sys_dict_data` VALUES (24, 7, '强退', '7', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2021-09-21 17:02:01', '', NULL, '强退操作', '00000000');
INSERT INTO `sys_dict_data` VALUES (25, 8, '生成代码', '8', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2021-09-21 17:02:02', '', NULL, '生成操作', '00000000');
INSERT INTO `sys_dict_data` VALUES (26, 9, '清空数据', '9', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2021-09-21 17:02:02', '', NULL, '清空操作', '00000000');
INSERT INTO `sys_dict_data` VALUES (27, 1, '成功', '0', 'sys_common_status', '', 'primary', 'N', '0', 'admin', '2021-09-21 17:02:02', '', NULL, '正常状态', '00000000');
INSERT INTO `sys_dict_data` VALUES (28, 2, '失败', '1', 'sys_common_status', '', 'danger', 'N', '0', 'admin', '2021-09-21 17:02:03', '', NULL, '停用状态', '00000000');
INSERT INTO `sys_dict_data` VALUES (100, 1, '全部', '1', 'data_rule_type', NULL, 'default', 'N', '0', 'admin', '2021-10-24 20:08:27', 'admin', '2021-10-24 20:10:36', NULL, '00000000');
INSERT INTO `sys_dict_data` VALUES (101, 2, '本人可见', '2', 'data_rule_type', NULL, 'default', 'N', '0', 'admin', '2021-10-24 20:08:47', 'admin', '2021-10-24 20:09:58', NULL, '00000000');
INSERT INTO `sys_dict_data` VALUES (102, 3, '所在机构可见', '3', 'data_rule_type', NULL, 'default', 'N', '0', 'admin', '2021-10-24 20:09:34', 'admin', '2021-10-24 20:10:46', NULL, '00000000');
INSERT INTO `sys_dict_data` VALUES (103, 4, '所在机构及子级可见', '4', 'data_rule_type', NULL, 'default', 'N', '0', 'admin', '2021-10-24 20:10:15', 'admin', '2021-10-24 20:10:40', NULL, '00000000');
INSERT INTO `sys_dict_data` VALUES (104, 5, '自定义', '5', 'data_rule_type', NULL, 'default', 'N', '0', 'admin', '2021-10-24 20:10:27', '', NULL, NULL, '00000000');
COMMIT;

-- ----------------------------
-- Table structure for sys_dict_type
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict_type`;
CREATE TABLE `sys_dict_type` (
  `dict_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '字典主键',
  `dict_name` varchar(100) DEFAULT '' COMMENT '字典名称',
  `dict_type` varchar(100) DEFAULT '' COMMENT '字典类型',
  `status` char(1) DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `tenant_id` varchar(8) NOT NULL DEFAULT '00000000',
  PRIMARY KEY (`dict_id`),
  UNIQUE KEY `dict_type` (`dict_type`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COMMENT='字典类型表';

-- ----------------------------
-- Records of sys_dict_type
-- ----------------------------
BEGIN;
INSERT INTO `sys_dict_type` VALUES (1, '用户性别', 'sys_user_sex', '0', 'admin', '2021-09-21 17:01:49', '', NULL, '用户性别列表', '00000000');
INSERT INTO `sys_dict_type` VALUES (2, '菜单状态', 'sys_show_hide', '0', 'admin', '2021-09-21 17:01:49', '', NULL, '菜单状态列表', '00000000');
INSERT INTO `sys_dict_type` VALUES (3, '系统开关', 'sys_normal_disable', '0', 'admin', '2021-09-21 17:01:49', '', NULL, '系统开关列表', '00000000');
INSERT INTO `sys_dict_type` VALUES (4, '任务状态', 'sys_job_status', '0', 'admin', '2021-09-21 17:01:50', '', NULL, '任务状态列表', '00000000');
INSERT INTO `sys_dict_type` VALUES (5, '任务分组', 'sys_job_group', '0', 'admin', '2021-09-21 17:01:50', '', NULL, '任务分组列表', '00000000');
INSERT INTO `sys_dict_type` VALUES (6, '系统是否', 'sys_yes_no', '0', 'admin', '2021-09-21 17:01:50', '', NULL, '系统是否列表', '00000000');
INSERT INTO `sys_dict_type` VALUES (7, '通知类型', 'sys_notice_type', '0', 'admin', '2021-09-21 17:01:51', '', NULL, '通知类型列表', '00000000');
INSERT INTO `sys_dict_type` VALUES (8, '通知状态', 'sys_notice_status', '0', 'admin', '2021-09-21 17:01:51', '', NULL, '通知状态列表', '00000000');
INSERT INTO `sys_dict_type` VALUES (9, '操作类型', 'sys_oper_type', '0', 'admin', '2021-09-21 17:01:51', '', NULL, '操作类型列表', '00000000');
INSERT INTO `sys_dict_type` VALUES (10, '系统状态', 'sys_common_status', '0', 'admin', '2021-09-21 17:01:52', '', NULL, '登录状态列表', '00000000');
INSERT INTO `sys_dict_type` VALUES (100, '数据权限类型', 'data_rule_type', '0', 'admin', '2021-10-24 20:07:28', '', NULL, NULL, '00000000');
COMMIT;

-- ----------------------------
-- Table structure for sys_file_info
-- ----------------------------
DROP TABLE IF EXISTS `sys_file_info`;
CREATE TABLE `sys_file_info` (
  `file_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '文件id',
  `file_name` varchar(50) DEFAULT '' COMMENT '文件名称',
  `file_path` varchar(255) DEFAULT '' COMMENT '文件路径',
  `overhaul_id` bigint(20) DEFAULT NULL COMMENT '维修id',
  `remark` longblob COMMENT '记录',
  `tenant_id` varchar(8) CHARACTER SET utf8mb4 NOT NULL DEFAULT '00000000',
  `dept_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`file_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COMMENT='文件信息表';

-- ----------------------------
-- Records of sys_file_info
-- ----------------------------
BEGIN;
INSERT INTO `sys_file_info` VALUES (6, '', '/profile/upload/2021/11/20/03774511-a8f5-44b4-8a77-254432023391.jpg', 2, NULL, '77864606', 263);
INSERT INTO `sys_file_info` VALUES (7, '', '/profile/upload/2021/11/20/7400f3e0-84f0-4b88-bf46-5372191e5193.jpeg', 2, NULL, '77864606', 264);
INSERT INTO `sys_file_info` VALUES (8, '', '/profile/upload/2021/11/20/a6969990-2b30-4f9f-aa23-9b86d3ee06a7.jpeg', 1, NULL, '77864606', 263);
INSERT INTO `sys_file_info` VALUES (9, '', '/profile/upload/2021/11/20/8e52a554-0fab-4eba-b0f3-57c7e24ca13f.jpeg', 1, NULL, '77864606', 264);
INSERT INTO `sys_file_info` VALUES (10, '', '/profile/upload/2021/11/20/52585501-960d-4167-8a40-2bcbd3362025.jpeg', 2, NULL, '77864606', 263);
INSERT INTO `sys_file_info` VALUES (11, '', '/profile/upload/2021/11/20/0f1f9258-5a35-4976-8408-c871c677ac4c.png', 2, NULL, '77864606', 264);
INSERT INTO `sys_file_info` VALUES (12, '', '/profile/upload/2021/11/20/b3d9117a-2cf6-4b69-ad38-9b8ed0929728.png', 2, NULL, '77864606', 263);
INSERT INTO `sys_file_info` VALUES (13, '', '/profile/upload/2021/11/20/f86daf67-f961-4dae-914c-313262454dbc.jpg', 2, NULL, '77864606', 263);
INSERT INTO `sys_file_info` VALUES (14, '', '/profile/upload/2021/11/22/d42745ad-a8aa-413d-a40e-6274603471d3.jpg', 4, NULL, '77864606', 263);
INSERT INTO `sys_file_info` VALUES (15, '', '/profile/upload/2021/11/22/0feb4a08-7c09-4373-a5f6-b225e82ff066.jpg', 4, NULL, '77864606', 264);
INSERT INTO `sys_file_info` VALUES (16, '', '/profile/upload/2021/11/29/be2c4db2-44c3-43f6-8770-acaef07d2a3a.jpg', 3, NULL, '77864606', 263);
INSERT INTO `sys_file_info` VALUES (17, '', '/profile/upload/2021/11/29/9875dad4-4959-4858-8c58-05b9a4884d52.jpg', 3, NULL, '77864606', 263);
INSERT INTO `sys_file_info` VALUES (18, '', '/profile/upload/2021/11/29/34f5b35e-5761-4d58-8e73-0fdc90d78614.jpg', 3, NULL, '77864606', 263);
INSERT INTO `sys_file_info` VALUES (19, '', '/profile/upload/2021/11/29/cb5ac022-e58e-4b94-8e39-5eed6840e1df.jpg', 3, NULL, '77864606', 263);
INSERT INTO `sys_file_info` VALUES (20, '', '/profile/upload/2021/12/12/1dc54284-6f28-450c-8d0a-72fcf9b8dc55.JPG', 3, NULL, '77864606', 264);
COMMIT;

-- ----------------------------
-- Table structure for sys_job
-- ----------------------------
DROP TABLE IF EXISTS `sys_job`;
CREATE TABLE `sys_job` (
  `job_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '任务ID',
  `job_name` varchar(64) NOT NULL DEFAULT '' COMMENT '任务名称',
  `job_group` varchar(64) NOT NULL DEFAULT 'DEFAULT' COMMENT '任务组名',
  `invoke_target` varchar(500) NOT NULL COMMENT '调用目标字符串',
  `cron_expression` varchar(255) DEFAULT '' COMMENT 'cron执行表达式',
  `misfire_policy` varchar(20) DEFAULT '3' COMMENT '计划执行错误策略（1立即执行 2执行一次 3放弃执行）',
  `concurrent` char(1) DEFAULT '1' COMMENT '是否并发执行（0允许 1禁止）',
  `status` char(1) DEFAULT '0' COMMENT '状态（0正常 1暂停）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) DEFAULT '' COMMENT '备注信息',
  `tenant_id` varchar(8) NOT NULL DEFAULT '00000000',
  PRIMARY KEY (`job_id`,`job_name`,`job_group`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COMMENT='定时任务调度表';

-- ----------------------------
-- Records of sys_job
-- ----------------------------
BEGIN;
INSERT INTO `sys_job` VALUES (1, '系统默认（无参）', 'DEFAULT', 'ryTask.ryNoParams', '0/10 * * * * ?', '3', '1', '1', 'admin', '2021-09-21 17:02:07', '', NULL, '', '00000000');
INSERT INTO `sys_job` VALUES (2, '系统默认（有参）', 'DEFAULT', 'ryTask.ryParams(\'ry\')', '0/15 * * * * ?', '3', '1', '1', 'admin', '2021-09-21 17:02:08', '', NULL, '', '00000000');
INSERT INTO `sys_job` VALUES (3, '系统默认（多参）', 'DEFAULT', 'ryTask.ryMultipleParams(\'ry\', true, 2000L, 316.50D, 100)', '0/20 * * * * ?', '3', '1', '1', 'admin', '2021-09-21 17:02:08', '', NULL, '', '00000000');
COMMIT;

-- ----------------------------
-- Table structure for sys_job_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_job_log`;
CREATE TABLE `sys_job_log` (
  `job_log_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '任务日志ID',
  `job_name` varchar(64) NOT NULL COMMENT '任务名称',
  `job_group` varchar(64) NOT NULL COMMENT '任务组名',
  `invoke_target` varchar(500) NOT NULL COMMENT '调用目标字符串',
  `job_message` varchar(500) DEFAULT NULL COMMENT '日志信息',
  `status` char(1) DEFAULT '0' COMMENT '执行状态（0正常 1失败）',
  `exception_info` varchar(2000) DEFAULT '' COMMENT '异常信息',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `tenant_id` varchar(8) NOT NULL DEFAULT '00000000',
  PRIMARY KEY (`job_log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='定时任务调度日志表';

-- ----------------------------
-- Table structure for sys_logininfor
-- ----------------------------
DROP TABLE IF EXISTS `sys_logininfor`;
CREATE TABLE `sys_logininfor` (
  `info_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '访问ID',
  `user_name` varchar(50) DEFAULT '' COMMENT '用户账号',
  `ipaddr` varchar(128) DEFAULT '' COMMENT '登录IP地址',
  `login_location` varchar(255) DEFAULT '' COMMENT '登录地点',
  `browser` varchar(50) DEFAULT '' COMMENT '浏览器类型',
  `os` varchar(50) DEFAULT '' COMMENT '操作系统',
  `status` char(1) DEFAULT '0' COMMENT '登录状态（0成功 1失败）',
  `msg` text COMMENT '提示消息',
  `login_time` datetime DEFAULT NULL COMMENT '访问时间',
  `tenant_id` varchar(8) NOT NULL DEFAULT '00000000',
  PRIMARY KEY (`info_id`)
) ENGINE=InnoDB AUTO_INCREMENT=521 DEFAULT CHARSET=utf8mb4 COMMENT='系统访问记录';

-- ----------------------------
-- Records of sys_logininfor
-- ----------------------------
BEGIN;
INSERT INTO `sys_logininfor` VALUES (100, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-09-21 17:04:41', '00000000');
INSERT INTO `sys_logininfor` VALUES (101, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码已失效', '2021-09-21 17:09:21', '00000000');
INSERT INTO `sys_logininfor` VALUES (102, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-09-21 17:09:27', '00000000');
INSERT INTO `sys_logininfor` VALUES (103, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-09-21 18:03:06', '00000000');
INSERT INTO `sys_logininfor` VALUES (104, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-08 14:38:59', '00000000');
INSERT INTO `sys_logininfor` VALUES (105, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-08 14:39:09', '00000000');
INSERT INTO `sys_logininfor` VALUES (106, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码已失效', '2021-10-08 14:44:54', '00000000');
INSERT INTO `sys_logininfor` VALUES (107, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-08 14:44:59', '00000000');
INSERT INTO `sys_logininfor` VALUES (108, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-08 14:50:49', '00000000');
INSERT INTO `sys_logininfor` VALUES (109, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-09 09:38:46', '00000000');
INSERT INTO `sys_logininfor` VALUES (110, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码已失效', '2021-10-09 12:03:11', '00000000');
INSERT INTO `sys_logininfor` VALUES (111, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-09 12:03:15', '00000000');
INSERT INTO `sys_logininfor` VALUES (112, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '0', '登录成功', '2021-10-10 12:58:40', '00000000');
INSERT INTO `sys_logininfor` VALUES (113, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '1', '验证码已失效', '2021-10-10 14:45:29', '00000000');
INSERT INTO `sys_logininfor` VALUES (114, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2021-10-10 14:45:33', '00000000');
INSERT INTO `sys_logininfor` VALUES (115, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '0', '登录成功', '2021-10-10 14:45:38', '00000000');
INSERT INTO `sys_logininfor` VALUES (116, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-10 15:55:38', '00000000');
INSERT INTO `sys_logininfor` VALUES (117, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-10 15:55:42', '00000000');
INSERT INTO `sys_logininfor` VALUES (118, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2021-10-10 15:55:47', '00000000');
INSERT INTO `sys_logininfor` VALUES (119, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-10 15:55:50', '00000000');
INSERT INTO `sys_logininfor` VALUES (120, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-10 15:57:14', '00000000');
INSERT INTO `sys_logininfor` VALUES (121, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-10 15:58:50', '00000000');
INSERT INTO `sys_logininfor` VALUES (122, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-10 15:58:56', '00000000');
INSERT INTO `sys_logininfor` VALUES (123, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-10 15:59:38', '00000000');
INSERT INTO `sys_logininfor` VALUES (124, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-10 16:01:12', '00000000');
INSERT INTO `sys_logininfor` VALUES (125, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-10 16:02:32', '00000000');
INSERT INTO `sys_logininfor` VALUES (126, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码错误', '2021-10-10 16:02:52', '00000000');
INSERT INTO `sys_logininfor` VALUES (127, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-10 16:02:57', '00000000');
INSERT INTO `sys_logininfor` VALUES (128, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-11 21:31:19', '00000000');
INSERT INTO `sys_logininfor` VALUES (129, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '0', '登录成功', '2021-10-11 22:30:43', '00000000');
INSERT INTO `sys_logininfor` VALUES (130, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-11 23:18:16', '00000000');
INSERT INTO `sys_logininfor` VALUES (131, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-12 14:35:51', '00000000');
INSERT INTO `sys_logininfor` VALUES (132, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-12 17:29:00', '00000000');
INSERT INTO `sys_logininfor` VALUES (133, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-12 18:07:11', '00000000');
INSERT INTO `sys_logininfor` VALUES (134, 'ruoyi', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-12 18:07:20', '00000000');
INSERT INTO `sys_logininfor` VALUES (135, 'ruoyi', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-12 18:07:21', '00000000');
INSERT INTO `sys_logininfor` VALUES (136, 'ruoyi', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### The error may exist in file [D:\\code\\research\\RuoYi-Vue-S\\ruoyi-system\\target\\classes\\mapper\\system\\SysUserMapper.xml]\r\n### The error may involve com.ruoyi.system.mapper.SysUserMapper.selectUserByUserName\r\n### The error occurred while executing a query\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-19 14:18:44', '00000000');
INSERT INTO `sys_logininfor` VALUES (137, 'ruoyi', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### The error may exist in file [D:\\code\\research\\RuoYi-Vue-S\\ruoyi-system\\target\\classes\\mapper\\system\\SysUserMapper.xml]\r\n### The error may involve com.ruoyi.system.mapper.SysUserMapper.selectUserByUserName\r\n### The error occurred while executing a query\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-19 14:24:45', '00000000');
INSERT INTO `sys_logininfor` VALUES (138, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### The error may exist in file [D:\\code\\research\\RuoYi-Vue-S\\ruoyi-system\\target\\classes\\mapper\\system\\SysUserMapper.xml]\r\n### The error may involve com.ruoyi.system.mapper.SysUserMapper.selectUserByUserName\r\n### The error occurred while executing a query\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-19 14:25:11', '00000000');
INSERT INTO `sys_logininfor` VALUES (139, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码错误', '2021-10-19 14:25:35', '00000000');
INSERT INTO `sys_logininfor` VALUES (140, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### The error may exist in file [D:\\code\\research\\RuoYi-Vue-S\\ruoyi-system\\target\\classes\\mapper\\system\\SysUserMapper.xml]\r\n### The error may involve com.ruoyi.system.mapper.SysUserMapper.selectUserByUserName\r\n### The error occurred while executing a query\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-19 14:25:40', '00000000');
INSERT INTO `sys_logininfor` VALUES (141, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码已失效', '2021-10-19 14:30:27', '00000000');
INSERT INTO `sys_logininfor` VALUES (142, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### The error may exist in file [D:\\code\\research\\RuoYi-Vue-S\\ruoyi-system\\target\\classes\\mapper\\system\\SysUserMapper.xml]\r\n### The error may involve com.ruoyi.system.mapper.SysUserMapper.selectUserByUserName\r\n### The error occurred while executing a query\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-19 14:30:31', '00000000');
INSERT INTO `sys_logininfor` VALUES (143, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码已失效', '2021-10-19 14:41:23', '00000000');
INSERT INTO `sys_logininfor` VALUES (144, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-19 14:41:28', '00000000');
INSERT INTO `sys_logininfor` VALUES (145, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-19 14:44:45', '00000000');
INSERT INTO `sys_logininfor` VALUES (146, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-19 14:44:54', '00000000');
INSERT INTO `sys_logininfor` VALUES (147, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-19 14:45:01', '00000000');
INSERT INTO `sys_logininfor` VALUES (148, 'ruoyi', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-19 14:45:08', '00000000');
INSERT INTO `sys_logininfor` VALUES (149, 'ruoyi', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-19 14:45:09', '00000000');
INSERT INTO `sys_logininfor` VALUES (150, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-19 14:47:47', '00000000');
INSERT INTO `sys_logininfor` VALUES (151, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-19 14:47:57', '00000000');
INSERT INTO `sys_logininfor` VALUES (152, 'ruoyi', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码错误', '2021-10-19 14:48:08', '00000000');
INSERT INTO `sys_logininfor` VALUES (153, 'ruoyi', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-19 14:48:15', '00000000');
INSERT INTO `sys_logininfor` VALUES (154, 'ruoyi', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-19 14:48:25', '00000000');
INSERT INTO `sys_logininfor` VALUES (155, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-19 14:48:33', '00000000');
INSERT INTO `sys_logininfor` VALUES (156, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-19 14:57:08', '00000000');
INSERT INTO `sys_logininfor` VALUES (157, 'ruoyi', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-19 14:57:17', '00000000');
INSERT INTO `sys_logininfor` VALUES (158, 'ruoyi', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-19 15:01:49', '00000000');
INSERT INTO `sys_logininfor` VALUES (159, 'ruoyi', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-19 15:01:59', '00000000');
INSERT INTO `sys_logininfor` VALUES (160, 'ruoyi', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-19 15:08:52', '00000000');
INSERT INTO `sys_logininfor` VALUES (161, 'ruoyi', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-19 15:09:01', '00000000');
INSERT INTO `sys_logininfor` VALUES (162, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### The error may exist in file [D:\\code\\research\\RuoYi-Vue-S\\ruoyi-system\\target\\classes\\mapper\\system\\SysUserMapper.xml]\r\n### The error may involve com.ruoyi.system.mapper.SysUserMapper.selectUserByUserName\r\n### The error occurred while executing a query\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-19 15:59:24', '00000000');
INSERT INTO `sys_logininfor` VALUES (163, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### The error may exist in file [D:\\code\\research\\RuoYi-Vue-S\\ruoyi-system\\target\\classes\\mapper\\system\\SysUserMapper.xml]\r\n### The error may involve com.ruoyi.system.mapper.SysUserMapper.selectUserByUserName\r\n### The error occurred while executing a query\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-19 16:01:19', '00000000');
INSERT INTO `sys_logininfor` VALUES (164, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-19 16:11:50', '00000000');
INSERT INTO `sys_logininfor` VALUES (165, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### The error may exist in file [D:\\code\\research\\RuoYi-Vue-S\\ruoyi-system\\target\\classes\\mapper\\system\\SysUserMapper.xml]\r\n### The error may involve com.ruoyi.system.mapper.SysUserMapper.selectUserByUserName\r\n### The error occurred while executing a query\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-19 16:16:19', '00000000');
INSERT INTO `sys_logininfor` VALUES (166, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### The error may exist in file [D:\\code\\research\\RuoYi-Vue-S\\ruoyi-system\\target\\classes\\mapper\\system\\SysUserMapper.xml]\r\n### The error may involve com.ruoyi.system.mapper.SysUserMapper.selectUserByUserName\r\n### The error occurred while executing a query\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-19 16:19:52', '00000000');
INSERT INTO `sys_logininfor` VALUES (167, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码已失效', '2021-10-19 16:24:23', '00000000');
INSERT INTO `sys_logininfor` VALUES (168, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### The error may exist in file [D:\\code\\research\\RuoYi-Vue-S\\ruoyi-system\\target\\classes\\mapper\\system\\SysUserMapper.xml]\r\n### The error may involve com.ruoyi.system.mapper.SysUserMapper.selectUserByUserName\r\n### The error occurred while executing a query\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-19 16:24:28', '00000000');
INSERT INTO `sys_logininfor` VALUES (169, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码错误', '2021-10-19 16:26:10', '00000000');
INSERT INTO `sys_logininfor` VALUES (170, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-19 16:27:41', '00000000');
INSERT INTO `sys_logininfor` VALUES (171, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码错误', '2021-10-19 16:30:55', '00000000');
INSERT INTO `sys_logininfor` VALUES (172, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### The error may exist in file [D:\\code\\research\\RuoYi-Vue-S\\ruoyi-system\\target\\classes\\mapper\\system\\SysUserMapper.xml]\r\n### The error may involve com.ruoyi.system.mapper.SysUserMapper.selectUserByUserName\r\n### The error occurred while executing a query\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-19 16:31:00', '00000000');
INSERT INTO `sys_logininfor` VALUES (173, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### The error may exist in file [D:\\code\\research\\RuoYi-Vue-S\\ruoyi-system\\target\\classes\\mapper\\system\\SysUserMapper.xml]\r\n### The error may involve com.ruoyi.system.mapper.SysUserMapper.selectUserByUserName\r\n### The error occurred while executing a query\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-19 16:32:34', '00000000');
INSERT INTO `sys_logininfor` VALUES (174, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码已失效', '2021-10-19 16:33:58', '00000000');
INSERT INTO `sys_logininfor` VALUES (175, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### The error may exist in file [D:\\code\\research\\RuoYi-Vue-S\\ruoyi-system\\target\\classes\\mapper\\system\\SysUserMapper.xml]\r\n### The error may involve com.ruoyi.system.mapper.SysUserMapper.selectUserByUserName\r\n### The error occurred while executing a query\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-19 16:39:05', '00000000');
INSERT INTO `sys_logininfor` VALUES (176, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', 'nested exception is org.apache.ibatis.exceptions.PersistenceException: \r\n### Error querying database.  Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常\r\n### The error may exist in file [D:\\code\\research\\RuoYi-Vue-S\\ruoyi-system\\target\\classes\\mapper\\system\\SysUserMapper.xml]\r\n### The error may involve com.ruoyi.system.mapper.SysUserMapper.selectUserByUserName\r\n### The error occurred while executing a query\r\n### Cause: com.ruoyi.common.exception.ServiceException: 获取用户信息异常', '2021-10-19 16:46:20', '00000000');
INSERT INTO `sys_logininfor` VALUES (177, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码已失效', '2021-10-19 16:54:19', '00000000');
INSERT INTO `sys_logininfor` VALUES (178, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-19 16:54:33', '00000000');
INSERT INTO `sys_logininfor` VALUES (179, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-20 11:23:22', '00000000');
INSERT INTO `sys_logininfor` VALUES (180, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-21 20:42:56', '00000000');
INSERT INTO `sys_logininfor` VALUES (181, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2021-10-22 11:31:35', '00000000');
INSERT INTO `sys_logininfor` VALUES (182, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-22 11:54:54', '00000000');
INSERT INTO `sys_logininfor` VALUES (183, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2021-10-22 13:21:17', '00000000');
INSERT INTO `sys_logininfor` VALUES (184, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-22 13:22:41', '00000000');
INSERT INTO `sys_logininfor` VALUES (185, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-22 14:09:40', '00000000');
INSERT INTO `sys_logininfor` VALUES (186, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2021-10-22 14:21:07', '00000000');
INSERT INTO `sys_logininfor` VALUES (187, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-22 16:13:36', '00000000');
INSERT INTO `sys_logininfor` VALUES (188, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-22 22:35:00', '00000000');
INSERT INTO `sys_logininfor` VALUES (189, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '0', '登录成功', '2021-10-22 22:55:32', '00000000');
INSERT INTO `sys_logininfor` VALUES (190, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '0', '登录成功', '2021-10-23 10:45:53', '00000000');
INSERT INTO `sys_logininfor` VALUES (191, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '0', '登录成功', '2021-10-23 11:31:35', '00000000');
INSERT INTO `sys_logininfor` VALUES (192, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '0', '登录成功', '2021-10-23 17:05:57', '00000000');
INSERT INTO `sys_logininfor` VALUES (193, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '0', '登录成功', '2021-10-23 22:32:24', '00000000');
INSERT INTO `sys_logininfor` VALUES (194, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '0', '登录成功', '2021-10-24 12:04:01', '00000000');
INSERT INTO `sys_logininfor` VALUES (195, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '0', '登录成功', '2021-10-24 12:59:55', '00000000');
INSERT INTO `sys_logininfor` VALUES (196, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '0', '登录成功', '2021-10-24 19:46:35', '00000000');
INSERT INTO `sys_logininfor` VALUES (197, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2021-10-25 09:35:56', '00000000');
INSERT INTO `sys_logininfor` VALUES (198, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-25 10:43:27', '00000000');
INSERT INTO `sys_logininfor` VALUES (199, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-25 11:36:04', '00000000');
INSERT INTO `sys_logininfor` VALUES (200, 'ruoyi', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-25 11:36:13', '00000000');
INSERT INTO `sys_logininfor` VALUES (201, 'ruoyi', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-25 11:36:26', '00000000');
INSERT INTO `sys_logininfor` VALUES (202, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-25 11:36:37', '00000000');
INSERT INTO `sys_logininfor` VALUES (203, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-25 11:40:17', '00000000');
INSERT INTO `sys_logininfor` VALUES (204, 'ry', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-25 11:40:24', '00000000');
INSERT INTO `sys_logininfor` VALUES (205, 'ry', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-25 11:50:16', '00000000');
INSERT INTO `sys_logininfor` VALUES (206, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码错误', '2021-10-25 11:50:23', '00000000');
INSERT INTO `sys_logininfor` VALUES (207, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码错误', '2021-10-25 11:50:27', '00000000');
INSERT INTO `sys_logininfor` VALUES (208, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-25 11:50:34', '00000000');
INSERT INTO `sys_logininfor` VALUES (209, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-25 11:51:09', '00000000');
INSERT INTO `sys_logininfor` VALUES (210, 'ry', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-25 11:51:15', '00000000');
INSERT INTO `sys_logininfor` VALUES (211, 'ry', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-25 11:53:20', '00000000');
INSERT INTO `sys_logininfor` VALUES (212, 'ry', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-25 11:53:25', '00000000');
INSERT INTO `sys_logininfor` VALUES (213, 'ry', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-25 11:56:38', '00000000');
INSERT INTO `sys_logininfor` VALUES (214, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-25 11:56:47', '00000000');
INSERT INTO `sys_logininfor` VALUES (215, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-25 18:28:11', '00000000');
INSERT INTO `sys_logininfor` VALUES (216, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-25 18:29:35', '00000000');
INSERT INTO `sys_logininfor` VALUES (217, 'ry', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-25 18:29:43', '00000000');
INSERT INTO `sys_logininfor` VALUES (218, 'ry', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-25 18:33:38', '00000000');
INSERT INTO `sys_logininfor` VALUES (219, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-25 18:33:42', '00000000');
INSERT INTO `sys_logininfor` VALUES (220, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-25 18:34:38', '00000000');
INSERT INTO `sys_logininfor` VALUES (221, 'ry', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-25 18:34:45', '00000000');
INSERT INTO `sys_logininfor` VALUES (222, 'ry', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-25 18:49:15', '00000000');
INSERT INTO `sys_logininfor` VALUES (223, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-25 18:49:27', '00000000');
INSERT INTO `sys_logininfor` VALUES (224, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-25 18:51:28', '00000000');
INSERT INTO `sys_logininfor` VALUES (225, 'ry', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-25 18:51:34', '00000000');
INSERT INTO `sys_logininfor` VALUES (226, 'ry', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-25 18:52:36', '00000000');
INSERT INTO `sys_logininfor` VALUES (227, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-25 18:52:40', '00000000');
INSERT INTO `sys_logininfor` VALUES (228, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-25 18:58:41', '00000000');
INSERT INTO `sys_logininfor` VALUES (229, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-25 18:58:45', '00000000');
INSERT INTO `sys_logininfor` VALUES (230, 'admin', '127.0.0.1', '内网IP', 'Chrome 8', 'Windows 10', '0', '登录成功', '2021-10-25 18:59:16', '00000000');
INSERT INTO `sys_logininfor` VALUES (231, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-25 19:01:26', '00000000');
INSERT INTO `sys_logininfor` VALUES (232, 'ry', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-25 19:01:37', '00000000');
INSERT INTO `sys_logininfor` VALUES (233, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-26 16:32:04', '00000000');
INSERT INTO `sys_logininfor` VALUES (234, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-10-26 16:32:18', '00000000');
INSERT INTO `sys_logininfor` VALUES (235, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-10-26 16:32:38', '00000000');
INSERT INTO `sys_logininfor` VALUES (236, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 09:34:08', '00000000');
INSERT INTO `sys_logininfor` VALUES (237, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-17 09:54:33', '00000000');
INSERT INTO `sys_logininfor` VALUES (238, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码已失效', '2021-11-17 09:57:03', '00000000');
INSERT INTO `sys_logininfor` VALUES (239, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 09:57:07', '00000000');
INSERT INTO `sys_logininfor` VALUES (240, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Mac OS X', '1', '验证码错误', '2021-11-17 10:04:33', '00000000');
INSERT INTO `sys_logininfor` VALUES (241, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Mac OS X', '1', '验证码错误', '2021-11-17 10:04:36', '00000000');
INSERT INTO `sys_logininfor` VALUES (242, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 10:04:48', '00000000');
INSERT INTO `sys_logininfor` VALUES (243, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-17 10:06:10', '00000000');
INSERT INTO `sys_logininfor` VALUES (244, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Mac OS X', '1', 'nested exception is org.apache.ibatis.exceptions.TooManyResultsException: Expected one result (or null) to be returned by selectOne(), but found: 2', '2021-11-17 10:06:16', '00000000');
INSERT INTO `sys_logininfor` VALUES (245, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-17 10:09:16', '00000000');
INSERT INTO `sys_logininfor` VALUES (246, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Mac OS X', '1', '验证码已失效', '2021-11-17 10:24:45', '00000000');
INSERT INTO `sys_logininfor` VALUES (247, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Mac OS X', '1', 'nested exception is org.apache.ibatis.exceptions.TooManyResultsException: Expected one result (or null) to be returned by selectOne(), but found: 2', '2021-11-17 10:24:48', '00000000');
INSERT INTO `sys_logininfor` VALUES (248, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码已失效', '2021-11-17 10:31:25', '00000000');
INSERT INTO `sys_logininfor` VALUES (249, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 10:31:28', '00000000');
INSERT INTO `sys_logininfor` VALUES (250, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-17 11:01:27', '00000000');
INSERT INTO `sys_logininfor` VALUES (251, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '\n### Error querying database.  Cause: java.sql.SQLSyntaxErrorException: Unknown column \'salt\' in \'field list\'\n### The error may exist in com/ruoyi/system/mapper/SysUserMapper.java (best guess)\n### The error may involve defaultParameterMap\n### The error occurred while setting parameters\n### SQL: SELECT user_id, dept_id, user_name, nick_name, email, phonenumber, sex, avatar, password, salt, status, del_flag, login_ip, login_date, dept, roles, role_ids, post_ids, role_id, tenant_id, create_by, create_time, update_by, update_time, remark FROM sys_user WHERE (user_name = ? AND tenant_id = ?)\n### Cause: java.sql.SQLSyntaxErrorException: Unknown column \'salt\' in \'field list\'\n; bad SQL grammar []; nested exception is java.sql.SQLSyntaxErrorException: Unknown column \'salt\' in \'field list\'', '2021-11-17 11:01:41', '00000000');
INSERT INTO `sys_logininfor` VALUES (252, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '验证码错误', '2021-11-17 11:03:16', '00000000');
INSERT INTO `sys_logininfor` VALUES (253, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '\n### Error querying database.  Cause: java.sql.SQLSyntaxErrorException: Unknown column \'dept\' in \'field list\'\n### The error may exist in com/ruoyi/system/mapper/SysUserMapper.java (best guess)\n### The error may involve defaultParameterMap\n### The error occurred while setting parameters\n### SQL: SELECT user_id, dept_id, user_name, nick_name, email, phonenumber, sex, avatar, password, status, del_flag, login_ip, login_date, dept, roles, role_ids, post_ids, role_id, tenant_id, create_by, create_time, update_by, update_time, remark FROM sys_user WHERE (user_name = ? AND tenant_id = ?)\n### Cause: java.sql.SQLSyntaxErrorException: Unknown column \'dept\' in \'field list\'\n; bad SQL grammar []; nested exception is java.sql.SQLSyntaxErrorException: Unknown column \'dept\' in \'field list\'', '2021-11-17 11:03:19', '00000000');
INSERT INTO `sys_logininfor` VALUES (254, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '登录用户：admin 不存在', '2021-11-17 11:04:25', '00000000');
INSERT INTO `sys_logininfor` VALUES (255, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '验证码已失效', '2021-11-17 11:07:41', '00000000');
INSERT INTO `sys_logininfor` VALUES (256, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '验证码错误', '2021-11-17 11:07:51', '00000000');
INSERT INTO `sys_logininfor` VALUES (257, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 11:09:00', '00000000');
INSERT INTO `sys_logininfor` VALUES (258, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '验证码已失效', '2021-11-17 11:13:08', '00000000');
INSERT INTO `sys_logininfor` VALUES (259, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 11:13:13', '00000000');
INSERT INTO `sys_logininfor` VALUES (260, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 11:26:56', '00000000');
INSERT INTO `sys_logininfor` VALUES (261, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '验证码错误', '2021-11-17 11:27:13', '00000000');
INSERT INTO `sys_logininfor` VALUES (262, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 11:27:20', '00000000');
INSERT INTO `sys_logininfor` VALUES (263, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 11:30:15', '00000000');
INSERT INTO `sys_logininfor` VALUES (264, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 11:58:54', '00000000');
INSERT INTO `sys_logininfor` VALUES (265, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 11:59:05', '00000000');
INSERT INTO `sys_logininfor` VALUES (266, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '验证码已失效', '2021-11-17 14:07:35', '00000000');
INSERT INTO `sys_logininfor` VALUES (267, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 14:07:44', '00000000');
INSERT INTO `sys_logininfor` VALUES (268, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-17 14:08:55', '00000000');
INSERT INTO `sys_logininfor` VALUES (269, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '登录用户：test001 不存在', '2021-11-17 14:09:07', '00000000');
INSERT INTO `sys_logininfor` VALUES (270, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 14:09:16', '00000000');
INSERT INTO `sys_logininfor` VALUES (271, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-17 14:09:55', '00000000');
INSERT INTO `sys_logininfor` VALUES (272, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '登录用户：test001 不存在', '2021-11-17 14:10:06', '00000000');
INSERT INTO `sys_logininfor` VALUES (273, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '验证码错误', '2021-11-17 14:10:14', '00000000');
INSERT INTO `sys_logininfor` VALUES (274, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '登录用户：test001 不存在', '2021-11-17 14:10:17', '00000000');
INSERT INTO `sys_logininfor` VALUES (275, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '验证码错误', '2021-11-17 14:10:29', '00000000');
INSERT INTO `sys_logininfor` VALUES (276, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 14:10:32', '00000000');
INSERT INTO `sys_logininfor` VALUES (277, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-17 14:12:17', '00000000');
INSERT INTO `sys_logininfor` VALUES (278, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '登录用户：test001 不存在', '2021-11-17 14:12:34', '00000000');
INSERT INTO `sys_logininfor` VALUES (279, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '登录用户：test001 不存在', '2021-11-17 14:13:21', '00000000');
INSERT INTO `sys_logininfor` VALUES (280, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码错误', '2021-11-17 14:14:25', '00000000');
INSERT INTO `sys_logininfor` VALUES (281, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 14:18:00', '00000000');
INSERT INTO `sys_logininfor` VALUES (282, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '验证码错误', '2021-11-17 14:18:23', '00000000');
INSERT INTO `sys_logininfor` VALUES (283, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '登录用户：test001 不存在', '2021-11-17 14:18:31', '00000000');
INSERT INTO `sys_logininfor` VALUES (284, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '登录用户：test001 不存在', '2021-11-17 14:18:37', '00000000');
INSERT INTO `sys_logininfor` VALUES (285, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-17 14:19:08', '00000000');
INSERT INTO `sys_logininfor` VALUES (286, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码错误', '2021-11-17 14:19:21', '00000000');
INSERT INTO `sys_logininfor` VALUES (287, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码错误', '2021-11-17 14:21:14', '00000000');
INSERT INTO `sys_logininfor` VALUES (288, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码错误', '2021-11-17 14:22:21', '00000000');
INSERT INTO `sys_logininfor` VALUES (289, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 14:24:04', '00000000');
INSERT INTO `sys_logininfor` VALUES (290, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '登录用户：admin 不存在', '2021-11-17 14:25:01', '00000000');
INSERT INTO `sys_logininfor` VALUES (291, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码错误', '2021-11-17 14:25:06', '00000000');
INSERT INTO `sys_logininfor` VALUES (292, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 14:25:09', '00000000');
INSERT INTO `sys_logininfor` VALUES (293, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-17 14:26:20', '00000000');
INSERT INTO `sys_logininfor` VALUES (294, 'jiazeyong', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 14:26:34', '00000000');
INSERT INTO `sys_logininfor` VALUES (295, 'jiazeyong', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-17 14:29:15', '00000000');
INSERT INTO `sys_logininfor` VALUES (296, 'jiazeyong', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 14:29:27', '00000000');
INSERT INTO `sys_logininfor` VALUES (297, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-17 14:29:45', '00000000');
INSERT INTO `sys_logininfor` VALUES (298, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 14:30:13', '00000000');
INSERT INTO `sys_logininfor` VALUES (299, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-17 14:34:06', '00000000');
INSERT INTO `sys_logininfor` VALUES (300, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 14:34:25', '00000000');
INSERT INTO `sys_logininfor` VALUES (301, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-17 14:38:17', '00000000');
INSERT INTO `sys_logininfor` VALUES (302, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 14:38:29', '00000000');
INSERT INTO `sys_logininfor` VALUES (303, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-17 14:39:09', '00000000');
INSERT INTO `sys_logininfor` VALUES (304, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 14:39:22', '00000000');
INSERT INTO `sys_logininfor` VALUES (305, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-17 14:43:20', '00000000');
INSERT INTO `sys_logininfor` VALUES (306, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 14:43:35', '00000000');
INSERT INTO `sys_logininfor` VALUES (307, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-17 14:46:30', '00000000');
INSERT INTO `sys_logininfor` VALUES (308, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 14:47:56', '00000000');
INSERT INTO `sys_logininfor` VALUES (309, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-17 14:55:24', '00000000');
INSERT INTO `sys_logininfor` VALUES (310, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 14:56:21', '00000000');
INSERT INTO `sys_logininfor` VALUES (311, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-17 15:00:07', '00000000');
INSERT INTO `sys_logininfor` VALUES (312, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 15:00:34', '00000000');
INSERT INTO `sys_logininfor` VALUES (313, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-17 15:06:11', '00000000');
INSERT INTO `sys_logininfor` VALUES (314, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 15:07:28', '00000000');
INSERT INTO `sys_logininfor` VALUES (315, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-17 15:08:26', '00000000');
INSERT INTO `sys_logininfor` VALUES (316, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 15:08:43', '00000000');
INSERT INTO `sys_logininfor` VALUES (317, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-17 15:09:48', '00000000');
INSERT INTO `sys_logininfor` VALUES (318, 'xin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 15:10:15', '00000000');
INSERT INTO `sys_logininfor` VALUES (319, 'xin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-17 15:11:14', '00000000');
INSERT INTO `sys_logininfor` VALUES (320, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 15:11:31', '00000000');
INSERT INTO `sys_logininfor` VALUES (321, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-17 15:12:46', '00000000');
INSERT INTO `sys_logininfor` VALUES (322, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 15:14:39', '00000000');
INSERT INTO `sys_logininfor` VALUES (323, 'test001', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-17 15:16:56', '00000000');
INSERT INTO `sys_logininfor` VALUES (324, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 15:17:14', '00000000');
INSERT INTO `sys_logininfor` VALUES (325, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 15:22:02', '00000000');
INSERT INTO `sys_logininfor` VALUES (326, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-17 15:22:20', '00000000');
INSERT INTO `sys_logininfor` VALUES (327, 'jiazeyong', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '登录用户：jiazeyong 不存在', '2021-11-17 15:23:21', '00000000');
INSERT INTO `sys_logininfor` VALUES (328, 'jiazeyong', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 15:23:29', '00000000');
INSERT INTO `sys_logininfor` VALUES (329, 'jiazeyong', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-17 15:38:43', '00000000');
INSERT INTO `sys_logininfor` VALUES (330, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 15:38:58', '00000000');
INSERT INTO `sys_logininfor` VALUES (331, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-17 15:39:32', '00000000');
INSERT INTO `sys_logininfor` VALUES (332, 'j', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '登录用户：j 不存在', '2021-11-17 15:39:41', '00000000');
INSERT INTO `sys_logininfor` VALUES (333, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码错误', '2021-11-17 15:39:46', '00000000');
INSERT INTO `sys_logininfor` VALUES (334, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 15:39:50', '00000000');
INSERT INTO `sys_logininfor` VALUES (335, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '验证码错误', '2021-11-17 15:53:24', '00000000');
INSERT INTO `sys_logininfor` VALUES (336, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-17 15:53:27', '00000000');
INSERT INTO `sys_logininfor` VALUES (337, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 16:57:17', '00000000');
INSERT INTO `sys_logininfor` VALUES (338, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-17 17:09:37', '00000000');
INSERT INTO `sys_logininfor` VALUES (339, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 17:09:44', '00000000');
INSERT INTO `sys_logininfor` VALUES (340, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-17 17:09:58', '00000000');
INSERT INTO `sys_logininfor` VALUES (341, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 17:10:10', '00000000');
INSERT INTO `sys_logininfor` VALUES (342, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-17 17:11:23', '00000000');
INSERT INTO `sys_logininfor` VALUES (343, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 17:11:30', '00000000');
INSERT INTO `sys_logininfor` VALUES (344, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-17 17:13:41', '00000000');
INSERT INTO `sys_logininfor` VALUES (345, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 17:13:57', '00000000');
INSERT INTO `sys_logininfor` VALUES (346, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-17 17:14:30', '00000000');
INSERT INTO `sys_logininfor` VALUES (347, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 17:14:38', '00000000');
INSERT INTO `sys_logininfor` VALUES (348, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-17 17:15:38', '00000000');
INSERT INTO `sys_logininfor` VALUES (349, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 17:15:45', '00000000');
INSERT INTO `sys_logininfor` VALUES (350, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-17 17:16:10', '00000000');
INSERT INTO `sys_logininfor` VALUES (351, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-17 17:16:17', '00000000');
INSERT INTO `sys_logininfor` VALUES (352, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-18 08:53:20', '00000000');
INSERT INTO `sys_logininfor` VALUES (353, 'jzy', '192.168.2.23', '内网IP', 'Firefox 9', 'Windows 10', '1', '验证码错误', '2021-11-18 09:33:44', '00000000');
INSERT INTO `sys_logininfor` VALUES (354, 'jzy', '192.168.2.23', '内网IP', 'Firefox 9', 'Windows 10', '1', '验证码错误', '2021-11-18 09:33:52', '00000000');
INSERT INTO `sys_logininfor` VALUES (355, 'jzy', '192.168.2.23', '内网IP', 'Firefox 9', 'Windows 10', '0', '登录成功', '2021-11-18 09:34:03', '00000000');
INSERT INTO `sys_logininfor` VALUES (356, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '验证码已失效', '2021-11-18 09:56:52', '00000000');
INSERT INTO `sys_logininfor` VALUES (357, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-18 09:57:07', '00000000');
INSERT INTO `sys_logininfor` VALUES (358, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码错误', '2021-11-18 14:09:03', '00000000');
INSERT INTO `sys_logininfor` VALUES (359, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-18 14:09:07', '00000000');
INSERT INTO `sys_logininfor` VALUES (360, 'admin', '192.168.2.23', '内网IP', 'Firefox 9', 'Windows 10', '1', '登录用户：admin 不存在', '2021-11-18 14:11:09', '00000000');
INSERT INTO `sys_logininfor` VALUES (361, 'jzy', '192.168.2.23', '内网IP', 'Firefox 9', 'Windows 10', '1', '验证码错误', '2021-11-18 14:11:17', '00000000');
INSERT INTO `sys_logininfor` VALUES (362, 'jzy', '192.168.2.23', '内网IP', 'Firefox 9', 'Windows 10', '0', '登录成功', '2021-11-18 14:11:24', '00000000');
INSERT INTO `sys_logininfor` VALUES (363, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-18 15:22:02', '00000000');
INSERT INTO `sys_logininfor` VALUES (364, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-18 16:00:57', '00000000');
INSERT INTO `sys_logininfor` VALUES (365, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-18 16:39:16', '00000000');
INSERT INTO `sys_logininfor` VALUES (366, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-18 16:51:50', '00000000');
INSERT INTO `sys_logininfor` VALUES (367, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-18 16:51:59', '00000000');
INSERT INTO `sys_logininfor` VALUES (368, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码错误', '2021-11-19 08:50:45', '00000000');
INSERT INTO `sys_logininfor` VALUES (369, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-19 08:50:48', '00000000');
INSERT INTO `sys_logininfor` VALUES (370, 'jzy', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '1', '登录用户：jzy 不存在', '2021-11-19 09:47:26', '00000000');
INSERT INTO `sys_logininfor` VALUES (371, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-19 09:47:43', '00000000');
INSERT INTO `sys_logininfor` VALUES (372, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-19 09:59:36', '00000000');
INSERT INTO `sys_logininfor` VALUES (373, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-19 10:05:51', '00000000');
INSERT INTO `sys_logininfor` VALUES (374, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-19 10:05:59', '00000000');
INSERT INTO `sys_logininfor` VALUES (375, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-19 10:09:10', '00000000');
INSERT INTO `sys_logininfor` VALUES (376, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-19 10:09:17', '00000000');
INSERT INTO `sys_logininfor` VALUES (377, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-19 10:10:35', '00000000');
INSERT INTO `sys_logininfor` VALUES (378, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-19 10:10:47', '00000000');
INSERT INTO `sys_logininfor` VALUES (379, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-11-19 10:13:55', '00000000');
INSERT INTO `sys_logininfor` VALUES (380, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-19 10:14:05', '00000000');
INSERT INTO `sys_logininfor` VALUES (381, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '登录用户：jzy 不存在', '2021-11-19 14:40:07', '00000000');
INSERT INTO `sys_logininfor` VALUES (382, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码错误', '2021-11-19 14:40:15', '00000000');
INSERT INTO `sys_logininfor` VALUES (383, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-19 14:40:21', '00000000');
INSERT INTO `sys_logininfor` VALUES (384, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-19 14:47:02', '00000000');
INSERT INTO `sys_logininfor` VALUES (385, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-19 15:58:24', '00000000');
INSERT INTO `sys_logininfor` VALUES (386, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码错误', '2021-11-19 16:28:59', '00000000');
INSERT INTO `sys_logininfor` VALUES (387, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-19 16:29:02', '00000000');
INSERT INTO `sys_logininfor` VALUES (388, 'admin', '192.168.2.16', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-19 17:33:27', '00000000');
INSERT INTO `sys_logininfor` VALUES (389, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-19 17:48:58', '00000000');
INSERT INTO `sys_logininfor` VALUES (390, 'jzy', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-19 17:52:02', '00000000');
INSERT INTO `sys_logininfor` VALUES (391, 'admin', '127.0.0.1, 183.185.21.212', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-20 16:31:52', '00000000');
INSERT INTO `sys_logininfor` VALUES (392, 'admin', '183.185.21.212', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-20 16:40:20', '00000000');
INSERT INTO `sys_logininfor` VALUES (393, 'admin', '183.185.21.212', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-20 16:43:59', '00000000');
INSERT INTO `sys_logininfor` VALUES (394, 'lizong', '183.185.21.212', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-20 16:44:08', '00000000');
INSERT INTO `sys_logininfor` VALUES (395, 'admin', '218.26.55.126', 'XX XX', 'Firefox 9', 'Windows 10', '1', '验证码错误', '2021-11-20 17:15:56', '00000000');
INSERT INTO `sys_logininfor` VALUES (396, 'admin', '218.26.55.126', 'XX XX', 'Firefox 9', 'Windows 10', '1', '登录用户：admin 不存在', '2021-11-20 17:16:01', '00000000');
INSERT INTO `sys_logininfor` VALUES (397, 'admin', '218.26.55.126', 'XX XX', 'Firefox 9', 'Windows 10', '0', '登录成功', '2021-11-20 17:16:31', '00000000');
INSERT INTO `sys_logininfor` VALUES (398, 'admin', '218.26.55.126', 'XX XX', 'Firefox 9', 'Windows 10', '0', '退出成功', '2021-11-20 17:17:23', '00000000');
INSERT INTO `sys_logininfor` VALUES (399, 'admin', '218.26.55.126', 'XX XX', 'Firefox 9', 'Windows 10', '1', '登录用户：admin 不存在', '2021-11-20 17:17:37', '00000000');
INSERT INTO `sys_logininfor` VALUES (400, 'admin', '218.26.55.126', 'XX XX', 'Firefox 9', 'Windows 10', '1', '验证码错误', '2021-11-20 17:17:59', '00000000');
INSERT INTO `sys_logininfor` VALUES (401, 'admin', '218.26.55.126', 'XX XX', 'Firefox 9', 'Windows 10', '1', '登录用户：admin 不存在', '2021-11-20 17:18:04', '00000000');
INSERT INTO `sys_logininfor` VALUES (402, 'lizong', '218.26.55.126', 'XX XX', 'Firefox 9', 'Windows 10', '1', '验证码错误', '2021-11-20 17:19:06', '00000000');
INSERT INTO `sys_logininfor` VALUES (403, 'lizong', '218.26.55.126', 'XX XX', 'Firefox 9', 'Windows 10', '0', '登录成功', '2021-11-20 17:19:11', '00000000');
INSERT INTO `sys_logininfor` VALUES (404, 'admin', '183.185.21.212', 'XX XX', 'Chrome 9', 'Mac OS X', '1', '验证码已失效', '2021-11-20 17:20:05', '00000000');
INSERT INTO `sys_logininfor` VALUES (405, 'admin', '183.185.21.212', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-20 17:20:08', '00000000');
INSERT INTO `sys_logininfor` VALUES (406, 'admin', '183.185.21.212', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-20 17:25:39', '00000000');
INSERT INTO `sys_logininfor` VALUES (407, 'admin', '183.185.21.212', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-20 17:25:46', '00000000');
INSERT INTO `sys_logininfor` VALUES (408, 'admin', '127.0.0.1, 183.185.21.212', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-20 17:28:04', '00000000');
INSERT INTO `sys_logininfor` VALUES (409, 'admin', '183.185.21.212', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-20 17:31:06', '00000000');
INSERT INTO `sys_logininfor` VALUES (410, 'lizong', '183.185.21.212', 'XX XX', 'Chrome 9', 'Mac OS X', '1', '验证码错误', '2021-11-20 17:31:37', '00000000');
INSERT INTO `sys_logininfor` VALUES (411, 'lizong', '183.185.21.212', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-20 17:31:39', '00000000');
INSERT INTO `sys_logininfor` VALUES (412, 'lizong', '127.0.0.1, 171.117.9.27', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-22 08:46:38', '00000000');
INSERT INTO `sys_logininfor` VALUES (413, 'lizong', '171.117.9.27', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-22 09:05:55', '00000000');
INSERT INTO `sys_logininfor` VALUES (414, 'lizong', '127.0.0.1, 171.117.9.27', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-22 10:00:04', '00000000');
INSERT INTO `sys_logininfor` VALUES (415, 'lizong', '171.117.9.27', 'XX XX', 'Chrome 9', 'Mac OS X', '1', '登录用户：lizong 不存在', '2021-11-22 14:51:37', '00000000');
INSERT INTO `sys_logininfor` VALUES (416, 'lizong', '171.117.9.27', 'XX XX', 'Chrome 9', 'Mac OS X', '1', '登录用户：lizong 不存在', '2021-11-22 14:51:40', '00000000');
INSERT INTO `sys_logininfor` VALUES (417, 'lizong', '171.117.9.27', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-22 14:51:46', '00000000');
INSERT INTO `sys_logininfor` VALUES (418, 'lizong', '117.40.212.185', 'XX XX', 'Firefox 9', 'Windows 10', '0', '登录成功', '2021-11-23 17:01:29', '00000000');
INSERT INTO `sys_logininfor` VALUES (419, 'lizong', '117.40.212.185', 'XX XX', 'Firefox 9', 'Windows 10', '0', '退出成功', '2021-11-23 17:15:56', '00000000');
INSERT INTO `sys_logininfor` VALUES (420, 'lizong', '171.117.9.27', 'XX XX', 'Chrome 9', 'Mac OS X', '1', '验证码已失效', '2021-11-23 17:54:22', '00000000');
INSERT INTO `sys_logininfor` VALUES (421, 'lizong', '171.117.9.27', 'XX XX', 'Chrome 9', 'Mac OS X', '1', '登录用户：lizong 不存在', '2021-11-23 17:54:24', '00000000');
INSERT INTO `sys_logininfor` VALUES (422, 'lizong', '171.117.9.27', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-23 17:54:29', '00000000');
INSERT INTO `sys_logininfor` VALUES (423, 'lizong', '171.117.9.27', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-23 17:54:41', '00000000');
INSERT INTO `sys_logininfor` VALUES (424, 'lizong', '171.117.9.27', 'XX XX', 'Chrome 9', 'Mac OS X', '1', '验证码错误', '2021-11-23 17:55:01', '00000000');
INSERT INTO `sys_logininfor` VALUES (425, 'lizong', '171.117.9.27', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-23 17:55:04', '00000000');
INSERT INTO `sys_logininfor` VALUES (426, 'lizong', '127.0.0.1, 171.117.9.27', '内网IP', 'Chrome 9', 'Windows 10', '1', '验证码已失效', '2021-11-23 17:56:01', '00000000');
INSERT INTO `sys_logininfor` VALUES (427, 'lizong', '127.0.0.1, 171.117.9.27', '内网IP', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-23 17:56:05', '00000000');
INSERT INTO `sys_logininfor` VALUES (428, 'lizong', '111.73.134.199', 'XX XX', 'Firefox 9', 'Windows 10', '0', '登录成功', '2021-11-23 22:42:03', '00000000');
INSERT INTO `sys_logininfor` VALUES (429, 'lizong', '111.73.134.199', 'XX XX', 'Firefox 9', 'Windows 10', '0', '退出成功', '2021-11-23 22:42:28', '00000000');
INSERT INTO `sys_logininfor` VALUES (430, 'lizong', '111.73.134.199', 'XX XX', 'Firefox 9', 'Windows 10', '0', '登录成功', '2021-11-23 22:42:38', '00000000');
INSERT INTO `sys_logininfor` VALUES (431, 'wangzong', '171.117.9.27', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-24 08:42:00', '00000000');
INSERT INTO `sys_logininfor` VALUES (432, 'wangzong', '183.191.123.59', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-26 11:34:08', '00000000');
INSERT INTO `sys_logininfor` VALUES (433, 'lizong', '218.26.34.87', 'XX XX', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-11-29 09:06:42', '00000000');
INSERT INTO `sys_logininfor` VALUES (434, 'admin', '218.26.34.122', 'XX XX', 'Chrome 9', 'Windows 7', '1', '验证码错误', '2021-11-29 10:18:14', '00000000');
INSERT INTO `sys_logininfor` VALUES (435, 'admin', '218.26.34.122', 'XX XX', 'Chrome 9', 'Windows 7', '1', '登录用户：admin 不存在', '2021-11-29 10:18:19', '00000000');
INSERT INTO `sys_logininfor` VALUES (436, 'lizong', '218.26.34.122', 'XX XX', 'Chrome 9', 'Windows 7', '1', '用户不存在/密码错误', '2021-11-29 10:18:38', '00000000');
INSERT INTO `sys_logininfor` VALUES (437, 'lizong', '218.26.34.122', 'XX XX', 'Chrome 9', 'Windows 7', '1', '登录用户：lizong 不存在', '2021-11-29 10:18:45', '00000000');
INSERT INTO `sys_logininfor` VALUES (438, 'admin', '218.26.34.122', 'XX XX', 'Chrome 9', 'Windows 7', '0', '登录成功', '2021-11-29 10:19:00', '00000000');
INSERT INTO `sys_logininfor` VALUES (439, 'wangzong', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 10:32:04', '00000000');
INSERT INTO `sys_logininfor` VALUES (440, 'admin', '218.26.34.122', 'XX XX', 'Chrome 9', 'Windows 7', '0', '退出成功', '2021-11-29 10:32:56', '00000000');
INSERT INTO `sys_logininfor` VALUES (441, 'admin', '218.26.34.122', 'XX XX', 'Chrome 9', 'Windows 7', '1', '登录用户：admin 不存在', '2021-11-29 10:33:04', '00000000');
INSERT INTO `sys_logininfor` VALUES (442, 'admin', '218.26.34.122', 'XX XX', 'Chrome 9', 'Windows 7', '1', '登录用户：admin 不存在', '2021-11-29 10:33:23', '00000000');
INSERT INTO `sys_logininfor` VALUES (443, 'lizong', '218.26.34.122', 'XX XX', 'Chrome 9', 'Windows 7', '1', '验证码错误', '2021-11-29 10:33:47', '00000000');
INSERT INTO `sys_logininfor` VALUES (444, 'lizong', '218.26.34.122', 'XX XX', 'Chrome 9', 'Windows 7', '0', '登录成功', '2021-11-29 10:33:52', '00000000');
INSERT INTO `sys_logininfor` VALUES (445, 'lizong', '218.26.34.122', 'XX XX', 'Chrome 9', 'Windows 7', '0', '登录成功', '2021-11-29 11:06:41', '00000000');
INSERT INTO `sys_logininfor` VALUES (446, 'lizong', '183.191.123.59', 'XX XX', 'Firefox 9', 'Windows 10', '1', '登录用户：lizong 不存在', '2021-11-29 13:14:56', '00000000');
INSERT INTO `sys_logininfor` VALUES (447, 'lizong', '183.191.123.59', 'XX XX', 'Firefox 9', 'Windows 10', '0', '登录成功', '2021-11-29 13:15:05', '00000000');
INSERT INTO `sys_logininfor` VALUES (448, 'lizong', '183.191.123.59', 'XX XX', 'Firefox 9', 'Windows 10', '0', '退出成功', '2021-11-29 13:20:02', '00000000');
INSERT INTO `sys_logininfor` VALUES (449, 'admin', '183.191.123.59', 'XX XX', 'Firefox 9', 'Windows 10', '0', '登录成功', '2021-11-29 13:21:17', '00000000');
INSERT INTO `sys_logininfor` VALUES (450, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 13:27:28', '00000000');
INSERT INTO `sys_logininfor` VALUES (451, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-29 13:32:38', '00000000');
INSERT INTO `sys_logininfor` VALUES (452, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 13:32:42', '00000000');
INSERT INTO `sys_logininfor` VALUES (453, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-29 13:33:30', '00000000');
INSERT INTO `sys_logininfor` VALUES (454, 'lizong', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 13:33:40', '00000000');
INSERT INTO `sys_logininfor` VALUES (455, 'lizong', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-29 13:34:29', '00000000');
INSERT INTO `sys_logininfor` VALUES (456, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 13:34:39', '00000000');
INSERT INTO `sys_logininfor` VALUES (457, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-29 13:35:32', '00000000');
INSERT INTO `sys_logininfor` VALUES (458, 'test', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 13:35:44', '00000000');
INSERT INTO `sys_logininfor` VALUES (459, 'test', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-29 13:36:12', '00000000');
INSERT INTO `sys_logininfor` VALUES (460, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 13:36:16', '00000000');
INSERT INTO `sys_logininfor` VALUES (461, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-29 14:02:38', '00000000');
INSERT INTO `sys_logininfor` VALUES (462, 'test', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '1', '登录用户：test 不存在', '2021-11-29 14:03:05', '00000000');
INSERT INTO `sys_logininfor` VALUES (463, 'test', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '1', '登录用户：test 不存在', '2021-11-29 14:03:17', '00000000');
INSERT INTO `sys_logininfor` VALUES (464, 'test', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '1', '登录用户：test 不存在', '2021-11-29 14:03:20', '00000000');
INSERT INTO `sys_logininfor` VALUES (465, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 14:03:30', '00000000');
INSERT INTO `sys_logininfor` VALUES (466, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 14:11:56', '00000000');
INSERT INTO `sys_logininfor` VALUES (467, 'admin', '218.26.34.112', 'XX XX', 'Chrome 8', 'Windows 7', '1', '用户不存在/密码错误', '2021-11-29 14:22:06', '00000000');
INSERT INTO `sys_logininfor` VALUES (468, 'admin', '218.26.34.112', 'XX XX', 'Chrome 8', 'Windows 7', '1', '验证码错误', '2021-11-29 14:22:13', '00000000');
INSERT INTO `sys_logininfor` VALUES (469, 'admin', '218.26.34.112', 'XX XX', 'Chrome 8', 'Windows 7', '1', '登录用户：admin 不存在', '2021-11-29 14:22:19', '00000000');
INSERT INTO `sys_logininfor` VALUES (470, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-29 14:22:19', '00000000');
INSERT INTO `sys_logininfor` VALUES (471, 'lizong', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 14:22:29', '00000000');
INSERT INTO `sys_logininfor` VALUES (472, 'lizong', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-29 14:22:50', '00000000');
INSERT INTO `sys_logininfor` VALUES (473, 'admin', '218.26.34.112', 'XX XX', 'Chrome 8', 'Windows 7', '1', '用户不存在/密码错误', '2021-11-29 14:22:55', '00000000');
INSERT INTO `sys_logininfor` VALUES (474, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 14:23:06', '00000000');
INSERT INTO `sys_logininfor` VALUES (475, 'lizong', '218.26.34.112', 'XX XX', 'Chrome 8', 'Windows 7', '1', '登录用户：lizong 不存在', '2021-11-29 14:24:27', '00000000');
INSERT INTO `sys_logininfor` VALUES (476, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-29 14:24:34', '00000000');
INSERT INTO `sys_logininfor` VALUES (477, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 14:24:38', '00000000');
INSERT INTO `sys_logininfor` VALUES (478, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-29 14:25:06', '00000000');
INSERT INTO `sys_logininfor` VALUES (479, 'lizong', '218.26.34.112', 'XX XX', 'Chrome 8', 'Windows 7', '1', '登录用户：lizong 不存在', '2021-11-29 14:25:14', '00000000');
INSERT INTO `sys_logininfor` VALUES (480, 'lizong', '218.26.34.112', 'XX XX', 'Chrome 8', 'Windows 7', '1', '验证码错误', '2021-11-29 14:25:19', '00000000');
INSERT INTO `sys_logininfor` VALUES (481, 'lizong', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 14:25:19', '00000000');
INSERT INTO `sys_logininfor` VALUES (482, 'lizong', '218.26.34.112', 'XX XX', 'Chrome 8', 'Windows 7', '0', '登录成功', '2021-11-29 14:25:29', '00000000');
INSERT INTO `sys_logininfor` VALUES (483, 'lizong', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-29 14:26:23', '00000000');
INSERT INTO `sys_logininfor` VALUES (484, 'lizong', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 14:26:28', '00000000');
INSERT INTO `sys_logininfor` VALUES (485, 'lizong', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-29 14:27:04', '00000000');
INSERT INTO `sys_logininfor` VALUES (486, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 14:27:39', '00000000');
INSERT INTO `sys_logininfor` VALUES (487, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-29 14:28:04', '00000000');
INSERT INTO `sys_logininfor` VALUES (488, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 14:28:08', '00000000');
INSERT INTO `sys_logininfor` VALUES (489, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-29 14:28:21', '00000000');
INSERT INTO `sys_logininfor` VALUES (490, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-29 14:28:35', '00000000');
INSERT INTO `sys_logininfor` VALUES (491, 'lizong', '127.0.0.1', '内网IP', 'Chrome 9', 'Mac OS X', '1', '用户不存在/密码错误', '2021-11-29 14:28:49', '00000000');
INSERT INTO `sys_logininfor` VALUES (492, 'lizong', '127.0.0.1', '内网IP', 'Chrome 9', 'Mac OS X', '1', '验证码错误', '2021-11-29 14:29:18', '00000000');
INSERT INTO `sys_logininfor` VALUES (493, 'lizong', '127.0.0.1', '内网IP', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 14:29:21', '00000000');
INSERT INTO `sys_logininfor` VALUES (494, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 14:32:35', '00000000');
INSERT INTO `sys_logininfor` VALUES (495, 'admin', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '退出成功', '2021-11-29 14:32:49', '00000000');
INSERT INTO `sys_logininfor` VALUES (496, 'lizong', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 14:33:04', '00000000');
INSERT INTO `sys_logininfor` VALUES (497, 'lizong', '218.26.34.112', 'XX XX', 'Chrome 8', 'Windows 7', '0', '退出成功', '2021-11-29 14:41:48', '00000000');
INSERT INTO `sys_logininfor` VALUES (498, 'lizong', '183.191.125.119', 'XX XX', 'Chrome 9', 'Mac OS X', '0', '登录成功', '2021-11-29 15:27:50', '00000000');
INSERT INTO `sys_logininfor` VALUES (499, 'admin', '218.26.34.99', 'XX XX', 'Chrome 8', 'Windows 7', '0', '登录成功', '2021-11-29 16:29:59', '00000000');
INSERT INTO `sys_logininfor` VALUES (500, 'admin', '124.165.212.107', 'XX XX', 'Chrome 8', 'Windows 7', '0', '登录成功', '2021-11-30 11:18:42', '00000000');
INSERT INTO `sys_logininfor` VALUES (501, 'admin', '124.165.212.107', 'XX XX', 'Chrome 8', 'Windows 7', '0', '退出成功', '2021-11-30 11:20:50', '00000000');
INSERT INTO `sys_logininfor` VALUES (502, 'lizong', '124.165.212.107', 'XX XX', 'Chrome 8', 'Windows 7', '0', '登录成功', '2021-11-30 11:21:13', '00000000');
INSERT INTO `sys_logininfor` VALUES (503, 'admin', '218.26.34.121', 'XX XX', 'Chrome 8', 'Windows 7', '1', '验证码错误', '2021-12-08 16:18:27', '00000000');
INSERT INTO `sys_logininfor` VALUES (504, 'admin', '218.26.34.121', 'XX XX', 'Chrome 8', 'Windows 7', '0', '登录成功', '2021-12-08 16:18:32', '00000000');
INSERT INTO `sys_logininfor` VALUES (505, 'admin', '218.26.34.121', 'XX XX', 'Chrome 8', 'Windows 7', '0', '退出成功', '2021-12-08 16:19:19', '00000000');
INSERT INTO `sys_logininfor` VALUES (506, 'lizong', '218.26.34.121', 'XX XX', 'Chrome 8', 'Windows 7', '0', '登录成功', '2021-12-08 16:20:08', '00000000');
INSERT INTO `sys_logininfor` VALUES (507, 'lizong', '218.26.34.121', 'XX XX', 'Chrome 8', 'Windows 7', '0', '退出成功', '2021-12-08 16:20:25', '00000000');
INSERT INTO `sys_logininfor` VALUES (508, 'lizong', '218.26.34.87', 'XX XX', 'Chrome 9', 'Windows 10', '1', '验证码已失效', '2021-12-09 09:06:28', '00000000');
INSERT INTO `sys_logininfor` VALUES (509, 'lizong', '218.26.34.87', 'XX XX', 'Chrome 9', 'Windows 10', '1', '登录用户：lizong 不存在', '2021-12-09 09:06:33', '00000000');
INSERT INTO `sys_logininfor` VALUES (510, 'lizong', '218.26.34.87', 'XX XX', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-12-09 09:06:43', '00000000');
INSERT INTO `sys_logininfor` VALUES (511, 'admin', '218.26.34.87', 'XX XX', 'Chrome 9', 'Windows 10', '1', '用户不存在/密码错误', '2021-12-10 15:18:20', '00000000');
INSERT INTO `sys_logininfor` VALUES (512, 'admin', '218.26.34.87', 'XX XX', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-12-10 15:18:55', '00000000');
INSERT INTO `sys_logininfor` VALUES (513, 'admin', '218.26.34.87', 'XX XX', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-12-10 15:20:23', '00000000');
INSERT INTO `sys_logininfor` VALUES (514, 'lizong', '218.26.34.87', 'XX XX', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-12-10 15:20:32', '00000000');
INSERT INTO `sys_logininfor` VALUES (515, 'lizong', '221.204.147.172', 'XX XX', 'Chrome 9', 'Mac OS X', '1', '登录用户：lizong 不存在', '2021-12-11 11:05:14', '00000000');
INSERT INTO `sys_logininfor` VALUES (516, 'lizong', '183.200.20.48', 'XX XX', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-12-12 19:00:29', '00000000');
INSERT INTO `sys_logininfor` VALUES (517, 'lizong', '183.200.20.48', 'XX XX', 'Chrome 9', 'Windows 10', '0', '退出成功', '2021-12-12 19:49:39', '00000000');
INSERT INTO `sys_logininfor` VALUES (518, 'lizong', '183.200.20.48', 'XX XX', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-12-12 19:49:44', '00000000');
INSERT INTO `sys_logininfor` VALUES (519, 'lizong', '218.26.34.87', 'XX XX', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-12-13 08:13:16', '00000000');
INSERT INTO `sys_logininfor` VALUES (520, 'lizong', '218.26.34.87', 'XX XX', 'Chrome 9', 'Windows 10', '0', '登录成功', '2021-12-13 16:03:48', '00000000');
COMMIT;

-- ----------------------------
-- Table structure for sys_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_menu`;
CREATE TABLE `sys_menu` (
  `menu_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '菜单ID',
  `menu_name` varchar(50) NOT NULL COMMENT '菜单名称',
  `parent_id` bigint(20) DEFAULT '0' COMMENT '父菜单ID',
  `order_num` int(4) DEFAULT '0' COMMENT '显示顺序',
  `path` varchar(200) DEFAULT '' COMMENT '路由地址',
  `component` varchar(255) DEFAULT NULL COMMENT '组件路径',
  `query` varchar(255) DEFAULT NULL COMMENT '路由参数',
  `is_frame` int(1) DEFAULT '1' COMMENT '是否为外链（0是 1否）',
  `is_cache` int(1) DEFAULT '0' COMMENT '是否缓存（0缓存 1不缓存）',
  `menu_type` char(1) DEFAULT '' COMMENT '菜单类型（M目录 C菜单 F按钮）',
  `visible` char(1) DEFAULT '0' COMMENT '菜单状态（0显示 1隐藏）',
  `status` char(1) DEFAULT '0' COMMENT '菜单状态（0正常 1停用）',
  `perms` varchar(100) DEFAULT NULL COMMENT '权限标识',
  `icon` varchar(100) DEFAULT '#' COMMENT '菜单图标',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) DEFAULT '' COMMENT '备注',
  `tenant_id` varchar(8) NOT NULL DEFAULT '00000000',
  PRIMARY KEY (`menu_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2048 DEFAULT CHARSET=utf8mb4 COMMENT='菜单权限表';

-- ----------------------------
-- Records of sys_menu
-- ----------------------------
BEGIN;
INSERT INTO `sys_menu` VALUES (1, '系统管理', 0, 1, 'system', NULL, '', 1, 0, 'M', '0', '0', '', 'system', 'admin', '2021-09-21 17:00:40', '', NULL, '系统管理目录', '00000000');
INSERT INTO `sys_menu` VALUES (2, '系统监控', 0, 2, 'monitor', NULL, '', 1, 0, 'M', '1', '0', '', 'monitor', 'admin', '2021-09-21 17:00:41', 'admin', '2021-11-20 17:20:29', '系统监控目录', '00000000');
INSERT INTO `sys_menu` VALUES (3, '系统工具', 0, 3, 'tool', NULL, '', 1, 0, 'M', '1', '0', '', 'tool', 'admin', '2021-09-21 17:00:41', 'admin', '2021-11-20 17:20:22', '系统工具目录', '00000000');
INSERT INTO `sys_menu` VALUES (100, '用户管理', 1, 1, 'user', 'system/user/index', '', 1, 0, 'C', '0', '0', 'system:user:list', 'user', 'admin', '2021-09-21 17:00:42', '', NULL, '用户管理菜单', '00000000');
INSERT INTO `sys_menu` VALUES (101, '角色管理', 1, 2, 'role', 'system/role/index', '', 1, 0, 'C', '0', '0', 'system:role:list', 'peoples', 'admin', '2021-09-21 17:00:42', '', NULL, '角色管理菜单', '00000000');
INSERT INTO `sys_menu` VALUES (102, '菜单管理', 1, 3, 'menu', 'system/menu/index', '', 1, 0, 'C', '0', '0', 'system:menu:list', 'tree-table', 'admin', '2021-09-21 17:00:42', '', NULL, '菜单管理菜单', '00000000');
INSERT INTO `sys_menu` VALUES (103, '锅炉管理', 1, 4, 'dept', 'system/dept/index', '', 1, 0, 'C', '0', '0', 'system:dept:list', 'tree', 'admin', '2021-09-21 17:00:43', 'jiazeyong', '2021-11-17 14:28:55', '部门管理菜单', '00000000');
INSERT INTO `sys_menu` VALUES (104, '岗位管理', 1, 5, 'post', 'system/post/index', '', 1, 0, 'C', '0', '0', 'system:post:list', 'post', 'admin', '2021-09-21 17:00:43', '', NULL, '岗位管理菜单', '00000000');
INSERT INTO `sys_menu` VALUES (105, '字典管理', 1, 6, 'dict', 'system/dict/index', '', 1, 0, 'C', '0', '0', 'system:dict:list', 'dict', 'admin', '2021-09-21 17:00:44', '', NULL, '字典管理菜单', '00000000');
INSERT INTO `sys_menu` VALUES (106, '参数设置', 1, 7, 'config', 'system/config/index', '', 1, 0, 'C', '0', '0', 'system:config:list', 'edit', 'admin', '2021-09-21 17:00:44', '', NULL, '参数设置菜单', '00000000');
INSERT INTO `sys_menu` VALUES (107, '通知公告', 1, 8, 'notice', 'system/notice/index', '', 1, 0, 'C', '0', '0', 'system:notice:list', 'message', 'admin', '2021-09-21 17:00:44', '', NULL, '通知公告菜单', '00000000');
INSERT INTO `sys_menu` VALUES (108, '日志管理', 1, 9, 'log', '', '', 1, 0, 'M', '0', '0', '', 'log', 'admin', '2021-09-21 17:00:45', '', NULL, '日志管理菜单', '00000000');
INSERT INTO `sys_menu` VALUES (109, '在线用户', 2, 1, 'online', 'monitor/online/index', '', 1, 0, 'C', '0', '0', 'monitor:online:list', 'online', 'admin', '2021-09-21 17:00:45', '', NULL, '在线用户菜单', '00000000');
INSERT INTO `sys_menu` VALUES (110, '定时任务', 2, 2, 'job', 'monitor/job/index', '', 1, 0, 'C', '0', '0', 'monitor:job:list', 'job', 'admin', '2021-09-21 17:00:45', '', NULL, '定时任务菜单', '00000000');
INSERT INTO `sys_menu` VALUES (111, '数据监控', 2, 3, 'druid', 'monitor/druid/index', '', 1, 0, 'C', '0', '0', 'monitor:druid:list', 'druid', 'admin', '2021-09-21 17:00:46', '', NULL, '数据监控菜单', '00000000');
INSERT INTO `sys_menu` VALUES (112, '服务监控', 2, 4, 'server', 'monitor/server/index', '', 1, 0, 'C', '0', '0', 'monitor:server:list', 'server', 'admin', '2021-09-21 17:00:46', '', NULL, '服务监控菜单', '00000000');
INSERT INTO `sys_menu` VALUES (113, '缓存监控', 2, 5, 'cache', 'monitor/cache/index', '', 1, 0, 'C', '0', '0', 'monitor:cache:list', 'redis', 'admin', '2021-09-21 17:00:47', '', NULL, '缓存监控菜单', '00000000');
INSERT INTO `sys_menu` VALUES (114, '表单构建', 3, 1, 'build', 'tool/build/index', '', 1, 0, 'C', '0', '0', 'tool:build:list', 'build', 'admin', '2021-09-21 17:00:47', '', NULL, '表单构建菜单', '00000000');
INSERT INTO `sys_menu` VALUES (115, '代码生成', 3, 2, 'gen', 'tool/gen/index', '', 1, 0, 'C', '0', '0', 'tool:gen:list', 'code', 'admin', '2021-09-21 17:00:47', '', NULL, '代码生成菜单', '00000000');
INSERT INTO `sys_menu` VALUES (116, '系统接口', 3, 3, 'swagger', 'tool/swagger/index', '', 1, 0, 'C', '0', '0', 'tool:swagger:list', 'swagger', 'admin', '2021-09-21 17:00:48', '', NULL, '系统接口菜单', '00000000');
INSERT INTO `sys_menu` VALUES (500, '操作日志', 108, 1, 'operlog', 'monitor/operlog/index', '', 1, 0, 'C', '0', '0', 'monitor:operlog:list', 'form', 'admin', '2021-09-21 17:00:48', '', NULL, '操作日志菜单', '00000000');
INSERT INTO `sys_menu` VALUES (501, '登录日志', 108, 2, 'logininfor', 'monitor/logininfor/index', '', 1, 0, 'C', '0', '0', 'monitor:logininfor:list', 'logininfor', 'admin', '2021-09-21 17:00:48', '', NULL, '登录日志菜单', '00000000');
INSERT INTO `sys_menu` VALUES (1001, '用户查询', 100, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:user:query', '#', 'admin', '2021-09-21 17:00:49', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1002, '用户新增', 100, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:user:add', '#', 'admin', '2021-09-21 17:00:49', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1003, '用户修改', 100, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:user:edit', '#', 'admin', '2021-09-21 17:00:50', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1004, '用户删除', 100, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:user:remove', '#', 'admin', '2021-09-21 17:00:50', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1005, '用户导出', 100, 5, '', '', '', 1, 0, 'F', '0', '0', 'system:user:export', '#', 'admin', '2021-09-21 17:00:50', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1006, '用户导入', 100, 6, '', '', '', 1, 0, 'F', '0', '0', 'system:user:import', '#', 'admin', '2021-09-21 17:00:51', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1007, '重置密码', 100, 7, '', '', '', 1, 0, 'F', '0', '0', 'system:user:resetPwd', '#', 'admin', '2021-09-21 17:00:51', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1008, '角色查询', 101, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:role:query', '#', 'admin', '2021-09-21 17:00:51', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1009, '角色新增', 101, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:role:add', '#', 'admin', '2021-09-21 17:00:52', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1010, '角色修改', 101, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:role:edit', '#', 'admin', '2021-09-21 17:00:52', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1011, '角色删除', 101, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:role:remove', '#', 'admin', '2021-09-21 17:00:52', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1012, '角色导出', 101, 5, '', '', '', 1, 0, 'F', '0', '0', 'system:role:export', '#', 'admin', '2021-09-21 17:00:53', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1013, '菜单查询', 102, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:query', '#', 'admin', '2021-09-21 17:00:53', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1014, '菜单新增', 102, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:add', '#', 'admin', '2021-09-21 17:00:53', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1015, '菜单修改', 102, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:edit', '#', 'admin', '2021-09-21 17:00:54', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1016, '菜单删除', 102, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:remove', '#', 'admin', '2021-09-21 17:00:54', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1017, '部门查询', 103, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:query', '#', 'admin', '2021-09-21 17:00:55', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1018, '部门新增', 103, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:add', '#', 'admin', '2021-09-21 17:00:55', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1019, '部门修改', 103, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:edit', '#', 'admin', '2021-09-21 17:00:55', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1020, '部门删除', 103, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:remove', '#', 'admin', '2021-09-21 17:00:56', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1021, '岗位查询', 104, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:post:query', '#', 'admin', '2021-09-21 17:00:56', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1022, '岗位新增', 104, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:post:add', '#', 'admin', '2021-09-21 17:00:56', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1023, '岗位修改', 104, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:post:edit', '#', 'admin', '2021-09-21 17:00:57', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1024, '岗位删除', 104, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:post:remove', '#', 'admin', '2021-09-21 17:00:57', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1025, '岗位导出', 104, 5, '', '', '', 1, 0, 'F', '0', '0', 'system:post:export', '#', 'admin', '2021-09-21 17:00:58', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1026, '字典查询', 105, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:query', '#', 'admin', '2021-09-21 17:00:58', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1027, '字典新增', 105, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:add', '#', 'admin', '2021-09-21 17:00:58', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1028, '字典修改', 105, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:edit', '#', 'admin', '2021-09-21 17:00:59', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1029, '字典删除', 105, 4, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:remove', '#', 'admin', '2021-09-21 17:00:59', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1030, '字典导出', 105, 5, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:export', '#', 'admin', '2021-09-21 17:00:59', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1031, '参数查询', 106, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:query', '#', 'admin', '2021-09-21 17:01:00', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1032, '参数新增', 106, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:add', '#', 'admin', '2021-09-21 17:01:00', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1033, '参数修改', 106, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:edit', '#', 'admin', '2021-09-21 17:01:01', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1034, '参数删除', 106, 4, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:remove', '#', 'admin', '2021-09-21 17:01:01', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1035, '参数导出', 106, 5, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:export', '#', 'admin', '2021-09-21 17:01:01', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1036, '公告查询', 107, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:query', '#', 'admin', '2021-09-21 17:01:02', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1037, '公告新增', 107, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:add', '#', 'admin', '2021-09-21 17:01:02', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1038, '公告修改', 107, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:edit', '#', 'admin', '2021-09-21 17:01:02', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1039, '公告删除', 107, 4, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:remove', '#', 'admin', '2021-09-21 17:01:03', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1040, '操作查询', 500, 1, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:operlog:query', '#', 'admin', '2021-09-21 17:01:03', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1041, '操作删除', 500, 2, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:operlog:remove', '#', 'admin', '2021-09-21 17:01:03', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1042, '日志导出', 500, 4, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:operlog:export', '#', 'admin', '2021-09-21 17:01:04', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1043, '登录查询', 501, 1, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:logininfor:query', '#', 'admin', '2021-09-21 17:01:04', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1044, '登录删除', 501, 2, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:logininfor:remove', '#', 'admin', '2021-09-21 17:01:04', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1045, '日志导出', 501, 3, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:logininfor:export', '#', 'admin', '2021-09-21 17:01:05', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1046, '在线查询', 109, 1, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:online:query', '#', 'admin', '2021-09-21 17:01:05', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1047, '批量强退', 109, 2, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:online:batchLogout', '#', 'admin', '2021-09-21 17:01:06', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1048, '单条强退', 109, 3, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:online:forceLogout', '#', 'admin', '2021-09-21 17:01:06', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1049, '任务查询', 110, 1, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:query', '#', 'admin', '2021-09-21 17:01:06', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1050, '任务新增', 110, 2, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:add', '#', 'admin', '2021-09-21 17:01:07', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1051, '任务修改', 110, 3, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:edit', '#', 'admin', '2021-09-21 17:01:07', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1052, '任务删除', 110, 4, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:remove', '#', 'admin', '2021-09-21 17:01:07', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1053, '状态修改', 110, 5, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:changeStatus', '#', 'admin', '2021-09-21 17:01:08', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1054, '任务导出', 110, 7, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:export', '#', 'admin', '2021-09-21 17:01:08', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1055, '生成查询', 115, 1, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:query', '#', 'admin', '2021-09-21 17:01:09', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1056, '生成修改', 115, 2, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:edit', '#', 'admin', '2021-09-21 17:01:09', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1057, '生成删除', 115, 3, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:remove', '#', 'admin', '2021-09-21 17:01:09', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1058, '导入代码', 115, 2, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:import', '#', 'admin', '2021-09-21 17:01:10', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1059, '预览代码', 115, 4, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:preview', '#', 'admin', '2021-09-21 17:01:10', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (1060, '生成代码', 115, 5, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:code', '#', 'admin', '2021-09-21 17:01:10', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (2000, '电厂管理', 1, 0, 'tenant', 'system/tenant/index', NULL, 1, 0, 'C', '0', '0', 'system:tenant:list', 'theme', 'admin', '2021-10-10 16:17:46', 'admin', '2021-11-17 09:54:22', '', '00000000');
INSERT INTO `sys_menu` VALUES (2001, '租户查询', 2000, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:tenant:query', '#', 'admin', '2021-09-21 17:00:51', 'admin', '2021-10-11 22:38:17', '', '00000000');
INSERT INTO `sys_menu` VALUES (2002, '租户新增', 2000, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:tenant:add', '#', 'admin', '2021-09-21 17:00:52', 'admin', '2021-10-11 22:38:21', '', '00000000');
INSERT INTO `sys_menu` VALUES (2003, '租户修改', 2000, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:tenant:edit', '#', 'admin', '2021-09-21 17:00:52', 'admin', '2021-10-11 22:38:26', '', '00000000');
INSERT INTO `sys_menu` VALUES (2004, '租户删除', 2000, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:tenant:remove', '#', 'admin', '2021-09-21 17:00:52', 'admin', '2021-10-11 22:38:32', '', '00000000');
INSERT INTO `sys_menu` VALUES (2005, '租户导出', 2000, 5, '', '', '', 1, 0, 'F', '0', '0', 'system:tenant:export', '#', 'admin', '2021-09-21 17:00:53', 'admin', '2021-10-11 22:38:37', '', '00000000');
INSERT INTO `sys_menu` VALUES (2006, '数据权限', 1, 10, 'datarule', 'system/dataRule/index', NULL, 1, 0, 'C', '0', '0', 'system:dataRule:list', 'validCode', 'admin', '2021-10-20 11:28:20', 'admin', '2021-10-20 11:29:02', '', '00000000');
INSERT INTO `sys_menu` VALUES (2007, '数据权限查询', 2006, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:dataRule:query', '#', 'admin', '2021-09-21 17:00:51', 'admin', '2021-10-11 22:38:17', '', '00000000');
INSERT INTO `sys_menu` VALUES (2008, '数据权限新增', 2006, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:dataRule:add', '#', 'admin', '2021-09-21 17:00:52', 'admin', '2021-10-11 22:38:21', '', '00000000');
INSERT INTO `sys_menu` VALUES (2009, '数据权限修改', 2006, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:dataRule:edit', '#', 'admin', '2021-09-21 17:00:52', 'admin', '2021-10-11 22:38:26', '', '00000000');
INSERT INTO `sys_menu` VALUES (2010, '数据权限删除', 2006, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:dataRule:remove', '#', 'admin', '2021-09-21 17:00:52', 'admin', '2021-10-11 22:38:32', '', '00000000');
INSERT INTO `sys_menu` VALUES (2011, '数据权限导出', 2006, 5, '', '', '', 1, 0, 'F', '0', '0', 'system:dataRule:export', '#', 'admin', '2021-09-21 17:00:53', 'admin', '2021-10-11 22:38:37', '', '00000000');
INSERT INTO `sys_menu` VALUES (2043, '检修管理', 1, 11, 'overhaul', 'system/overhaul/index', NULL, 1, 0, 'C', '0', '0', 'system:overhaul:list', 'druid', 'admin', '2021-11-17 17:05:23', 'admin', '2021-11-17 17:16:07', '', '00000000');
INSERT INTO `sys_menu` VALUES (2044, '检修查询', 2043, 0, '', NULL, NULL, 1, 0, 'F', '0', '0', 'system:overhaul:query', '#', 'admin', '2021-11-17 17:06:54', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (2045, '检修新增', 2043, 1, '', NULL, NULL, 1, 0, 'F', '0', '0', 'system:overhaul:add', '#', 'admin', '2021-11-17 17:07:13', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (2046, '检修修改', 2043, 2, '', NULL, NULL, 1, 0, 'F', '0', '0', 'system:overhaul:edit', '#', 'admin', '2021-11-17 17:07:36', '', NULL, '', '00000000');
INSERT INTO `sys_menu` VALUES (2047, '检修删除', 2043, 3, '', NULL, NULL, 1, 0, 'F', '0', '0', 'system:overhaul:remove', '#', 'admin', '2021-11-17 17:07:55', '', NULL, '', '00000000');
COMMIT;

-- ----------------------------
-- Table structure for sys_notice
-- ----------------------------
DROP TABLE IF EXISTS `sys_notice`;
CREATE TABLE `sys_notice` (
  `notice_id` int(4) NOT NULL AUTO_INCREMENT COMMENT '公告ID',
  `notice_title` varchar(50) NOT NULL COMMENT '公告标题',
  `notice_type` char(1) NOT NULL COMMENT '公告类型（1通知 2公告）',
  `notice_content` longblob COMMENT '公告内容',
  `status` char(1) DEFAULT '0' COMMENT '公告状态（0正常 1关闭）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `tenant_id` varchar(8) NOT NULL DEFAULT '00000000',
  PRIMARY KEY (`notice_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='通知公告表';

-- ----------------------------
-- Table structure for sys_oper_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_oper_log`;
CREATE TABLE `sys_oper_log` (
  `oper_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '日志主键',
  `title` varchar(50) DEFAULT '' COMMENT '模块标题',
  `business_type` int(2) DEFAULT '0' COMMENT '业务类型（0其它 1新增 2修改 3删除）',
  `method` varchar(100) DEFAULT '' COMMENT '方法名称',
  `request_method` varchar(10) DEFAULT '' COMMENT '请求方式',
  `operator_type` int(1) DEFAULT '0' COMMENT '操作类别（0其它 1后台用户 2手机端用户）',
  `oper_name` varchar(50) DEFAULT '' COMMENT '操作人员',
  `dept_name` varchar(50) DEFAULT '' COMMENT '部门名称',
  `oper_url` varchar(255) DEFAULT '' COMMENT '请求URL',
  `oper_ip` varchar(128) DEFAULT '' COMMENT '主机地址',
  `oper_location` varchar(255) DEFAULT '' COMMENT '操作地点',
  `oper_param` varchar(2000) DEFAULT '' COMMENT '请求参数',
  `json_result` varchar(2000) DEFAULT '' COMMENT '返回参数',
  `status` int(1) DEFAULT '0' COMMENT '操作状态（0正常 1异常）',
  `error_msg` varchar(2000) DEFAULT '' COMMENT '错误消息',
  `oper_time` datetime DEFAULT NULL COMMENT '操作时间',
  `tenant_id` varchar(8) NOT NULL DEFAULT '00000000',
  PRIMARY KEY (`oper_id`)
) ENGINE=InnoDB AUTO_INCREMENT=169 DEFAULT CHARSET=utf8mb4 COMMENT='操作日志记录';

-- ----------------------------
-- Records of sys_oper_log
-- ----------------------------
BEGIN;
INSERT INTO `sys_oper_log` VALUES (108, '租户管理', 1, 'com.ruoyi.web.controller.system.SysTenantController.add()', 'POST', 1, 'admin', NULL, '/system/tenant', '183.185.21.212', 'XX XX', '{\"params\":{},\"userName\":\"lizong\",\"userId\":111,\"phone\":\"13011112222\",\"contact\":\"李总\",\"name\":\"演示电厂\",\"tenantId\":\"77864606\",\"id\":10}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 16:43:50', '00000000');
INSERT INTO `sys_oper_log` VALUES (109, '个人信息', 2, 'com.ruoyi.web.controller.system.SysProfileController.updatePwd()', 'PUT', 1, 'lizong', NULL, '/system/user/profile/updatePwd', '183.185.21.212', 'XX XX', '77864606 lizong123', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 16:44:38', '00000000');
INSERT INTO `sys_oper_log` VALUES (110, '锅炉管理', 1, 'com.ruoyi.web.controller.system.SysDeptController.add()', 'POST', 1, 'lizong', NULL, '/system/dept', '183.185.21.212', 'XX XX', '{\"deptName\":\"壹号锅炉\",\"children\":[],\"ancestors\":\"0\",\"params\":{},\"parentId\":0,\"createBy\":\"lizong\",\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 16:44:53', '00000000');
INSERT INTO `sys_oper_log` VALUES (111, '锅炉管理', 1, 'com.ruoyi.web.controller.system.SysDeptController.add()', 'POST', 1, 'lizong', NULL, '/system/dept', '183.185.21.212', 'XX XX', '{\"deptName\":\"层次\",\"children\":[],\"ancestors\":\"0,257\",\"params\":{},\"parentId\":257,\"createBy\":\"lizong\",\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 16:46:39', '00000000');
INSERT INTO `sys_oper_log` VALUES (112, '锅炉管理', 1, 'com.ruoyi.web.controller.system.SysDeptController.add()', 'POST', 1, 'lizong', NULL, '/system/dept', '183.185.21.212', 'XX XX', '{\"deptName\":\"东\",\"children\":[],\"ancestors\":\"0,257,258\",\"params\":{},\"parentId\":258,\"createBy\":\"lizong\",\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 16:46:55', '00000000');
INSERT INTO `sys_oper_log` VALUES (113, '锅炉管理', 1, 'com.ruoyi.web.controller.system.SysDeptController.add()', 'POST', 1, 'lizong', NULL, '/system/dept', '183.185.21.212', 'XX XX', '{\"deptName\":\"南\",\"children\":[],\"ancestors\":\"0,257,258\",\"params\":{},\"parentId\":258,\"createBy\":\"lizong\",\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 16:47:02', '00000000');
INSERT INTO `sys_oper_log` VALUES (114, '锅炉管理', 1, 'com.ruoyi.web.controller.system.SysDeptController.add()', 'POST', 1, 'lizong', NULL, '/system/dept', '183.185.21.212', 'XX XX', '{\"deptName\":\"西\",\"children\":[],\"ancestors\":\"0,257,258\",\"params\":{},\"parentId\":258,\"createBy\":\"lizong\",\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 16:47:06', '00000000');
INSERT INTO `sys_oper_log` VALUES (115, '锅炉管理', 1, 'com.ruoyi.web.controller.system.SysDeptController.add()', 'POST', 1, 'lizong', NULL, '/system/dept', '183.185.21.212', 'XX XX', '{\"deptName\":\"北\",\"children\":[],\"ancestors\":\"0,257,258\",\"params\":{},\"parentId\":258,\"createBy\":\"lizong\",\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 16:47:14', '00000000');
INSERT INTO `sys_oper_log` VALUES (116, '锅炉管理', 1, 'com.ruoyi.web.controller.system.SysDeptController.add()', 'POST', 1, 'lizong', NULL, '/system/dept', '183.185.21.212', 'XX XX', '{\"deptName\":\"壹号点位\",\"children\":[],\"ancestors\":\"0,257,258,259\",\"params\":{},\"parentId\":259,\"createBy\":\"lizong\",\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 16:47:20', '00000000');
INSERT INTO `sys_oper_log` VALUES (117, '锅炉管理', 1, 'com.ruoyi.web.controller.system.SysDeptController.add()', 'POST', 1, 'lizong', NULL, '/system/dept', '183.185.21.212', 'XX XX', '{\"deptName\":\"贰号点位\",\"children\":[],\"ancestors\":\"0,257,258,259\",\"params\":{},\"parentId\":259,\"createBy\":\"lizong\",\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 16:47:35', '00000000');
INSERT INTO `sys_oper_log` VALUES (118, '检修', 1, 'com.ruoyi.web.controller.system.OverhaulController.add()', 'POST', 1, 'lizong', NULL, '/system/overhaul', '183.185.21.212', 'XX XX', '{\"createBy\":\"赵佳鹏\",\"createTime\":1637398067919,\"deptId\":257,\"tenantId\":\"77864606\",\"overhaulTime\":1637251200000,\"params\":{}}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 16:47:47', '00000000');
INSERT INTO `sys_oper_log` VALUES (119, '检修', 1, 'com.ruoyi.web.controller.system.OverhaulController.add()', 'POST', 1, 'lizong', NULL, '/system/overhaul', '183.185.21.212', 'XX XX', '{\"createBy\":\"赵佳鹏\",\"createTime\":1637398074304,\"deptId\":257,\"tenantId\":\"77864606\",\"overhaulTime\":1637337600000,\"params\":{}}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 16:47:54', '00000000');
INSERT INTO `sys_oper_log` VALUES (120, '【请填写功能名称】', 1, 'com.ruoyi.web.controller.system.MarkController.add()', 'POST', 1, 'lizong', NULL, '/system/mark', '183.185.21.212', 'XX XX', '{\"createTime\":1637398560246,\"deptId\":263,\"overhaulId\":2,\"remark\":\"损伤严重\",\"id\":1,\"params\":{}}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 16:56:00', '00000000');
INSERT INTO `sys_oper_log` VALUES (121, '标注修改', 2, 'com.ruoyi.web.controller.system.MarkController.edit()', 'PUT', 1, 'lizong', NULL, '/system/mark', '183.185.21.212', 'XX XX', '{\"remark\":\"损伤太严重\\n2021-11-20\",\"updateTime\":1637399303642,\"id\":1,\"params\":{}}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 17:08:23', '00000000');
INSERT INTO `sys_oper_log` VALUES (122, '菜单管理', 2, 'com.ruoyi.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '183.185.21.212', 'XX XX', '{\"visible\":\"1\",\"query\":\"\",\"icon\":\"tool\",\"orderNum\":\"3\",\"menuName\":\"系统工具\",\"params\":{},\"parentId\":0,\"isCache\":\"0\",\"path\":\"tool\",\"children\":[],\"createTime\":1632214841000,\"updateBy\":\"admin\",\"isFrame\":\"1\",\"tenantId\":\"00000000\",\"menuId\":3,\"menuType\":\"M\",\"perms\":\"\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 17:20:22', '00000000');
INSERT INTO `sys_oper_log` VALUES (123, '菜单管理', 2, 'com.ruoyi.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '183.185.21.212', 'XX XX', '{\"visible\":\"1\",\"query\":\"\",\"icon\":\"monitor\",\"orderNum\":\"2\",\"menuName\":\"系统监控\",\"params\":{},\"parentId\":0,\"isCache\":\"0\",\"path\":\"monitor\",\"children\":[],\"createTime\":1632214841000,\"updateBy\":\"admin\",\"isFrame\":\"1\",\"tenantId\":\"00000000\",\"menuId\":2,\"menuType\":\"M\",\"perms\":\"\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 17:20:29', '00000000');
INSERT INTO `sys_oper_log` VALUES (124, '锅炉管理', 2, 'com.ruoyi.web.controller.system.SysDeptController.edit()', 'PUT', 1, 'admin', NULL, '/system/dept', '183.185.21.212', 'XX XX', '{\"deptName\":\"壹号锅炉\",\"leader\":\"若依\",\"orderNum\":\"0\",\"delFlag\":\"0\",\"children\":[],\"updateBy\":\"admin\",\"id\":100,\"ancestors\":\"0\",\"email\":\"ry@qq.com\",\"deptId\":100,\"params\":{},\"parentId\":0,\"createBy\":\"admin\",\"createTime\":1632214830000,\"phone\":\"15888888888\",\"tenantId\":\"00000000\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 17:21:52', '00000000');
INSERT INTO `sys_oper_log` VALUES (125, '标注新增', 1, 'com.ruoyi.web.controller.system.MarkController.add()', 'POST', 1, 'lizong', NULL, '/system/mark', '218.26.55.126', 'XX XX', '{\"createTime\":1637400778920,\"deptId\":264,\"overhaulId\":2,\"remark\":\"有裂缝\",\"id\":2,\"params\":{}}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 17:32:58', '00000000');
INSERT INTO `sys_oper_log` VALUES (126, '锅炉管理', 2, 'com.ruoyi.web.controller.system.SysDeptController.edit()', 'PUT', 1, 'lizong', NULL, '/system/dept', '218.26.55.126', 'XX XX', '{\"deptName\":\"1号\",\"orderNum\":\"0\",\"delFlag\":\"0\",\"children\":[],\"updateBy\":\"lizong\",\"id\":263,\"ancestors\":\"0,257,258,259\",\"deptId\":263,\"params\":{},\"parentId\":259,\"createBy\":\"lizong\",\"createTime\":1637398040000,\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 17:33:52', '00000000');
INSERT INTO `sys_oper_log` VALUES (127, '锅炉管理', 2, 'com.ruoyi.web.controller.system.SysDeptController.edit()', 'PUT', 1, 'lizong', NULL, '/system/dept', '218.26.55.126', 'XX XX', '{\"deptName\":\"2号\",\"orderNum\":\"0\",\"delFlag\":\"0\",\"children\":[],\"updateBy\":\"lizong\",\"id\":264,\"ancestors\":\"0,257,258,259\",\"deptId\":264,\"params\":{},\"parentId\":259,\"createBy\":\"lizong\",\"createTime\":1637398055000,\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 17:34:17', '00000000');
INSERT INTO `sys_oper_log` VALUES (128, '锅炉管理', 1, 'com.ruoyi.web.controller.system.SysDeptController.add()', 'POST', 1, 'lizong', NULL, '/system/dept', '218.26.55.126', 'XX XX', '{\"deptName\":\"2层\",\"children\":[],\"ancestors\":\"0,257\",\"params\":{},\"parentId\":257,\"createBy\":\"lizong\",\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 17:35:47', '00000000');
INSERT INTO `sys_oper_log` VALUES (129, '锅炉管理', 2, 'com.ruoyi.web.controller.system.SysDeptController.edit()', 'PUT', 1, 'lizong', NULL, '/system/dept', '218.26.55.126', 'XX XX', '{\"deptName\":\"1层\",\"orderNum\":\"0\",\"delFlag\":\"0\",\"children\":[],\"updateBy\":\"lizong\",\"id\":258,\"ancestors\":\"0,257\",\"deptId\":258,\"params\":{},\"parentId\":257,\"createBy\":\"lizong\",\"createTime\":1637397999000,\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-20 17:35:58', '00000000');
INSERT INTO `sys_oper_log` VALUES (130, '检修', 1, 'com.ruoyi.web.controller.system.OverhaulController.add()', 'POST', 1, 'lizong', NULL, '/system/overhaul', '171.117.9.27', 'XX XX', '{\"createBy\":\"测试\",\"createTime\":1637543231761,\"deptId\":257,\"tenantId\":\"77864606\",\"overhaulTime\":1637424000000,\"params\":{}}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-22 09:07:11', '00000000');
INSERT INTO `sys_oper_log` VALUES (131, '检修', 1, 'com.ruoyi.web.controller.system.OverhaulController.add()', 'POST', 1, 'lizong', NULL, '/system/overhaul', '127.0.0.1, 171.117.9.27', '内网IP', '{\"createBy\":\"张三\",\"createTime\":1637546427400,\"deptId\":257,\"tenantId\":\"77864606\",\"overhaulTime\":1635782400000,\"remark\":\"\",\"params\":{}}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-22 10:00:27', '00000000');
INSERT INTO `sys_oper_log` VALUES (132, '检修', 1, 'com.ruoyi.web.controller.system.OverhaulController.add()', 'POST', 1, 'lizong', NULL, '/system/overhaul', '127.0.0.1, 171.117.9.27', '内网IP', '{\"createBy\":\"李丹丹\",\"createTime\":1637546595249,\"deptId\":257,\"tenantId\":\"77864606\",\"overhaulTime\":1635868800000,\"remark\":\"\",\"params\":{}}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-22 10:03:15', '00000000');
INSERT INTO `sys_oper_log` VALUES (133, '用户管理', 1, 'com.ruoyi.web.controller.system.SysUserController.add()', 'POST', 1, 'lizong', NULL, '/system/user', '171.117.9.27', 'XX XX', '{\"phonenumber\":\"13456446789\",\"admin\":false,\"password\":\"$2a$10$00YXzwWhhQECW4bZWxCom.tbi5RTLcj.94EVVQCFT8y4KAUmKMp.O\",\"postIds\":[],\"nickName\":\"王总\",\"sex\":\"0\",\"params\":{},\"userName\":\"wangzong\",\"userId\":112,\"createBy\":\"lizong\",\"roleIds\":[2],\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-23 18:05:50', '00000000');
INSERT INTO `sys_oper_log` VALUES (134, '用户管理', 1, 'com.ruoyi.web.controller.system.SysUserController.add()', 'POST', 1, 'lizong', NULL, '/system/user', '171.117.9.27', 'XX XX', '{\"phonenumber\":\"15123234545\",\"admin\":false,\"password\":\"$2a$10$iUC.DqByZcAM6wV6txQh9O4dmBB0s4dLGg8wGFIEq4o5gX7T9Tkyu\",\"postIds\":[],\"nickName\":\"贾总\",\"sex\":\"0\",\"params\":{},\"userName\":\"jiazong\",\"userId\":113,\"createBy\":\"lizong\",\"roleIds\":[2],\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-23 18:12:00', '00000000');
INSERT INTO `sys_oper_log` VALUES (135, '用户管理', 1, 'com.ruoyi.web.controller.system.SysUserController.add()', 'POST', 1, 'lizong', NULL, '/system/user', '171.117.9.27', 'XX XX', '{\"phonenumber\":\"13456465676\",\"admin\":false,\"password\":\"$2a$10$m6O9qtBC3Luynjl7G4AlyO4ebUrtvD5UumVTamYkxhWvwKk54WkZ6\",\"postIds\":[],\"nickName\":\"谢总\",\"sex\":\"0\",\"params\":{},\"userName\":\"xiezong\",\"userId\":114,\"createBy\":\"lizong\",\"roleIds\":[2],\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-23 18:15:50', '00000000');
INSERT INTO `sys_oper_log` VALUES (136, '用户管理', 2, 'com.ruoyi.web.controller.system.SysUserController.edit()', 'PUT', 1, 'lizong', NULL, '/system/user', '171.117.9.27', 'XX XX', '{\"roles\":[{\"flag\":false,\"roleId\":2,\"admin\":false,\"dataScope\":\"1\",\"params\":{},\"roleSort\":\"2\",\"deptCheckStrictly\":false,\"menuCheckStrictly\":false,\"roleKey\":\"tenantAdmin\",\"roleName\":\"租户管理员\",\"status\":\"0\"}],\"phonenumber\":\"13456465676\",\"admin\":false,\"delFlag\":\"0\",\"password\":\"\",\"updateBy\":\"lizong\",\"postIds\":[],\"loginIp\":\"\",\"email\":\"\",\"nickName\":\"谢总\",\"sex\":\"1\",\"avatar\":\"\",\"params\":{},\"userName\":\"xiezong\",\"userId\":114,\"createBy\":\"lizong\",\"roleIds\":[2],\"createTime\":1637662550000,\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-23 18:16:05', '00000000');
INSERT INTO `sys_oper_log` VALUES (137, '租户管理', 1, 'com.ruoyi.web.controller.system.SysTenantController.add()', 'POST', 1, 'admin', NULL, '/system/tenant', '218.26.34.122', 'XX XX', '{\"params\":{},\"userName\":\"admin\",\"userId\":115,\"phone\":\"15735875238\",\"contact\":\"田宇\",\"name\":\"山西国峰煤电有限责任公司\",\"tenantId\":\"24630394\",\"id\":11}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-29 10:23:59', '00000000');
INSERT INTO `sys_oper_log` VALUES (138, '锅炉管理', 1, 'com.ruoyi.web.controller.system.SysDeptController.add()', 'POST', 1, 'admin', NULL, '/system/dept', '218.26.34.122', 'XX XX', '{\"deptName\":\"2号锅炉\",\"children\":[],\"ancestors\":\"0\",\"params\":{},\"parentId\":0,\"createBy\":\"admin\",\"tenantId\":\"00000000\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-29 10:24:34', '00000000');
INSERT INTO `sys_oper_log` VALUES (139, '检修', 1, 'com.ruoyi.web.controller.system.OverhaulController.add()', 'POST', 1, 'admin', NULL, '/system/overhaul', '218.26.34.122', 'XX XX', '{\"createBy\":\"田宇\",\"createTime\":1638152993799,\"deptId\":266,\"tenantId\":\"00000000\",\"overhaulTime\":1638115200000,\"remark\":\"\",\"params\":{}}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-29 10:29:53', '00000000');
INSERT INTO `sys_oper_log` VALUES (140, '锅炉管理', 1, 'com.ruoyi.web.controller.system.SysDeptController.add()', 'POST', 1, 'admin', NULL, '/system/dept', '218.26.34.122', 'XX XX', '{\"deptName\":\"1层\",\"children\":[],\"ancestors\":\"0,266\",\"params\":{},\"parentId\":266,\"createBy\":\"admin\",\"tenantId\":\"00000000\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-29 10:31:27', '00000000');
INSERT INTO `sys_oper_log` VALUES (141, '锅炉管理', 3, 'com.ruoyi.web.controller.system.SysDeptController.remove()', 'DELETE', 1, 'admin', NULL, '/system/dept/267', '218.26.34.122', 'XX XX', '{deptId=267}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-29 10:31:35', '00000000');
INSERT INTO `sys_oper_log` VALUES (142, '锅炉管理', 1, 'com.ruoyi.web.controller.system.SysDeptController.add()', 'POST', 1, 'lizong', NULL, '/system/dept', '218.26.34.122', 'XX XX', '{\"deptName\":\"3号锅炉\",\"children\":[],\"ancestors\":\"0\",\"params\":{},\"parentId\":0,\"createBy\":\"lizong\",\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-29 11:07:11', '00000000');
INSERT INTO `sys_oper_log` VALUES (143, '锅炉管理', 1, 'com.ruoyi.web.controller.system.SysDeptController.add()', 'POST', 1, 'lizong', NULL, '/system/dept', '218.26.34.122', 'XX XX', '{\"deptName\":\"3号\",\"children\":[],\"ancestors\":\"0,257,258,259\",\"params\":{},\"parentId\":259,\"createBy\":\"lizong\",\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-29 11:08:16', '00000000');
INSERT INTO `sys_oper_log` VALUES (144, '用户头像', 2, 'com.ruoyi.web.controller.system.SysProfileController.avatar()', 'POST', 1, 'lizong', NULL, '/system/user/profile/avatar', '218.26.34.122', 'XX XX', '', '{\"msg\":\"操作成功\",\"imgUrl\":\"/profile/avatar/2021/11/29/9644478f-5f27-43b4-b790-086e4a4d858f.jpeg\",\"code\":200}', 0, NULL, '2021-11-29 11:18:01', '00000000');
INSERT INTO `sys_oper_log` VALUES (145, '角色管理', 1, 'com.ruoyi.web.controller.system.SysRoleController.add()', 'POST', 1, 'admin', NULL, '/system/role', '183.191.125.119', 'XX XX', '{\"flag\":false,\"admin\":false,\"params\":{},\"roleSort\":\"3\",\"deptCheckStrictly\":true,\"menuCheckStrictly\":true,\"roleKey\":\"admin\",\"roleName\":\"管理员\",\"deptIds\":[],\"menuIds\":[1,2000,2001,2002,2003,2004,2005,100,1001,1002,1003,1004,1005,1006,1007,101,1008,1009,1010,1011,1012,102,1013,1014,1015,1016,107,1036,1037,1038,1039,108,500,1040,1041,1042,501,1043,1044,1045,2006,2007,2008,2009,2010,2011],\"status\":\"0\"}', '{\"msg\":\"新增角色\'管理员\'失败，角色权限已存在\",\"code\":500}', 0, NULL, '2021-11-29 13:30:26', '00000000');
INSERT INTO `sys_oper_log` VALUES (146, '角色管理', 1, 'com.ruoyi.web.controller.system.SysRoleController.add()', 'POST', 1, 'admin', NULL, '/system/role', '183.191.125.119', 'XX XX', '{\"flag\":false,\"roleId\":101,\"admin\":false,\"params\":{},\"roleSort\":\"3\",\"deptCheckStrictly\":true,\"createBy\":\"admin\",\"menuCheckStrictly\":true,\"roleKey\":\"system_admin\",\"roleName\":\"管理员\",\"deptIds\":[],\"menuIds\":[1,2000,2001,2002,2003,2004,2005,100,1001,1002,1003,1004,1005,1006,1007,101,1008,1009,1010,1011,1012,102,1013,1014,1015,1016,107,1036,1037,1038,1039,108,500,1040,1041,1042,501,1043,1044,1045,2006,2007,2008,2009,2010,2011],\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-29 13:31:06', '00000000');
INSERT INTO `sys_oper_log` VALUES (147, '通知公告', 3, 'com.ruoyi.web.controller.system.SysNoticeController.remove()', 'DELETE', 1, 'admin', NULL, '/system/notice/1', '183.191.125.119', 'XX XX', '{noticeIds=1}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-29 13:33:19', '00000000');
INSERT INTO `sys_oper_log` VALUES (148, '通知公告', 3, 'com.ruoyi.web.controller.system.SysNoticeController.remove()', 'DELETE', 1, 'admin', NULL, '/system/notice/2', '183.191.125.119', 'XX XX', '{noticeIds=2}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-29 13:33:22', '00000000');
INSERT INTO `sys_oper_log` VALUES (149, '租户管理', 1, 'com.ruoyi.web.controller.system.SysTenantController.add()', 'POST', 1, 'admin', NULL, '/system/tenant', '183.191.125.119', 'XX XX', '{\"params\":{},\"userName\":\"test\",\"userId\":116,\"phone\":\"13244556654\",\"contact\":\"test\",\"name\":\"测试电厂\",\"tenantId\":\"10579932\",\"id\":12}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-29 13:35:23', '00000000');
INSERT INTO `sys_oper_log` VALUES (150, '角色管理', 2, 'com.ruoyi.web.controller.system.SysRoleController.edit()', 'PUT', 1, 'admin', NULL, '/system/role', '183.191.125.119', 'XX XX', '{\"flag\":false,\"roleId\":2,\"admin\":false,\"dataScope\":\"4\",\"delFlag\":\"0\",\"params\":{},\"roleSort\":\"2\",\"deptCheckStrictly\":true,\"createTime\":1633677378000,\"updateBy\":\"admin\",\"menuCheckStrictly\":true,\"roleKey\":\"tenantAdmin\",\"roleName\":\"租户管理员\",\"tenantId\":\"00000000\",\"menuIds\":[1,100,1001,1002,1003,1004,1005,1006,1007,101,1008,1009,1010,1011,1012,107,1036,1037,1038,1039,108,500,1040,1041,1042,501,1043,1044,1045],\"status\":\"0\"}', NULL, 1, 'nested exception is org.apache.ibatis.exceptions.TooManyResultsException: Expected one result (or null) to be returned by selectOne(), but found: 2', '2021-11-29 14:03:51', '00000000');
INSERT INTO `sys_oper_log` VALUES (151, '角色管理', 2, 'com.ruoyi.web.controller.system.SysRoleController.edit()', 'PUT', 1, 'admin', NULL, '/system/role', '183.191.125.119', 'XX XX', '{\"flag\":false,\"roleId\":2,\"admin\":false,\"dataScope\":\"4\",\"delFlag\":\"0\",\"params\":{},\"roleSort\":\"2\",\"deptCheckStrictly\":true,\"createTime\":1633677378000,\"updateBy\":\"admin\",\"menuCheckStrictly\":true,\"roleKey\":\"tenantAdmin\",\"roleName\":\"租户管理员\",\"tenantId\":\"00000000\",\"menuIds\":[1,100,1001,1002,1003,1004,1005,1006,1007,107,1036,1037,1038,1039,108,500,1040,1041,1042,501,1043,1044,1045],\"status\":\"0\"}', NULL, 1, 'nested exception is org.apache.ibatis.exceptions.TooManyResultsException: Expected one result (or null) to be returned by selectOne(), but found: 2', '2021-11-29 14:04:04', '00000000');
INSERT INTO `sys_oper_log` VALUES (152, '角色管理', 2, 'com.ruoyi.web.controller.system.SysRoleController.edit()', 'PUT', 1, 'admin', NULL, '/system/role', '183.191.125.119', 'XX XX', '{\"flag\":false,\"roleId\":2,\"admin\":false,\"dataScope\":\"4\",\"delFlag\":\"0\",\"params\":{},\"roleSort\":\"2\",\"deptCheckStrictly\":true,\"createTime\":1633677378000,\"updateBy\":\"admin\",\"menuCheckStrictly\":true,\"roleKey\":\"tenantAdmin\",\"roleName\":\"租户管理员\",\"tenantId\":\"00000000\",\"menuIds\":[1,100,1001,1002,1003,1004,1005,1006,1007,107,1036,1037,1038,1039,108,500,1040,1041,1042,501,1043,1044,1045],\"status\":\"0\"}', NULL, 1, 'nested exception is org.apache.ibatis.exceptions.TooManyResultsException: Expected one result (or null) to be returned by selectOne(), but found: 2', '2021-11-29 14:04:17', '00000000');
INSERT INTO `sys_oper_log` VALUES (153, '角色管理', 2, 'com.ruoyi.web.controller.system.SysRoleController.edit()', 'PUT', 1, 'admin', NULL, '/system/role', '183.191.125.119', 'XX XX', '{\"flag\":false,\"roleId\":2,\"admin\":false,\"dataScope\":\"4\",\"delFlag\":\"0\",\"params\":{},\"roleSort\":\"2\",\"deptCheckStrictly\":true,\"createTime\":1633677378000,\"updateBy\":\"admin\",\"menuCheckStrictly\":true,\"roleKey\":\"tenantAdmin\",\"roleName\":\"租户管理员\",\"tenantId\":\"00000000\",\"menuIds\":[1,100,1001,1002,1003,1004,1005,1006,1007,107,1036,1037,1038,1039,108,500,1040,1041,1042,501,1043,1044,1045],\"status\":\"0\"}', NULL, 1, 'nested exception is org.apache.ibatis.exceptions.TooManyResultsException: Expected one result (or null) to be returned by selectOne(), but found: 2', '2021-11-29 14:05:30', '00000000');
INSERT INTO `sys_oper_log` VALUES (154, '角色管理', 2, 'com.ruoyi.web.controller.system.SysRoleController.edit()', 'PUT', 1, 'admin', NULL, '/system/role', '183.191.125.119', 'XX XX', '{\"flag\":false,\"roleId\":101,\"admin\":false,\"dataScope\":\"1\",\"delFlag\":\"0\",\"params\":{},\"roleSort\":\"3\",\"deptCheckStrictly\":true,\"createTime\":1638163866000,\"updateBy\":\"admin\",\"menuCheckStrictly\":true,\"roleKey\":\"systemAdmin\",\"roleName\":\"管理员\",\"tenantId\":\"00000000\",\"menuIds\":[1,2000,2001,2002,2003,2004,2005,100,1001,1002,1003,1004,1005,1006,1007,101,1008,1009,1010,1011,1012,102,1013,1014,1015,1016,107,1036,1037,1038,1039,108,500,1040,1041,1042,501,1043,1044,1045,2006,2007,2008,2009,2010,2011],\"status\":\"0\"}', NULL, 1, 'nested exception is org.apache.ibatis.exceptions.TooManyResultsException: Expected one result (or null) to be returned by selectOne(), but found: 2', '2021-11-29 14:06:44', '00000000');
INSERT INTO `sys_oper_log` VALUES (155, '角色管理', 2, 'com.ruoyi.web.controller.system.SysRoleController.edit()', 'PUT', 1, 'admin', NULL, '/system/role', '183.191.125.119', 'XX XX', '{\"flag\":false,\"roleId\":2,\"admin\":false,\"dataScope\":\"4\",\"delFlag\":\"0\",\"params\":{},\"roleSort\":\"2\",\"deptCheckStrictly\":true,\"createTime\":1633677378000,\"updateBy\":\"admin\",\"menuCheckStrictly\":true,\"roleKey\":\"tenantAdmin\",\"roleName\":\"租户管理员\",\"tenantId\":\"00000000\",\"menuIds\":[1,100,1001,1002,1003,1004,1005,1006,1007,107,1036,1037,1038,1039,108,500,1040,1041,1042,501,1043,1044,1045],\"status\":\"0\"}', NULL, 1, 'nested exception is org.apache.ibatis.exceptions.TooManyResultsException: Expected one result (or null) to be returned by selectOne(), but found: 2', '2021-11-29 14:08:21', '00000000');
INSERT INTO `sys_oper_log` VALUES (156, '角色管理', 2, 'com.ruoyi.web.controller.system.SysRoleController.edit()', 'PUT', 1, 'admin', NULL, '/system/role', '127.0.0.1', '内网IP', '{\"flag\":false,\"roleId\":2,\"admin\":false,\"dataScope\":\"4\",\"delFlag\":\"0\",\"params\":{},\"roleSort\":\"2\",\"deptCheckStrictly\":true,\"createTime\":1633677378000,\"updateBy\":\"admin\",\"menuCheckStrictly\":true,\"roleKey\":\"tenantAdmin\",\"roleName\":\"租户管理员\",\"tenantId\":\"00000000\",\"menuIds\":[1,100,1001,1002,1003,1004,1005,1006,1007,107,1036,1037,1038,1039,108,500,1040,1041,1042,501,1043,1044,1045],\"status\":\"0\"}', NULL, 1, 'nested exception is org.apache.ibatis.exceptions.TooManyResultsException: Expected one result (or null) to be returned by selectOne(), but found: 2', '2021-11-29 14:12:03', '00000000');
INSERT INTO `sys_oper_log` VALUES (157, '角色管理', 2, 'com.ruoyi.web.controller.system.SysRoleController.edit()', 'PUT', 1, 'admin', NULL, '/system/role', '127.0.0.1', '内网IP', '{\"flag\":false,\"roleId\":2,\"admin\":false,\"dataScope\":\"4\",\"delFlag\":\"0\",\"params\":{},\"roleSort\":\"2\",\"deptCheckStrictly\":true,\"createTime\":1633677378000,\"updateBy\":\"admin\",\"menuCheckStrictly\":true,\"roleKey\":\"tenantAdmin\",\"roleName\":\"租户管理员\",\"tenantId\":\"00000000\",\"menuIds\":[1,100,1001,1002,1003,1004,1005,1006,1007,107,1036,1037,1038,1039,108,500,1040,1041,1042,501,1043,1044,1045],\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-29 14:15:53', '00000000');
INSERT INTO `sys_oper_log` VALUES (158, '角色管理', 2, 'com.ruoyi.web.controller.system.SysRoleController.edit()', 'PUT', 1, 'admin', NULL, '/system/role', '183.191.125.119', 'XX XX', '{\"flag\":false,\"roleId\":2,\"admin\":false,\"dataScope\":\"4\",\"delFlag\":\"0\",\"params\":{},\"roleSort\":\"2\",\"deptCheckStrictly\":true,\"createTime\":1633677378000,\"updateBy\":\"admin\",\"menuCheckStrictly\":true,\"roleKey\":\"tenantAdmin\",\"roleName\":\"租户管理员\",\"tenantId\":\"00000000\",\"menuIds\":[1,100,1001,1002,1003,1004,1005,1006,1007,103,1017,1018,1019,1020,107,1036,1037,1038,1039,108,500,1040,1041,1042,501,1043,1044,1045,2043,2044,2045,2046,2047],\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-11-29 14:25:02', '00000000');
INSERT INTO `sys_oper_log` VALUES (159, '标注新增', 1, 'com.ruoyi.web.controller.system.MarkController.add()', 'POST', 1, 'lizong', NULL, '/system/mark', '183.200.20.48', 'XX XX', '{\"createTime\":1639307337434,\"deptId\":263,\"overhaulId\":3,\"remark\":\"11\",\"id\":3,\"params\":{}}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-12-12 19:08:57', '00000000');
INSERT INTO `sys_oper_log` VALUES (160, '锅炉管理', 1, 'com.ruoyi.web.controller.system.SysDeptController.add()', 'POST', 1, 'lizong', NULL, '/system/dept', '183.200.20.48', 'XX XX', '{\"deptName\":\"1\",\"children\":[],\"ancestors\":\"0,257,258,260\",\"params\":{},\"parentId\":260,\"createBy\":\"lizong\",\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-12-12 19:25:30', '00000000');
INSERT INTO `sys_oper_log` VALUES (161, '标注修改', 2, 'com.ruoyi.web.controller.system.MarkController.edit()', 'PUT', 1, 'lizong', NULL, '/system/mark', '183.200.20.48', 'XX XX', '{\"remark\":\"\",\"updateTime\":1639308518090,\"id\":1,\"params\":{}}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-12-12 19:28:38', '00000000');
INSERT INTO `sys_oper_log` VALUES (162, '标注新增', 1, 'com.ruoyi.web.controller.system.MarkController.add()', 'POST', 1, 'lizong', NULL, '/system/mark', '183.200.20.48', 'XX XX', '{\"createTime\":1639308530347,\"deptId\":269,\"overhaulId\":2,\"remark\":\"1\",\"id\":4,\"params\":{}}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-12-12 19:28:50', '00000000');
INSERT INTO `sys_oper_log` VALUES (163, '标注修改', 2, 'com.ruoyi.web.controller.system.MarkController.edit()', 'PUT', 1, 'lizong', NULL, '/system/mark', '183.200.20.48', 'XX XX', '{\"remark\":\"\",\"updateTime\":1639308534579,\"id\":4,\"params\":{}}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-12-12 19:28:54', '00000000');
INSERT INTO `sys_oper_log` VALUES (164, '标注修改', 2, 'com.ruoyi.web.controller.system.MarkController.edit()', 'PUT', 1, 'lizong', NULL, '/system/mark', '183.200.20.48', 'XX XX', '{\"remark\":\"\",\"updateTime\":1639308934146,\"id\":2,\"params\":{}}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-12-12 19:35:34', '00000000');
INSERT INTO `sys_oper_log` VALUES (165, '锅炉管理', 1, 'com.ruoyi.web.controller.system.SysDeptController.add()', 'POST', 1, 'lizong', NULL, '/system/dept', '218.26.34.87', 'XX XX', '{\"deptName\":\"4号\",\"children\":[],\"ancestors\":\"0,257,258,259,269\",\"params\":{},\"parentId\":269,\"createBy\":\"lizong\",\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-12-13 16:29:21', '00000000');
INSERT INTO `sys_oper_log` VALUES (166, '锅炉管理', 3, 'com.ruoyi.web.controller.system.SysDeptController.remove()', 'DELETE', 1, 'lizong', NULL, '/system/dept/271', '218.26.34.87', 'XX XX', '{deptId=271}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-12-13 16:29:28', '00000000');
INSERT INTO `sys_oper_log` VALUES (167, '锅炉管理', 1, 'com.ruoyi.web.controller.system.SysDeptController.add()', 'POST', 1, 'lizong', NULL, '/system/dept', '218.26.34.87', 'XX XX', '{\"deptName\":\"4号\",\"children\":[],\"ancestors\":\"0,257,258,259\",\"params\":{},\"parentId\":259,\"createBy\":\"lizong\",\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-12-13 16:29:39', '00000000');
INSERT INTO `sys_oper_log` VALUES (168, '锅炉管理', 1, 'com.ruoyi.web.controller.system.SysDeptController.add()', 'POST', 1, 'lizong', NULL, '/system/dept', '218.26.34.87', 'XX XX', '{\"deptName\":\"5号\",\"children\":[],\"ancestors\":\"0,257,258,259\",\"params\":{},\"parentId\":259,\"createBy\":\"lizong\",\"tenantId\":\"77864606\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2021-12-13 16:29:48', '00000000');
COMMIT;

-- ----------------------------
-- Table structure for sys_post
-- ----------------------------
DROP TABLE IF EXISTS `sys_post`;
CREATE TABLE `sys_post` (
  `post_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '岗位ID',
  `post_code` varchar(64) NOT NULL COMMENT '岗位编码',
  `post_name` varchar(50) NOT NULL COMMENT '岗位名称',
  `post_sort` int(4) NOT NULL COMMENT '显示顺序',
  `status` char(1) NOT NULL COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `tenant_id` varchar(8) NOT NULL DEFAULT '00000000',
  PRIMARY KEY (`post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COMMENT='岗位信息表';

-- ----------------------------
-- Records of sys_post
-- ----------------------------
BEGIN;
INSERT INTO `sys_post` VALUES (1, 'ceo', '董事长', 1, '0', 'admin', '2021-09-21 17:00:36', '', NULL, '', '00000000');
INSERT INTO `sys_post` VALUES (2, 'se', '项目经理', 2, '0', 'admin', '2021-09-21 17:00:37', '', NULL, '', '00000000');
INSERT INTO `sys_post` VALUES (3, 'hr', '人力资源', 3, '0', 'admin', '2021-09-21 17:00:37', '', NULL, '', '00000000');
INSERT INTO `sys_post` VALUES (4, 'user', '普通员工', 4, '0', 'admin', '2021-09-21 17:00:38', '', NULL, '', '00000000');
COMMIT;

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_role`;
CREATE TABLE `sys_role` (
  `role_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) NOT NULL COMMENT '角色名称',
  `role_key` varchar(100) NOT NULL COMMENT '角色权限字符串',
  `role_sort` int(4) NOT NULL COMMENT '显示顺序',
  `data_scope` char(1) DEFAULT '1' COMMENT '数据范围（1：全部数据权限 2：自定数据权限 3：本部门数据权限 4：本部门及以下数据权限）',
  `menu_check_strictly` tinyint(1) DEFAULT '1' COMMENT '菜单树选择项是否关联显示',
  `dept_check_strictly` tinyint(1) DEFAULT '1' COMMENT '部门树选择项是否关联显示',
  `status` char(1) NOT NULL COMMENT '角色状态（0正常 1停用）',
  `del_flag` char(1) DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `tenant_id` varchar(8) NOT NULL DEFAULT '00000000',
  PRIMARY KEY (`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COMMENT='角色信息表';

-- ----------------------------
-- Records of sys_role
-- ----------------------------
BEGIN;
INSERT INTO `sys_role` VALUES (1, '超级管理员', 'admin', 1, '1', 1, 1, '0', '0', 'admin', '2021-09-21 17:00:39', '', NULL, '超级管理员', '00000000');
INSERT INTO `sys_role` VALUES (2, '租户管理员', 'tenantAdmin', 2, '1', 1, 1, '0', '0', 'admin', '2021-10-08 15:16:18', 'admin', '2021-11-29 14:25:02', NULL, '00000000');
INSERT INTO `sys_role` VALUES (3, '普通角色', 'common', 3, '2', 1, 1, '0', '2', 'admin', '2021-09-21 17:00:39', 'admin', '2021-10-25 11:39:38', '普通角色', '00000000');
INSERT INTO `sys_role` VALUES (101, '管理员', 'systemAdmin', 3, '1', 1, 1, '0', '0', 'admin', '2021-11-29 13:31:06', 'admin', '2021-11-29 14:06:44', NULL, '00000000');
COMMIT;

-- ----------------------------
-- Table structure for sys_role_data_rule
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_data_rule`;
CREATE TABLE `sys_role_data_rule` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `data_rule_category` int(2) DEFAULT NULL COMMENT '权限类型(1:数据权限、2:接口权限)',
  `data_rule_id` varchar(64) DEFAULT NULL COMMENT '权限id',
  `role_id` varchar(64) DEFAULT NULL COMMENT '角色id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COMMENT='角色数据权限关联表';

-- ----------------------------
-- Records of sys_role_data_rule
-- ----------------------------
BEGIN;
INSERT INTO `sys_role_data_rule` VALUES (6, NULL, '2', '2');
INSERT INTO `sys_role_data_rule` VALUES (7, NULL, '1', '2');
COMMIT;

-- ----------------------------
-- Table structure for sys_role_dept
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_dept`;
CREATE TABLE `sys_role_dept` (
  `role_id` bigint(20) NOT NULL COMMENT '角色ID',
  `dept_id` bigint(20) NOT NULL COMMENT '部门ID',
  PRIMARY KEY (`role_id`,`dept_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='角色和部门关联表';

-- ----------------------------
-- Table structure for sys_role_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_menu`;
CREATE TABLE `sys_role_menu` (
  `role_id` bigint(20) NOT NULL COMMENT '角色ID',
  `menu_id` bigint(20) NOT NULL COMMENT '菜单ID',
  PRIMARY KEY (`role_id`,`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='角色和菜单关联表';

-- ----------------------------
-- Records of sys_role_menu
-- ----------------------------
BEGIN;
INSERT INTO `sys_role_menu` VALUES (1, 1);
INSERT INTO `sys_role_menu` VALUES (2, 1);
INSERT INTO `sys_role_menu` VALUES (2, 100);
INSERT INTO `sys_role_menu` VALUES (2, 103);
INSERT INTO `sys_role_menu` VALUES (2, 107);
INSERT INTO `sys_role_menu` VALUES (2, 108);
INSERT INTO `sys_role_menu` VALUES (2, 500);
INSERT INTO `sys_role_menu` VALUES (2, 501);
INSERT INTO `sys_role_menu` VALUES (2, 1001);
INSERT INTO `sys_role_menu` VALUES (2, 1002);
INSERT INTO `sys_role_menu` VALUES (2, 1003);
INSERT INTO `sys_role_menu` VALUES (2, 1004);
INSERT INTO `sys_role_menu` VALUES (2, 1005);
INSERT INTO `sys_role_menu` VALUES (2, 1006);
INSERT INTO `sys_role_menu` VALUES (2, 1007);
INSERT INTO `sys_role_menu` VALUES (2, 1017);
INSERT INTO `sys_role_menu` VALUES (2, 1018);
INSERT INTO `sys_role_menu` VALUES (2, 1019);
INSERT INTO `sys_role_menu` VALUES (2, 1020);
INSERT INTO `sys_role_menu` VALUES (2, 1036);
INSERT INTO `sys_role_menu` VALUES (2, 1037);
INSERT INTO `sys_role_menu` VALUES (2, 1038);
INSERT INTO `sys_role_menu` VALUES (2, 1039);
INSERT INTO `sys_role_menu` VALUES (2, 1040);
INSERT INTO `sys_role_menu` VALUES (2, 1041);
INSERT INTO `sys_role_menu` VALUES (2, 1042);
INSERT INTO `sys_role_menu` VALUES (2, 1043);
INSERT INTO `sys_role_menu` VALUES (2, 1044);
INSERT INTO `sys_role_menu` VALUES (2, 1045);
INSERT INTO `sys_role_menu` VALUES (2, 2043);
INSERT INTO `sys_role_menu` VALUES (2, 2044);
INSERT INTO `sys_role_menu` VALUES (2, 2045);
INSERT INTO `sys_role_menu` VALUES (2, 2046);
INSERT INTO `sys_role_menu` VALUES (2, 2047);
INSERT INTO `sys_role_menu` VALUES (100, 1);
INSERT INTO `sys_role_menu` VALUES (100, 2);
INSERT INTO `sys_role_menu` VALUES (100, 3);
INSERT INTO `sys_role_menu` VALUES (100, 100);
INSERT INTO `sys_role_menu` VALUES (100, 101);
INSERT INTO `sys_role_menu` VALUES (100, 102);
INSERT INTO `sys_role_menu` VALUES (100, 103);
INSERT INTO `sys_role_menu` VALUES (100, 104);
INSERT INTO `sys_role_menu` VALUES (100, 105);
INSERT INTO `sys_role_menu` VALUES (100, 106);
INSERT INTO `sys_role_menu` VALUES (100, 107);
INSERT INTO `sys_role_menu` VALUES (100, 108);
INSERT INTO `sys_role_menu` VALUES (100, 109);
INSERT INTO `sys_role_menu` VALUES (100, 110);
INSERT INTO `sys_role_menu` VALUES (100, 111);
INSERT INTO `sys_role_menu` VALUES (100, 112);
INSERT INTO `sys_role_menu` VALUES (100, 113);
INSERT INTO `sys_role_menu` VALUES (100, 114);
INSERT INTO `sys_role_menu` VALUES (100, 115);
INSERT INTO `sys_role_menu` VALUES (100, 116);
INSERT INTO `sys_role_menu` VALUES (100, 500);
INSERT INTO `sys_role_menu` VALUES (100, 501);
INSERT INTO `sys_role_menu` VALUES (100, 1001);
INSERT INTO `sys_role_menu` VALUES (100, 1002);
INSERT INTO `sys_role_menu` VALUES (100, 1003);
INSERT INTO `sys_role_menu` VALUES (100, 1004);
INSERT INTO `sys_role_menu` VALUES (100, 1005);
INSERT INTO `sys_role_menu` VALUES (100, 1006);
INSERT INTO `sys_role_menu` VALUES (100, 1007);
INSERT INTO `sys_role_menu` VALUES (100, 1008);
INSERT INTO `sys_role_menu` VALUES (100, 1009);
INSERT INTO `sys_role_menu` VALUES (100, 1010);
INSERT INTO `sys_role_menu` VALUES (100, 1011);
INSERT INTO `sys_role_menu` VALUES (100, 1012);
INSERT INTO `sys_role_menu` VALUES (100, 1013);
INSERT INTO `sys_role_menu` VALUES (100, 1014);
INSERT INTO `sys_role_menu` VALUES (100, 1015);
INSERT INTO `sys_role_menu` VALUES (100, 1016);
INSERT INTO `sys_role_menu` VALUES (100, 1017);
INSERT INTO `sys_role_menu` VALUES (100, 1018);
INSERT INTO `sys_role_menu` VALUES (100, 1019);
INSERT INTO `sys_role_menu` VALUES (100, 1020);
INSERT INTO `sys_role_menu` VALUES (100, 1021);
INSERT INTO `sys_role_menu` VALUES (100, 1022);
INSERT INTO `sys_role_menu` VALUES (100, 1023);
INSERT INTO `sys_role_menu` VALUES (100, 1024);
INSERT INTO `sys_role_menu` VALUES (100, 1025);
INSERT INTO `sys_role_menu` VALUES (100, 1026);
INSERT INTO `sys_role_menu` VALUES (100, 1027);
INSERT INTO `sys_role_menu` VALUES (100, 1028);
INSERT INTO `sys_role_menu` VALUES (100, 1029);
INSERT INTO `sys_role_menu` VALUES (100, 1030);
INSERT INTO `sys_role_menu` VALUES (100, 1031);
INSERT INTO `sys_role_menu` VALUES (100, 1032);
INSERT INTO `sys_role_menu` VALUES (100, 1033);
INSERT INTO `sys_role_menu` VALUES (100, 1034);
INSERT INTO `sys_role_menu` VALUES (100, 1035);
INSERT INTO `sys_role_menu` VALUES (100, 1036);
INSERT INTO `sys_role_menu` VALUES (100, 1037);
INSERT INTO `sys_role_menu` VALUES (100, 1038);
INSERT INTO `sys_role_menu` VALUES (100, 1039);
INSERT INTO `sys_role_menu` VALUES (100, 1040);
INSERT INTO `sys_role_menu` VALUES (100, 1041);
INSERT INTO `sys_role_menu` VALUES (100, 1042);
INSERT INTO `sys_role_menu` VALUES (100, 1043);
INSERT INTO `sys_role_menu` VALUES (100, 1044);
INSERT INTO `sys_role_menu` VALUES (100, 1045);
INSERT INTO `sys_role_menu` VALUES (100, 1046);
INSERT INTO `sys_role_menu` VALUES (100, 1047);
INSERT INTO `sys_role_menu` VALUES (100, 1048);
INSERT INTO `sys_role_menu` VALUES (100, 1049);
INSERT INTO `sys_role_menu` VALUES (100, 1050);
INSERT INTO `sys_role_menu` VALUES (100, 1051);
INSERT INTO `sys_role_menu` VALUES (100, 1052);
INSERT INTO `sys_role_menu` VALUES (100, 1053);
INSERT INTO `sys_role_menu` VALUES (100, 1054);
INSERT INTO `sys_role_menu` VALUES (100, 1055);
INSERT INTO `sys_role_menu` VALUES (100, 1056);
INSERT INTO `sys_role_menu` VALUES (100, 1057);
INSERT INTO `sys_role_menu` VALUES (100, 1058);
INSERT INTO `sys_role_menu` VALUES (100, 1059);
INSERT INTO `sys_role_menu` VALUES (100, 1060);
INSERT INTO `sys_role_menu` VALUES (101, 1);
INSERT INTO `sys_role_menu` VALUES (101, 100);
INSERT INTO `sys_role_menu` VALUES (101, 101);
INSERT INTO `sys_role_menu` VALUES (101, 102);
INSERT INTO `sys_role_menu` VALUES (101, 107);
INSERT INTO `sys_role_menu` VALUES (101, 108);
INSERT INTO `sys_role_menu` VALUES (101, 500);
INSERT INTO `sys_role_menu` VALUES (101, 501);
INSERT INTO `sys_role_menu` VALUES (101, 1001);
INSERT INTO `sys_role_menu` VALUES (101, 1002);
INSERT INTO `sys_role_menu` VALUES (101, 1003);
INSERT INTO `sys_role_menu` VALUES (101, 1004);
INSERT INTO `sys_role_menu` VALUES (101, 1005);
INSERT INTO `sys_role_menu` VALUES (101, 1006);
INSERT INTO `sys_role_menu` VALUES (101, 1007);
INSERT INTO `sys_role_menu` VALUES (101, 1008);
INSERT INTO `sys_role_menu` VALUES (101, 1009);
INSERT INTO `sys_role_menu` VALUES (101, 1010);
INSERT INTO `sys_role_menu` VALUES (101, 1011);
INSERT INTO `sys_role_menu` VALUES (101, 1012);
INSERT INTO `sys_role_menu` VALUES (101, 1013);
INSERT INTO `sys_role_menu` VALUES (101, 1014);
INSERT INTO `sys_role_menu` VALUES (101, 1015);
INSERT INTO `sys_role_menu` VALUES (101, 1016);
INSERT INTO `sys_role_menu` VALUES (101, 1036);
INSERT INTO `sys_role_menu` VALUES (101, 1037);
INSERT INTO `sys_role_menu` VALUES (101, 1038);
INSERT INTO `sys_role_menu` VALUES (101, 1039);
INSERT INTO `sys_role_menu` VALUES (101, 1040);
INSERT INTO `sys_role_menu` VALUES (101, 1041);
INSERT INTO `sys_role_menu` VALUES (101, 1042);
INSERT INTO `sys_role_menu` VALUES (101, 1043);
INSERT INTO `sys_role_menu` VALUES (101, 1044);
INSERT INTO `sys_role_menu` VALUES (101, 1045);
INSERT INTO `sys_role_menu` VALUES (101, 2000);
INSERT INTO `sys_role_menu` VALUES (101, 2001);
INSERT INTO `sys_role_menu` VALUES (101, 2002);
INSERT INTO `sys_role_menu` VALUES (101, 2003);
INSERT INTO `sys_role_menu` VALUES (101, 2004);
INSERT INTO `sys_role_menu` VALUES (101, 2005);
INSERT INTO `sys_role_menu` VALUES (101, 2006);
INSERT INTO `sys_role_menu` VALUES (101, 2007);
INSERT INTO `sys_role_menu` VALUES (101, 2008);
INSERT INTO `sys_role_menu` VALUES (101, 2009);
INSERT INTO `sys_role_menu` VALUES (101, 2010);
INSERT INTO `sys_role_menu` VALUES (101, 2011);
COMMIT;

-- ----------------------------
-- Table structure for sys_tenant
-- ----------------------------
DROP TABLE IF EXISTS `sys_tenant`;
CREATE TABLE `sys_tenant` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '访问ID',
  `create_by` varchar(64) DEFAULT NULL COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(64) DEFAULT NULL COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `del_flag` char(1) DEFAULT NULL COMMENT '删除标识',
  `remark` text COMMENT '备注',
  `tenant_id` varchar(64) DEFAULT NULL COMMENT '租户标识',
  `contact` varchar(64) NOT NULL COMMENT '联系人',
  `phone` varchar(64) NOT NULL COMMENT '电话',
  `name` varchar(64) NOT NULL COMMENT '租户名称',
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COMMENT='租户管理';

-- ----------------------------
-- Records of sys_tenant
-- ----------------------------
BEGIN;
INSERT INTO `sys_tenant` VALUES (1, NULL, NULL, NULL, NULL, NULL, NULL, '00000000', 'sunseagear', '1311111111', 'sunseagear', '1');
INSERT INTO `sys_tenant` VALUES (10, NULL, NULL, NULL, NULL, NULL, NULL, '77864606', '李总', '13011112222', '演示电厂', '111');
INSERT INTO `sys_tenant` VALUES (11, NULL, NULL, NULL, NULL, NULL, NULL, '24630394', '田宇', '15735875238', '山西国峰煤电有限责任公司', '115');
INSERT INTO `sys_tenant` VALUES (12, NULL, NULL, NULL, NULL, NULL, NULL, '10579932', 'test', '13244556654', '测试电厂', '116');
COMMIT;

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user` (
  `user_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '用户ID',
  `dept_id` bigint(20) DEFAULT NULL COMMENT '部门ID',
  `user_name` varchar(30) NOT NULL COMMENT '用户账号',
  `nick_name` varchar(30) NOT NULL COMMENT '用户昵称',
  `user_type` varchar(2) DEFAULT '00' COMMENT '用户类型（00系统用户）',
  `email` varchar(50) DEFAULT '' COMMENT '用户邮箱',
  `phonenumber` varchar(11) DEFAULT '' COMMENT '手机号码',
  `sex` char(1) DEFAULT '0' COMMENT '用户性别（0男 1女 2未知）',
  `avatar` varchar(100) DEFAULT '' COMMENT '头像地址',
  `password` varchar(100) DEFAULT '' COMMENT '密码',
  `status` char(1) DEFAULT '0' COMMENT '帐号状态（0正常 1停用）',
  `del_flag` char(1) DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `login_ip` varchar(128) DEFAULT '' COMMENT '最后登录IP',
  `login_date` datetime DEFAULT NULL COMMENT '最后登录时间',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `tenant_id` varchar(8) NOT NULL DEFAULT '00000000',
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=117 DEFAULT CHARSET=utf8mb4 COMMENT='用户信息表';

-- ----------------------------
-- Records of sys_user
-- ----------------------------
BEGIN;
INSERT INTO `sys_user` VALUES (2, 103, 'admin', '若依', '00', 'ry@163.com', '15888888888', '1', '', '$2a$10$7JB720yubVSZvUI0rEqK/.VqGOZTH.ulu33dHOiBE8ByOhJIrdAu2', '0', '0', '218.26.34.87', '2021-12-10 15:18:55', 'admin', '2021-09-21 17:00:35', '', '2021-12-10 15:18:55', '管理员', '00000000');
INSERT INTO `sys_user` VALUES (111, NULL, 'lizong', '演示电厂', '00', '', '13011112222', '0', '/profile/avatar/2021/11/29/9644478f-5f27-43b4-b790-086e4a4d858f.jpeg', '$2a$10$CAPlE3bWV9b7Dh87w4sDuuxUXIJO3/L2sEv2uedHTQwuG3rB2T55.', '0', '0', '218.26.34.87', '2021-12-13 16:03:48', '', '2021-11-20 16:43:50', '', '2021-12-13 16:03:48', NULL, '77864606');
INSERT INTO `sys_user` VALUES (112, NULL, 'wangzong', '王总', '00', '', '13456446789', '0', '', '$2a$10$00YXzwWhhQECW4bZWxCom.tbi5RTLcj.94EVVQCFT8y4KAUmKMp.O', '0', '0', '183.191.125.119', '2021-11-29 10:32:04', 'lizong', '2021-11-23 18:05:50', '', '2021-11-29 10:32:04', NULL, '77864606');
INSERT INTO `sys_user` VALUES (113, NULL, 'jiazong', '贾总', '00', '', '15123234545', '0', '', '$2a$10$iUC.DqByZcAM6wV6txQh9O4dmBB0s4dLGg8wGFIEq4o5gX7T9Tkyu', '0', '0', '', NULL, 'lizong', '2021-11-23 18:12:00', '', NULL, NULL, '77864606');
INSERT INTO `sys_user` VALUES (114, NULL, 'xiezong', '谢总', '00', '', '13456465676', '1', '', '$2a$10$m6O9qtBC3Luynjl7G4AlyO4ebUrtvD5UumVTamYkxhWvwKk54WkZ6', '0', '0', '', NULL, 'lizong', '2021-11-23 18:15:50', 'lizong', '2021-11-23 18:16:05', NULL, '77864606');
INSERT INTO `sys_user` VALUES (115, NULL, 'admin', '山西国峰煤电有限责任公司', '00', '', '15735875238', '0', '', '$2a$10$ssrDOlhBxGzO0xbsPqki3urKFubFuNAZsVZbhZc0ONue7kBC7GPBG', '0', '0', '', NULL, '', '2021-11-29 10:23:59', '', NULL, NULL, '24630394');
INSERT INTO `sys_user` VALUES (116, NULL, 'test', '测试电厂', '00', '', '13244556654', '0', '', '$2a$10$6nQa02jBRF6EhugRYchyMOU/RhHVpufEl6ByoP/iCqETTCj9yVaea', '0', '0', '183.191.125.119', '2021-11-29 13:35:44', '', '2021-11-29 13:35:23', '', '2021-11-29 13:35:44', NULL, '10579932');
COMMIT;

-- ----------------------------
-- Table structure for sys_user_post
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_post`;
CREATE TABLE `sys_user_post` (
  `user_id` bigint(20) NOT NULL COMMENT '用户ID',
  `post_id` bigint(20) NOT NULL COMMENT '岗位ID',
  PRIMARY KEY (`user_id`,`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户与岗位关联表';

-- ----------------------------
-- Records of sys_user_post
-- ----------------------------
BEGIN;
INSERT INTO `sys_user_post` VALUES (1, 1);
INSERT INTO `sys_user_post` VALUES (2, 2);
COMMIT;

-- ----------------------------
-- Table structure for sys_user_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_role`;
CREATE TABLE `sys_user_role` (
  `user_id` bigint(20) NOT NULL COMMENT '用户ID',
  `role_id` bigint(20) NOT NULL COMMENT '角色ID',
  PRIMARY KEY (`user_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户和角色关联表';

-- ----------------------------
-- Records of sys_user_role
-- ----------------------------
BEGIN;
INSERT INTO `sys_user_role` VALUES (2, 101);
INSERT INTO `sys_user_role` VALUES (111, 2);
INSERT INTO `sys_user_role` VALUES (112, 2);
INSERT INTO `sys_user_role` VALUES (113, 2);
INSERT INTO `sys_user_role` VALUES (114, 2);
INSERT INTO `sys_user_role` VALUES (115, 2);
INSERT INTO `sys_user_role` VALUES (116, 2);
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;
